/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.dms.spy.Spy;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.PlatformSupport;
import oracle.dms.util.PlatformSupportFactory;
import oracle.dms.util.QueryOptions;

public abstract class DMSUtil {
    private static final String PIDNOTSET = "";
    private static String _pid = "";
    private static String _localhost = null;
    private static String _dmsMount = "dms0";
    private static volatile boolean _pidSet = false;
    private static final String COMP_PREFIX = "DMS-";
    private static final String ACTION = "-ACTION";
    private static final Pattern SCRIPT_START_PATTERN = Pattern.compile("<\\s*script\\s*>", 2);
    private static final Pattern SCRIPT_END_PATTERN = Pattern.compile("</\\s*script\\s*>", 2);
    private static final Logger LOGGER = Logger.getLogger("oracle.dms.collector", "oracle.dms.util.dms");
    public static final String LEGAL_IDENTIFIERS = "The following are valid identifiers, starting with a letter: \nLetters: a-z, A-Z, and other alphabetic characters from other languages. \nDigits: 0-9 \nSpecial: _ (underscore) and - (dash)";

    public static synchronized String getLocalHostname() {
        if (_localhost != null) {
            return _localhost;
        }
        _localhost = "localhost";
        try {
            String name = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws UnknownHostException {
                    return InetAddress.getLocalHost().getCanonicalHostName();
                }
            });
            if (name != null && (name = name.trim()).length() > 0) {
                _localhost = name;
            }
        }
        catch (PrivilegedActionException e) {
            return _localhost;
        }
        return _localhost;
    }

    public static void setProcessID(int pid) {
        if (pid <= 0) {
            return;
        }
        DMSUtil.setProcessID(Integer.toString(pid));
    }

    public static synchronized void setProcessID(String pid) {
        if (_pidSet || pid == null || pid.trim().length() == 0) {
            return;
        }
        _pid = pid;
        _pidSet = true;
    }

    public static synchronized String getProcessID() {
        if (PIDNOTSET.equals(_pid)) {
            int pid;
            while ((pid = (int)(Math.random() * 100000.0)) == 0) {
            }
            _pid = Integer.toString(pid);
        }
        return _pid;
    }

    public static String getProcessName() {
        return DMSUtil.getProcessName(Spy.getName(), DMSUtil.getProcessID());
    }

    public static String getProcessName(String name, String id) {
        if (name == null || name.trim().length() == 0 || id == null || id.trim().length() == 0) {
            return null;
        }
        String idString = ":" + id;
        StringBuilder procName = new StringBuilder(name);
        if (!name.endsWith(idString)) {
            procName.append(idString);
        }
        return procName.toString();
    }

    public static String sanitize(String s, int length, boolean spacesToo, boolean dotToo) {
        if (s == null || length <= 0) {
            return PIDNOTSET;
        }
        if (length < s.length()) {
            StringBuilder sb = new StringBuilder(s);
            sb.setLength(length);
            return DMSUtil.sanitize(sb, spacesToo, dotToo, 0);
        }
        length = s.length();
        block3: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || c == ' ' && !spacesToo) continue;
            if (!Character.isWhitespace(c) && !Character.isISOControl(c)) {
                switch (c) {
                    case '\"': 
                    case '&': 
                    case '\'': 
                    case '.': 
                    case '<': 
                    case '>': {
                        break;
                    }
                    default: {
                        continue block3;
                    }
                }
            }
            StringBuilder sb = new StringBuilder(s);
            return DMSUtil.sanitize(sb, spacesToo, dotToo, i);
        }
        return s;
    }

    private static final String sanitize(StringBuilder sb, boolean spacesToo, boolean dotToo, int pos) {
        int length = sb.length();
        block7: for (int i = pos; i < length; ++i) {
            char c = sb.charAt(i);
            if (Character.isLetterOrDigit(c) || c == ' ' && !spacesToo) continue;
            if (Character.isWhitespace(c)) {
                if (spacesToo) {
                    sb.setCharAt(i, '_');
                    continue;
                }
                sb.setCharAt(i, ' ');
                continue;
            }
            if (Character.isISOControl(c)) {
                sb.setCharAt(i, '_');
                continue;
            }
            switch (c) {
                case '<': {
                    sb.setCharAt(i, '(');
                    continue block7;
                }
                case '>': {
                    sb.setCharAt(i, ')');
                    continue block7;
                }
                case '&': {
                    sb.setCharAt(i, '^');
                    continue block7;
                }
                case '\"': 
                case '\'': {
                    sb.setCharAt(i, '`');
                    continue block7;
                }
                case '.': {
                    String sfx;
                    if (!dotToo || (sfx = sb.substring(i)).lastIndexOf(46) != 0 || !".value".equals(sfx) && !".count".equals(sfx) && !".time".equals(sfx) && !".minTime".equals(sfx) && !".minValue".equals(sfx) && !".maxTime".equals(sfx) && !".maxValue".equals(sfx) && !".completed".equals(sfx) && !".avg".equals(sfx) && !".sum".equals(sfx) && !".active".equals(sfx) && !".maxActive".equals(sfx) && !".logged".equals(sfx) && !".exclTime".equals(sfx) && !".lastUpdate".equals(sfx) && !".ts".equals(sfx)) continue block7;
                    sb.setCharAt(i, '_');
                    continue block7;
                }
                default: {
                    continue block7;
                }
            }
        }
        return sb.toString();
    }

    public static String getLeafFromPath(String pathname) {
        if (pathname == null || pathname.trim().length() == 0) {
            return null;
        }
        char delim = pathname.charAt(0);
        String my_name = pathname.substring(pathname.lastIndexOf(delim) + 1);
        return my_name;
    }

    public static String removeTrailingDelimFromPath(String pathname) {
        int len;
        if (pathname == null || pathname.length() <= 1) {
            return pathname;
        }
        for (len = pathname.length(); len > 1 && pathname.charAt(0) == pathname.charAt(len - 1); --len) {
        }
        if (len < pathname.length()) {
            pathname = pathname.substring(0, len);
        }
        return pathname;
    }

    public static String getParentFromPath(String pathname) {
        if (pathname == null || pathname.trim().length() == 0) {
            return null;
        }
        char delim = pathname.charAt(0);
        return pathname.substring(0, pathname.lastIndexOf(delim));
    }

    public static String genCompNounPath(String nounName) {
        return "/DMS-Internal/" + nounName;
    }

    public static void cleanFormatArgs(Object[] args) {
        if (args != null) {
            for (int i = args.length - 1; i >= 0; --i) {
                if (args[i] != null) continue;
                args[i] = "null";
            }
        }
    }

    public static String getDMSMount() {
        return _dmsMount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearMapSets(Map<?, ?> hashmap) {
        ArrayList list;
        if (hashmap == null) {
            return;
        }
        Map<?, ?> map = hashmap;
        synchronized (map) {
            list = new ArrayList(hashmap.values());
            hashmap.clear();
        }
        for (Object obj : list) {
            Object obj2;
            if (obj instanceof Collection) {
                obj2 = obj;
                synchronized (obj2) {
                    ((Collection)obj).clear();
                    continue;
                }
            }
            if (!(obj instanceof Map)) continue;
            obj2 = obj;
            synchronized (obj2) {
                ((Map)obj).clear();
            }
        }
        list.clear();
    }

    public static String xmlEscape(String text) {
        int ch;
        if (text == null) {
            return null;
        }
        StringBuilder newText = new StringBuilder();
        for (int i = 0; i < text.length(); i += Character.charCount(ch)) {
            ch = text.codePointAt(i);
            if (ch == 9 || ch == 10 || ch == 13 || 32 <= ch && ch <= 55295 || 57344 <= ch && ch <= 65533 || 65536 <= ch && ch <= 0x10FFFF) {
                if (ch == 93 && i + 2 < text.length() && text.charAt(i + 1) == ']' && text.charAt(i + 2) == '>') {
                    newText.append("&#93;&#93;&#62;");
                    i += 2;
                    continue;
                }
                newText.appendCodePoint(ch);
                continue;
            }
            newText.append("&#");
            newText.append(ch);
            newText.append(";");
        }
        return newText.toString();
    }

    public static String xssEscape(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder newText = new StringBuilder();
        StringCharacterIterator iter = new StringCharacterIterator(text);
        char ch = iter.first();
        while (ch != '\uffff') {
            switch (ch) {
                case '>': {
                    newText.append("&gt;");
                    break;
                }
                case '<': {
                    newText.append("&lt;");
                    break;
                }
                case '&': {
                    newText.append("&amp;");
                    break;
                }
                case '\"': {
                    newText.append("&quot;");
                    break;
                }
                case '\'': {
                    newText.append("&rsquo;");
                    break;
                }
                case '%': {
                    newText.append("&#37;");
                    break;
                }
                case '(': {
                    newText.append("&#40;");
                    break;
                }
                case ')': {
                    newText.append("&#41;");
                    break;
                }
                case ';': {
                    newText.append("&#59");
                    break;
                }
                case '+': {
                    newText.append("&#43;");
                    break;
                }
                default: {
                    newText.append(ch);
                }
            }
            ch = iter.next();
        }
        return newText.toString();
    }

    public static String urlXssEscape(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder newText = new StringBuilder();
        StringCharacterIterator iter = new StringCharacterIterator(text);
        char ch = iter.first();
        while (ch != '\uffff') {
            switch (ch) {
                case ' ': {
                    newText.append("+");
                    break;
                }
                case '&': {
                    newText.append("%26");
                    break;
                }
                case '%': {
                    newText.append("%25");
                    break;
                }
                default: {
                    if (ch < ' ') {
                        newText.append('%');
                        if (ch < '\u0010') {
                            newText.append('0');
                        }
                        newText.append(Integer.toString(ch, 16));
                        break;
                    }
                    newText.append(ch);
                }
            }
            ch = iter.next();
        }
        return newText.toString();
    }

    public static String scriptEscape(String text) {
        if (text == null) {
            return null;
        }
        String newText = SCRIPT_START_PATTERN.matcher(text).replaceAll("&lt;script&gt;");
        return SCRIPT_END_PATTERN.matcher(newText).replaceAll("&lt;/script&gt;");
    }

    public static <T> HashSet<T> createHashSet(T[] array) {
        HashSet<T> set = new HashSet<T>();
        if (array == null) {
            return set;
        }
        for (T element : array) {
            if (element == null) continue;
            set.add(element);
        }
        return set;
    }

    public static <T> ArrayList<T> createArrayList(T[] array) {
        ArrayList<T> set = new ArrayList<T>();
        if (array == null) {
            return set;
        }
        for (T element : array) {
            if (element == null) continue;
            set.add(element);
        }
        return set;
    }

    public static int[] parseVersion(String version) throws NumberFormatException {
        if (version == null || version.trim().length() == 0) {
            throw new NumberFormatException(version);
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringTokenizer verTok = new StringTokenizer(version, ".");
        while (verTok.hasMoreTokens()) {
            String token = verTok.nextToken();
            list.add(new Integer(token));
        }
        int size = list.size();
        if (size == 0) {
            throw new NumberFormatException(version);
        }
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = (Integer)list.get(i);
        }
        return ret;
    }

    public static int compareVersion(String version, int[] versionNums) throws NumberFormatException {
        if (version == null || versionNums == null || versionNums.length == 0) {
            throw new NumberFormatException();
        }
        int[] numbers = DMSUtil.parseVersion(version);
        return DMSUtil.compareVersion(numbers, versionNums);
    }

    public static int compareVersion(int[] versionNum1, int[] versionNum2) throws NumberFormatException {
        if (versionNum1 == null || versionNum1.length == 0 || versionNum2 == null || versionNum2.length == 0) {
            throw new NumberFormatException();
        }
        int min = versionNum1.length < versionNum2.length ? versionNum1.length : versionNum2.length;
        for (int i = 0; i < min; ++i) {
            if (versionNum1[i] < versionNum2[i]) {
                return -1;
            }
            if (versionNum1[i] <= versionNum2[i]) continue;
            return 1;
        }
        int[] longer = versionNum1.length > versionNum2.length ? versionNum1 : versionNum2;
        boolean is0 = true;
        for (int i = min; i < longer.length; ++i) {
            if (longer[i] == 0) continue;
            is0 = false;
            break;
        }
        if (is0) {
            return 0;
        }
        if (versionNum1.length < versionNum2.length) {
            return -1;
        }
        if (versionNum1.length > versionNum2.length) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream logInputStream(InputStream reader, Logger logger) throws IOException {
        byte[] buf = new byte[2048];
        int len = 0;
        try {
            int num = 0;
            while ((num = reader.read(buf, len, buf.length - len)) != -1) {
                if ((len += num) < buf.length) continue;
                byte[] newBuf = new byte[buf.length * 2];
                System.arraycopy(buf, 0, newBuf, 0, len);
                buf = newBuf;
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {}
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, DMSUtil.class.getName(), "logStream", new String(buf, 0, len));
        }
        return new ByteArrayInputStream(buf, 0, len);
    }

    private DMSUtil() {
    }

    public static synchronized void exit() {
        _pidSet = false;
        _dmsMount = "dms0";
        _localhost = null;
        _pid = PIDNOTSET;
    }

    public static String errorMessage(String errorNumber, Object ... inserts) {
        StringBuilder buf = new StringBuilder();
        String key = COMP_PREFIX + errorNumber;
        buf.append(key);
        buf.append(": ");
        if (inserts == null) {
            buf.append(DMSNLSupport.getString(key));
        } else {
            buf.append(DMSNLSupport.getMessage(key, inserts));
        }
        String actionKey = key + ACTION;
        String actionMessage = inserts == null ? DMSNLSupport.getString(actionKey, null) : DMSNLSupport.getMessage(actionKey, inserts, null);
        if (actionMessage != null && actionMessage.trim().length() > 0) {
            String lineSeparator = DMSProperties.getSystemProperty("line.separator");
            buf.append(lineSeparator);
            buf.append(actionKey);
            buf.append(": ");
            buf.append(actionMessage);
        }
        return buf.toString();
    }

    public static void logp(Logger logger, Level level, String sourceClass, String sourceMethod, String msg, Object[] params, Throwable e) {
        if (logger == null || level == null || !logger.isLoggable(level)) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setLoggerName(logger.getName());
        lr.setResourceBundleName("oracle.dms.util.dms");
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setParameters(params);
        lr.setThrown(e);
        logger.log(lr);
    }

    public static double getWaitRatio(int futureSize, int threadPoolSize) {
        double ratio;
        if (threadPoolSize < 1) {
            threadPoolSize = 1;
        }
        if ((ratio = (double)futureSize / (double)threadPoolSize) < 1.0) {
            ratio = 1.0;
        }
        return ratio;
    }

    public static boolean isLegalIdentifier(String identifier) {
        boolean retVal = true;
        if (identifier == null || identifier.trim().endsWith(".") || identifier.trim().length() == 0 || identifier.replace('.', ' ').trim().length() == 0) {
            retVal = false;
        } else if (!Character.isJavaIdentifierStart(identifier.charAt(0))) {
            retVal = false;
        } else {
            StringTokenizer tokenizer = new StringTokenizer(identifier, ".");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token == null || token.trim().length() == 0) {
                    retVal = false;
                } else if (!Character.isJavaIdentifierStart(token.charAt(0)) && token.charAt(0) != '-') {
                    retVal = false;
                } else {
                    for (int i = 1; i < token.length(); ++i) {
                        if (Character.isJavaIdentifierPart(token.charAt(i)) || token.charAt(i) == '-') continue;
                        retVal = false;
                        break;
                    }
                }
                if (retVal) continue;
                break;
            }
        }
        return retVal;
    }

    public static String javaIdentifieringName(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        StringBuilder buf = new StringBuilder();
        boolean isFirstChar = true;
        int codePointLen = name.codePointCount(0, name.length());
        for (int i = 0; i < codePointLen; ++i) {
            int index = name.offsetByCodePoints(0, i);
            int codePoint = name.codePointAt(index);
            if (isFirstChar) {
                if (Character.isJavaIdentifierStart(codePoint)) {
                    buf.appendCodePoint(codePoint);
                } else {
                    buf.appendCodePoint(95);
                }
                isFirstChar = false;
                continue;
            }
            if (Character.isJavaIdentifierPart(codePoint)) {
                buf.appendCodePoint(codePoint);
                continue;
            }
            buf.appendCodePoint(95);
        }
        return buf.toString();
    }

    public static boolean validateServerNames(QueryOptions options) throws RuntimeException {
        String METHOD_NAME = "validateServerNames";
        if (options == null) {
            return true;
        }
        Set<String> serverNames = options.getServerNames();
        if (serverNames == null || serverNames.size() == 0) {
            return true;
        }
        PlatformSupport platformSupport = PlatformSupportFactory.getPlatformSupport();
        String thisServerName = platformSupport.getServerName();
        if (thisServerName == null || thisServerName.trim().length() == 0) {
            return true;
        }
        String thisClusterName = platformSupport.getClusterName();
        boolean found = false;
        for (String serverName : serverNames) {
            if (thisServerName.equals(serverName)) {
                found = true;
                continue;
            }
            if (thisClusterName != null && thisClusterName.equals(serverName)) {
                found = true;
                continue;
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.logp(Level.FINE, DMSUtil.class.getName(), "validateServerNames", "Invalid server name=" + serverName);
        }
        if (!found && options.isCommand()) {
            String message = DMSUtil.errorMessage("50755", serverNames.toString());
            throw new RuntimeException(message);
        }
        return found;
    }

    public static long parseMemSizeString(String s) {
        long retVal = 0L;
        if (s != null && s.length() > 0) {
            s = s.toUpperCase();
            String d = s.substring(0, s.length() - 1).trim();
            retVal = s.endsWith("K") ? 1024L * Long.parseLong(d) : (s.endsWith("M") ? 0x100000L * Long.parseLong(d) : (s.endsWith("G") ? 0x40000000L * Long.parseLong(d) : Long.parseLong(s)));
        }
        return retVal;
    }

    public static <T extends Enum<T>> T getEnumFromString(Class<T> c, String string) {
        if (c != null && string != null) {
            return Enum.valueOf(c, string.trim().toUpperCase());
        }
        return null;
    }
}

