/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waf.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetWebAppFirewallRequest
extends BmcRequest<Void> {
    private String webAppFirewallId;
    private String opcRequestId;

    public String getWebAppFirewallId() {
        return this.webAppFirewallId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().webAppFirewallId(this.webAppFirewallId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",webAppFirewallId=").append(String.valueOf(this.webAppFirewallId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetWebAppFirewallRequest)) {
            return false;
        }
        GetWebAppFirewallRequest other = (GetWebAppFirewallRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.webAppFirewallId, other.webAppFirewallId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.webAppFirewallId == null ? 43 : this.webAppFirewallId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetWebAppFirewallRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String webAppFirewallId = null;
        private String opcRequestId = null;

        public Builder webAppFirewallId(String webAppFirewallId) {
            this.webAppFirewallId = webAppFirewallId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetWebAppFirewallRequest o) {
            this.webAppFirewallId(o.getWebAppFirewallId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetWebAppFirewallRequest build() {
            GetWebAppFirewallRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetWebAppFirewallRequest buildWithoutInvocationCallback() {
            GetWebAppFirewallRequest request = new GetWebAppFirewallRequest();
            request.webAppFirewallId = this.webAppFirewallId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

