/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waf.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.waf.model.Action;
import com.oracle.bmc.waf.model.RequestAccessControl;
import com.oracle.bmc.waf.model.RequestProtection;
import com.oracle.bmc.waf.model.RequestRateLimiting;
import com.oracle.bmc.waf.model.ResponseAccessControl;
import com.oracle.bmc.waf.model.ResponseProtection;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WebAppFirewallPolicy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="actions")
    private final List<Action> actions;
    @JsonProperty(value="requestAccessControl")
    private final RequestAccessControl requestAccessControl;
    @JsonProperty(value="requestRateLimiting")
    private final RequestRateLimiting requestRateLimiting;
    @JsonProperty(value="requestProtection")
    private final RequestProtection requestProtection;
    @JsonProperty(value="responseAccessControl")
    private final ResponseAccessControl responseAccessControl;
    @JsonProperty(value="responseProtection")
    private final ResponseProtection responseProtection;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "compartmentId", "timeCreated", "timeUpdated", "lifecycleState", "lifecycleDetails", "actions", "requestAccessControl", "requestRateLimiting", "requestProtection", "responseAccessControl", "responseProtection", "freeformTags", "definedTags", "systemTags"})
    public WebAppFirewallPolicy(String id, String displayName, String compartmentId, Date timeCreated, Date timeUpdated, LifecycleState lifecycleState, String lifecycleDetails, List<Action> actions, RequestAccessControl requestAccessControl, RequestRateLimiting requestRateLimiting, RequestProtection requestProtection, ResponseAccessControl responseAccessControl, ResponseProtection responseProtection, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.actions = actions;
        this.requestAccessControl = requestAccessControl;
        this.requestRateLimiting = requestRateLimiting;
        this.requestProtection = requestProtection;
        this.responseAccessControl = responseAccessControl;
        this.responseProtection = responseProtection;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public RequestAccessControl getRequestAccessControl() {
        return this.requestAccessControl;
    }

    public RequestRateLimiting getRequestRateLimiting() {
        return this.requestRateLimiting;
    }

    public RequestProtection getRequestProtection() {
        return this.requestProtection;
    }

    public ResponseAccessControl getResponseAccessControl() {
        return this.responseAccessControl;
    }

    public ResponseProtection getResponseProtection() {
        return this.responseProtection;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WebAppFirewallPolicy(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", actions=").append(String.valueOf(this.actions));
        sb.append(", requestAccessControl=").append(String.valueOf((Object)this.requestAccessControl));
        sb.append(", requestRateLimiting=").append(String.valueOf((Object)this.requestRateLimiting));
        sb.append(", requestProtection=").append(String.valueOf((Object)this.requestProtection));
        sb.append(", responseAccessControl=").append(String.valueOf((Object)this.responseAccessControl));
        sb.append(", responseProtection=").append(String.valueOf((Object)this.responseProtection));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebAppFirewallPolicy)) {
            return false;
        }
        WebAppFirewallPolicy other = (WebAppFirewallPolicy)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.actions, other.actions) && Objects.equals((Object)this.requestAccessControl, (Object)other.requestAccessControl) && Objects.equals((Object)this.requestRateLimiting, (Object)other.requestRateLimiting) && Objects.equals((Object)this.requestProtection, (Object)other.requestProtection) && Objects.equals((Object)this.responseAccessControl, (Object)other.responseAccessControl) && Objects.equals((Object)this.responseProtection, (Object)other.responseProtection) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.actions == null ? 43 : this.actions.hashCode());
        result = result * 59 + (this.requestAccessControl == null ? 43 : this.requestAccessControl.hashCode());
        result = result * 59 + (this.requestRateLimiting == null ? 43 : this.requestRateLimiting.hashCode());
        result = result * 59 + (this.requestProtection == null ? 43 : this.requestProtection.hashCode());
        result = result * 59 + (this.responseAccessControl == null ? 43 : this.responseAccessControl.hashCode());
        result = result * 59 + (this.responseProtection == null ? 43 : this.responseProtection.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Updating("UPDATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="actions")
        private List<Action> actions;
        @JsonProperty(value="requestAccessControl")
        private RequestAccessControl requestAccessControl;
        @JsonProperty(value="requestRateLimiting")
        private RequestRateLimiting requestRateLimiting;
        @JsonProperty(value="requestProtection")
        private RequestProtection requestProtection;
        @JsonProperty(value="responseAccessControl")
        private ResponseAccessControl responseAccessControl;
        @JsonProperty(value="responseProtection")
        private ResponseProtection responseProtection;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder actions(List<Action> actions) {
            this.actions = actions;
            this.__explicitlySet__.add("actions");
            return this;
        }

        public Builder requestAccessControl(RequestAccessControl requestAccessControl) {
            this.requestAccessControl = requestAccessControl;
            this.__explicitlySet__.add("requestAccessControl");
            return this;
        }

        public Builder requestRateLimiting(RequestRateLimiting requestRateLimiting) {
            this.requestRateLimiting = requestRateLimiting;
            this.__explicitlySet__.add("requestRateLimiting");
            return this;
        }

        public Builder requestProtection(RequestProtection requestProtection) {
            this.requestProtection = requestProtection;
            this.__explicitlySet__.add("requestProtection");
            return this;
        }

        public Builder responseAccessControl(ResponseAccessControl responseAccessControl) {
            this.responseAccessControl = responseAccessControl;
            this.__explicitlySet__.add("responseAccessControl");
            return this;
        }

        public Builder responseProtection(ResponseProtection responseProtection) {
            this.responseProtection = responseProtection;
            this.__explicitlySet__.add("responseProtection");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public WebAppFirewallPolicy build() {
            WebAppFirewallPolicy model = new WebAppFirewallPolicy(this.id, this.displayName, this.compartmentId, this.timeCreated, this.timeUpdated, this.lifecycleState, this.lifecycleDetails, this.actions, this.requestAccessControl, this.requestRateLimiting, this.requestProtection, this.responseAccessControl, this.responseProtection, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WebAppFirewallPolicy model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("actions")) {
                this.actions(model.getActions());
            }
            if (model.wasPropertyExplicitlySet("requestAccessControl")) {
                this.requestAccessControl(model.getRequestAccessControl());
            }
            if (model.wasPropertyExplicitlySet("requestRateLimiting")) {
                this.requestRateLimiting(model.getRequestRateLimiting());
            }
            if (model.wasPropertyExplicitlySet("requestProtection")) {
                this.requestProtection(model.getRequestProtection());
            }
            if (model.wasPropertyExplicitlySet("responseAccessControl")) {
                this.responseAccessControl(model.getResponseAccessControl());
            }
            if (model.wasPropertyExplicitlySet("responseProtection")) {
                this.responseProtection(model.getResponseProtection());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

