/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waf.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RequestRateLimitingConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="periodInSeconds")
    private final Integer periodInSeconds;
    @JsonProperty(value="requestsLimit")
    private final Integer requestsLimit;
    @JsonProperty(value="actionDurationInSeconds")
    private final Integer actionDurationInSeconds;

    @Deprecated
    @ConstructorProperties(value={"periodInSeconds", "requestsLimit", "actionDurationInSeconds"})
    public RequestRateLimitingConfiguration(Integer periodInSeconds, Integer requestsLimit, Integer actionDurationInSeconds) {
        this.periodInSeconds = periodInSeconds;
        this.requestsLimit = requestsLimit;
        this.actionDurationInSeconds = actionDurationInSeconds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getPeriodInSeconds() {
        return this.periodInSeconds;
    }

    public Integer getRequestsLimit() {
        return this.requestsLimit;
    }

    public Integer getActionDurationInSeconds() {
        return this.actionDurationInSeconds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RequestRateLimitingConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("periodInSeconds=").append(String.valueOf(this.periodInSeconds));
        sb.append(", requestsLimit=").append(String.valueOf(this.requestsLimit));
        sb.append(", actionDurationInSeconds=").append(String.valueOf(this.actionDurationInSeconds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestRateLimitingConfiguration)) {
            return false;
        }
        RequestRateLimitingConfiguration other = (RequestRateLimitingConfiguration)((Object)o);
        return Objects.equals(this.periodInSeconds, other.periodInSeconds) && Objects.equals(this.requestsLimit, other.requestsLimit) && Objects.equals(this.actionDurationInSeconds, other.actionDurationInSeconds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.periodInSeconds == null ? 43 : this.periodInSeconds.hashCode());
        result = result * 59 + (this.requestsLimit == null ? 43 : this.requestsLimit.hashCode());
        result = result * 59 + (this.actionDurationInSeconds == null ? 43 : this.actionDurationInSeconds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="periodInSeconds")
        private Integer periodInSeconds;
        @JsonProperty(value="requestsLimit")
        private Integer requestsLimit;
        @JsonProperty(value="actionDurationInSeconds")
        private Integer actionDurationInSeconds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder periodInSeconds(Integer periodInSeconds) {
            this.periodInSeconds = periodInSeconds;
            this.__explicitlySet__.add("periodInSeconds");
            return this;
        }

        public Builder requestsLimit(Integer requestsLimit) {
            this.requestsLimit = requestsLimit;
            this.__explicitlySet__.add("requestsLimit");
            return this;
        }

        public Builder actionDurationInSeconds(Integer actionDurationInSeconds) {
            this.actionDurationInSeconds = actionDurationInSeconds;
            this.__explicitlySet__.add("actionDurationInSeconds");
            return this;
        }

        public RequestRateLimitingConfiguration build() {
            RequestRateLimitingConfiguration model = new RequestRateLimitingConfiguration(this.periodInSeconds, this.requestsLimit, this.actionDurationInSeconds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RequestRateLimitingConfiguration model) {
            if (model.wasPropertyExplicitlySet("periodInSeconds")) {
                this.periodInSeconds(model.getPeriodInSeconds());
            }
            if (model.wasPropertyExplicitlySet("requestsLimit")) {
                this.requestsLimit(model.getRequestsLimit());
            }
            if (model.wasPropertyExplicitlySet("actionDurationInSeconds")) {
                this.actionDurationInSeconds(model.getActionDurationInSeconds());
            }
            return this;
        }
    }
}

