/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.responses.BmcResponse;
import com.oracle.bmc.waas.model.HttpRedirect;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetHttpRedirectResponse
extends BmcResponse {
    private String etag;
    private String opcRequestId;
    private HttpRedirect httpRedirect;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public HttpRedirect getHttpRedirect() {
        return this.httpRedirect;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcRequestId", "httpRedirect"})
    private GetHttpRedirectResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcRequestId, HttpRedirect httpRedirect) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.httpRedirect = httpRedirect;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",httpRedirect=").append(String.valueOf((Object)this.httpRedirect));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetHttpRedirectResponse)) {
            return false;
        }
        GetHttpRedirectResponse other = (GetHttpRedirectResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.httpRedirect, (Object)other.httpRedirect);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.httpRedirect == null ? 43 : this.httpRedirect.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetHttpRedirectResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcRequestId;
        private HttpRedirect httpRedirect;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder httpRedirect(HttpRedirect httpRedirect) {
            this.httpRedirect = httpRedirect;
            return this;
        }

        public Builder copy(GetHttpRedirectResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.httpRedirect(o.getHttpRedirect());
            return this;
        }

        public GetHttpRedirectResponse build() {
            return new GetHttpRedirectResponse(this.__httpStatusCode__, this.headers, this.etag, this.opcRequestId, this.httpRedirect);
        }
    }
}

