/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.waas.model.UpdateHttpRedirectDetails;
import java.util.Objects;

public class UpdateHttpRedirectRequest
extends BmcRequest<UpdateHttpRedirectDetails> {
    private String httpRedirectId;
    private UpdateHttpRedirectDetails updateHttpRedirectDetails;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;

    public String getHttpRedirectId() {
        return this.httpRedirectId;
    }

    public UpdateHttpRedirectDetails getUpdateHttpRedirectDetails() {
        return this.updateHttpRedirectDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateHttpRedirectDetails getBody$() {
        return this.updateHttpRedirectDetails;
    }

    public Builder toBuilder() {
        return new Builder().httpRedirectId(this.httpRedirectId).updateHttpRedirectDetails(this.updateHttpRedirectDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",httpRedirectId=").append(String.valueOf(this.httpRedirectId));
        sb.append(",updateHttpRedirectDetails=").append(String.valueOf((Object)this.updateHttpRedirectDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateHttpRedirectRequest)) {
            return false;
        }
        UpdateHttpRedirectRequest other = (UpdateHttpRedirectRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.httpRedirectId, other.httpRedirectId) && Objects.equals((Object)this.updateHttpRedirectDetails, (Object)other.updateHttpRedirectDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.httpRedirectId == null ? 43 : this.httpRedirectId.hashCode());
        result = result * 59 + (this.updateHttpRedirectDetails == null ? 43 : this.updateHttpRedirectDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateHttpRedirectRequest, UpdateHttpRedirectDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String httpRedirectId = null;
        private UpdateHttpRedirectDetails updateHttpRedirectDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String ifMatch = null;

        public Builder httpRedirectId(String httpRedirectId) {
            this.httpRedirectId = httpRedirectId;
            return this;
        }

        public Builder updateHttpRedirectDetails(UpdateHttpRedirectDetails updateHttpRedirectDetails) {
            this.updateHttpRedirectDetails = updateHttpRedirectDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateHttpRedirectRequest o) {
            this.httpRedirectId(o.getHttpRedirectId());
            this.updateHttpRedirectDetails(o.getUpdateHttpRedirectDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateHttpRedirectRequest build() {
            UpdateHttpRedirectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateHttpRedirectDetails body) {
            this.updateHttpRedirectDetails(body);
            return this;
        }

        public UpdateHttpRedirectRequest buildWithoutInvocationCallback() {
            UpdateHttpRedirectRequest request = new UpdateHttpRedirectRequest();
            request.httpRedirectId = this.httpRedirectId;
            request.updateHttpRedirectDetails = this.updateHttpRedirectDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

