/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.waas.model.AccessRule;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class UpdateAccessRulesRequest
extends BmcRequest<List<AccessRule>> {
    private String waasPolicyId;
    private List<AccessRule> accessRules;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;

    public String getWaasPolicyId() {
        return this.waasPolicyId;
    }

    public List<AccessRule> getAccessRules() {
        return this.accessRules;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public List<AccessRule> getBody$() {
        return this.accessRules;
    }

    public Builder toBuilder() {
        return new Builder().waasPolicyId(this.waasPolicyId).accessRules(this.accessRules).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",waasPolicyId=").append(String.valueOf(this.waasPolicyId));
        sb.append(",accessRules=").append(String.valueOf(this.accessRules));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateAccessRulesRequest)) {
            return false;
        }
        UpdateAccessRulesRequest other = (UpdateAccessRulesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.waasPolicyId, other.waasPolicyId) && Objects.equals(this.accessRules, other.accessRules) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.waasPolicyId == null ? 43 : this.waasPolicyId.hashCode());
        result = result * 59 + (this.accessRules == null ? 43 : this.accessRules.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateAccessRulesRequest, List<AccessRule>> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String waasPolicyId = null;
        private List<AccessRule> accessRules = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String ifMatch = null;

        public Builder waasPolicyId(String waasPolicyId) {
            this.waasPolicyId = waasPolicyId;
            return this;
        }

        public Builder accessRules(List<AccessRule> accessRules) {
            this.accessRules = accessRules;
            return this;
        }

        public Builder accessRules(AccessRule singularValue) {
            return this.accessRules(Arrays.asList(singularValue));
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateAccessRulesRequest o) {
            this.waasPolicyId(o.getWaasPolicyId());
            this.accessRules(o.getAccessRules());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateAccessRulesRequest build() {
            UpdateAccessRulesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(List<AccessRule> body) {
            this.accessRules(body);
            return this;
        }

        public UpdateAccessRulesRequest buildWithoutInvocationCallback() {
            UpdateAccessRulesRequest request = new UpdateAccessRulesRequest();
            request.waasPolicyId = this.waasPolicyId;
            request.accessRules = this.accessRules;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

