/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListWafLogsRequest
extends BmcRequest<Void> {
    private String waasPolicyId;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private Date timeObservedGreaterThanOrEqualTo;
    private Date timeObservedLessThan;
    private String textContains;
    private List<String> accessRuleKey;
    private List<Action> action;
    private List<String> clientAddress;
    private List<String> countryCode;
    private List<String> countryName;
    private List<String> fingerprint;
    private List<HttpMethod> httpMethod;
    private List<String> incidentKey;
    private List<LogType> logType;
    private List<String> originAddress;
    private List<String> referrer;
    private List<String> requestUrl;
    private List<Integer> responseCode;
    private List<String> threatFeedKey;
    private List<String> userAgent;
    private List<String> protectionRuleKey;

    public String getWaasPolicyId() {
        return this.waasPolicyId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Date getTimeObservedGreaterThanOrEqualTo() {
        return this.timeObservedGreaterThanOrEqualTo;
    }

    public Date getTimeObservedLessThan() {
        return this.timeObservedLessThan;
    }

    public String getTextContains() {
        return this.textContains;
    }

    public List<String> getAccessRuleKey() {
        return this.accessRuleKey;
    }

    public List<Action> getAction() {
        return this.action;
    }

    public List<String> getClientAddress() {
        return this.clientAddress;
    }

    public List<String> getCountryCode() {
        return this.countryCode;
    }

    public List<String> getCountryName() {
        return this.countryName;
    }

    public List<String> getFingerprint() {
        return this.fingerprint;
    }

    public List<HttpMethod> getHttpMethod() {
        return this.httpMethod;
    }

    public List<String> getIncidentKey() {
        return this.incidentKey;
    }

    public List<LogType> getLogType() {
        return this.logType;
    }

    public List<String> getOriginAddress() {
        return this.originAddress;
    }

    public List<String> getReferrer() {
        return this.referrer;
    }

    public List<String> getRequestUrl() {
        return this.requestUrl;
    }

    public List<Integer> getResponseCode() {
        return this.responseCode;
    }

    public List<String> getThreatFeedKey() {
        return this.threatFeedKey;
    }

    public List<String> getUserAgent() {
        return this.userAgent;
    }

    public List<String> getProtectionRuleKey() {
        return this.protectionRuleKey;
    }

    public Builder toBuilder() {
        return new Builder().waasPolicyId(this.waasPolicyId).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page).timeObservedGreaterThanOrEqualTo(this.timeObservedGreaterThanOrEqualTo).timeObservedLessThan(this.timeObservedLessThan).textContains(this.textContains).accessRuleKey(this.accessRuleKey).action(this.action).clientAddress(this.clientAddress).countryCode(this.countryCode).countryName(this.countryName).fingerprint(this.fingerprint).httpMethod(this.httpMethod).incidentKey(this.incidentKey).logType(this.logType).originAddress(this.originAddress).referrer(this.referrer).requestUrl(this.requestUrl).responseCode(this.responseCode).threatFeedKey(this.threatFeedKey).userAgent(this.userAgent).protectionRuleKey(this.protectionRuleKey);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",waasPolicyId=").append(String.valueOf(this.waasPolicyId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",timeObservedGreaterThanOrEqualTo=").append(String.valueOf(this.timeObservedGreaterThanOrEqualTo));
        sb.append(",timeObservedLessThan=").append(String.valueOf(this.timeObservedLessThan));
        sb.append(",textContains=").append(String.valueOf(this.textContains));
        sb.append(",accessRuleKey=").append(String.valueOf(this.accessRuleKey));
        sb.append(",action=").append(String.valueOf(this.action));
        sb.append(",clientAddress=").append(String.valueOf(this.clientAddress));
        sb.append(",countryCode=").append(String.valueOf(this.countryCode));
        sb.append(",countryName=").append(String.valueOf(this.countryName));
        sb.append(",fingerprint=").append(String.valueOf(this.fingerprint));
        sb.append(",httpMethod=").append(String.valueOf(this.httpMethod));
        sb.append(",incidentKey=").append(String.valueOf(this.incidentKey));
        sb.append(",logType=").append(String.valueOf(this.logType));
        sb.append(",originAddress=").append(String.valueOf(this.originAddress));
        sb.append(",referrer=").append(String.valueOf(this.referrer));
        sb.append(",requestUrl=").append(String.valueOf(this.requestUrl));
        sb.append(",responseCode=").append(String.valueOf(this.responseCode));
        sb.append(",threatFeedKey=").append(String.valueOf(this.threatFeedKey));
        sb.append(",userAgent=").append(String.valueOf(this.userAgent));
        sb.append(",protectionRuleKey=").append(String.valueOf(this.protectionRuleKey));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListWafLogsRequest)) {
            return false;
        }
        ListWafLogsRequest other = (ListWafLogsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.waasPolicyId, other.waasPolicyId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.timeObservedGreaterThanOrEqualTo, other.timeObservedGreaterThanOrEqualTo) && Objects.equals(this.timeObservedLessThan, other.timeObservedLessThan) && Objects.equals(this.textContains, other.textContains) && Objects.equals(this.accessRuleKey, other.accessRuleKey) && Objects.equals(this.action, other.action) && Objects.equals(this.clientAddress, other.clientAddress) && Objects.equals(this.countryCode, other.countryCode) && Objects.equals(this.countryName, other.countryName) && Objects.equals(this.fingerprint, other.fingerprint) && Objects.equals(this.httpMethod, other.httpMethod) && Objects.equals(this.incidentKey, other.incidentKey) && Objects.equals(this.logType, other.logType) && Objects.equals(this.originAddress, other.originAddress) && Objects.equals(this.referrer, other.referrer) && Objects.equals(this.requestUrl, other.requestUrl) && Objects.equals(this.responseCode, other.responseCode) && Objects.equals(this.threatFeedKey, other.threatFeedKey) && Objects.equals(this.userAgent, other.userAgent) && Objects.equals(this.protectionRuleKey, other.protectionRuleKey);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.waasPolicyId == null ? 43 : this.waasPolicyId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.timeObservedGreaterThanOrEqualTo == null ? 43 : this.timeObservedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeObservedLessThan == null ? 43 : this.timeObservedLessThan.hashCode());
        result = result * 59 + (this.textContains == null ? 43 : this.textContains.hashCode());
        result = result * 59 + (this.accessRuleKey == null ? 43 : this.accessRuleKey.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.clientAddress == null ? 43 : this.clientAddress.hashCode());
        result = result * 59 + (this.countryCode == null ? 43 : this.countryCode.hashCode());
        result = result * 59 + (this.countryName == null ? 43 : this.countryName.hashCode());
        result = result * 59 + (this.fingerprint == null ? 43 : this.fingerprint.hashCode());
        result = result * 59 + (this.httpMethod == null ? 43 : this.httpMethod.hashCode());
        result = result * 59 + (this.incidentKey == null ? 43 : this.incidentKey.hashCode());
        result = result * 59 + (this.logType == null ? 43 : this.logType.hashCode());
        result = result * 59 + (this.originAddress == null ? 43 : this.originAddress.hashCode());
        result = result * 59 + (this.referrer == null ? 43 : this.referrer.hashCode());
        result = result * 59 + (this.requestUrl == null ? 43 : this.requestUrl.hashCode());
        result = result * 59 + (this.responseCode == null ? 43 : this.responseCode.hashCode());
        result = result * 59 + (this.threatFeedKey == null ? 43 : this.threatFeedKey.hashCode());
        result = result * 59 + (this.userAgent == null ? 43 : this.userAgent.hashCode());
        result = result * 59 + (this.protectionRuleKey == null ? 43 : this.protectionRuleKey.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListWafLogsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String waasPolicyId = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;
        private Date timeObservedGreaterThanOrEqualTo = null;
        private Date timeObservedLessThan = null;
        private String textContains = null;
        private List<String> accessRuleKey = null;
        private List<Action> action = null;
        private List<String> clientAddress = null;
        private List<String> countryCode = null;
        private List<String> countryName = null;
        private List<String> fingerprint = null;
        private List<HttpMethod> httpMethod = null;
        private List<String> incidentKey = null;
        private List<LogType> logType = null;
        private List<String> originAddress = null;
        private List<String> referrer = null;
        private List<String> requestUrl = null;
        private List<Integer> responseCode = null;
        private List<String> threatFeedKey = null;
        private List<String> userAgent = null;
        private List<String> protectionRuleKey = null;

        public Builder waasPolicyId(String waasPolicyId) {
            this.waasPolicyId = waasPolicyId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder timeObservedGreaterThanOrEqualTo(Date timeObservedGreaterThanOrEqualTo) {
            this.timeObservedGreaterThanOrEqualTo = timeObservedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeObservedLessThan(Date timeObservedLessThan) {
            this.timeObservedLessThan = timeObservedLessThan;
            return this;
        }

        public Builder textContains(String textContains) {
            this.textContains = textContains;
            return this;
        }

        public Builder accessRuleKey(List<String> accessRuleKey) {
            this.accessRuleKey = accessRuleKey;
            return this;
        }

        public Builder accessRuleKey(String singularValue) {
            return this.accessRuleKey(Arrays.asList(singularValue));
        }

        public Builder action(List<Action> action) {
            this.action = action;
            return this;
        }

        public Builder action(Action singularValue) {
            return this.action(Arrays.asList(singularValue));
        }

        public Builder clientAddress(List<String> clientAddress) {
            this.clientAddress = clientAddress;
            return this;
        }

        public Builder clientAddress(String singularValue) {
            return this.clientAddress(Arrays.asList(singularValue));
        }

        public Builder countryCode(List<String> countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder countryCode(String singularValue) {
            return this.countryCode(Arrays.asList(singularValue));
        }

        public Builder countryName(List<String> countryName) {
            this.countryName = countryName;
            return this;
        }

        public Builder countryName(String singularValue) {
            return this.countryName(Arrays.asList(singularValue));
        }

        public Builder fingerprint(List<String> fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Builder fingerprint(String singularValue) {
            return this.fingerprint(Arrays.asList(singularValue));
        }

        public Builder httpMethod(List<HttpMethod> httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder httpMethod(HttpMethod singularValue) {
            return this.httpMethod(Arrays.asList(singularValue));
        }

        public Builder incidentKey(List<String> incidentKey) {
            this.incidentKey = incidentKey;
            return this;
        }

        public Builder incidentKey(String singularValue) {
            return this.incidentKey(Arrays.asList(singularValue));
        }

        public Builder logType(List<LogType> logType) {
            this.logType = logType;
            return this;
        }

        public Builder logType(LogType singularValue) {
            return this.logType(Arrays.asList(singularValue));
        }

        public Builder originAddress(List<String> originAddress) {
            this.originAddress = originAddress;
            return this;
        }

        public Builder originAddress(String singularValue) {
            return this.originAddress(Arrays.asList(singularValue));
        }

        public Builder referrer(List<String> referrer) {
            this.referrer = referrer;
            return this;
        }

        public Builder referrer(String singularValue) {
            return this.referrer(Arrays.asList(singularValue));
        }

        public Builder requestUrl(List<String> requestUrl) {
            this.requestUrl = requestUrl;
            return this;
        }

        public Builder requestUrl(String singularValue) {
            return this.requestUrl(Arrays.asList(singularValue));
        }

        public Builder responseCode(List<Integer> responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public Builder responseCode(Integer singularValue) {
            return this.responseCode(Arrays.asList(singularValue));
        }

        public Builder threatFeedKey(List<String> threatFeedKey) {
            this.threatFeedKey = threatFeedKey;
            return this;
        }

        public Builder threatFeedKey(String singularValue) {
            return this.threatFeedKey(Arrays.asList(singularValue));
        }

        public Builder userAgent(List<String> userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder userAgent(String singularValue) {
            return this.userAgent(Arrays.asList(singularValue));
        }

        public Builder protectionRuleKey(List<String> protectionRuleKey) {
            this.protectionRuleKey = protectionRuleKey;
            return this;
        }

        public Builder protectionRuleKey(String singularValue) {
            return this.protectionRuleKey(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWafLogsRequest o) {
            this.waasPolicyId(o.getWaasPolicyId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.timeObservedGreaterThanOrEqualTo(o.getTimeObservedGreaterThanOrEqualTo());
            this.timeObservedLessThan(o.getTimeObservedLessThan());
            this.textContains(o.getTextContains());
            this.accessRuleKey(o.getAccessRuleKey());
            this.action(o.getAction());
            this.clientAddress(o.getClientAddress());
            this.countryCode(o.getCountryCode());
            this.countryName(o.getCountryName());
            this.fingerprint(o.getFingerprint());
            this.httpMethod(o.getHttpMethod());
            this.incidentKey(o.getIncidentKey());
            this.logType(o.getLogType());
            this.originAddress(o.getOriginAddress());
            this.referrer(o.getReferrer());
            this.requestUrl(o.getRequestUrl());
            this.responseCode(o.getResponseCode());
            this.threatFeedKey(o.getThreatFeedKey());
            this.userAgent(o.getUserAgent());
            this.protectionRuleKey(o.getProtectionRuleKey());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWafLogsRequest build() {
            ListWafLogsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListWafLogsRequest buildWithoutInvocationCallback() {
            ListWafLogsRequest request = new ListWafLogsRequest();
            request.waasPolicyId = this.waasPolicyId;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            request.timeObservedGreaterThanOrEqualTo = this.timeObservedGreaterThanOrEqualTo;
            request.timeObservedLessThan = this.timeObservedLessThan;
            request.textContains = this.textContains;
            request.accessRuleKey = this.accessRuleKey;
            request.action = this.action;
            request.clientAddress = this.clientAddress;
            request.countryCode = this.countryCode;
            request.countryName = this.countryName;
            request.fingerprint = this.fingerprint;
            request.httpMethod = this.httpMethod;
            request.incidentKey = this.incidentKey;
            request.logType = this.logType;
            request.originAddress = this.originAddress;
            request.referrer = this.referrer;
            request.requestUrl = this.requestUrl;
            request.responseCode = this.responseCode;
            request.threatFeedKey = this.threatFeedKey;
            request.userAgent = this.userAgent;
            request.protectionRuleKey = this.protectionRuleKey;
            return request;
        }
    }

    public static enum LogType implements BmcEnum
    {
        Access("ACCESS"),
        ProtectionRules("PROTECTION_RULES"),
        JsChallenge("JS_CHALLENGE"),
        Captcha("CAPTCHA"),
        AccessRules("ACCESS_RULES"),
        ThreatFeeds("THREAT_FEEDS"),
        HumanInteractionChallenge("HUMAN_INTERACTION_CHALLENGE"),
        DeviceFingerprintChallenge("DEVICE_FINGERPRINT_CHALLENGE"),
        AddressRateLimiting("ADDRESS_RATE_LIMITING");

        private final String value;
        private static Map<String, LogType> map;

        private LogType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LogType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LogType: " + key);
        }

        static {
            map = new HashMap<String, LogType>();
            for (LogType v : LogType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum HttpMethod implements BmcEnum
    {
        Options("OPTIONS"),
        Get("GET"),
        Head("HEAD"),
        Post("POST"),
        Put("PUT"),
        Delete("DELETE"),
        Trace("TRACE"),
        Connect("CONNECT");

        private final String value;
        private static Map<String, HttpMethod> map;

        private HttpMethod(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static HttpMethod create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid HttpMethod: " + key);
        }

        static {
            map = new HashMap<String, HttpMethod>();
            for (HttpMethod v : HttpMethod.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Action implements BmcEnum
    {
        Block("BLOCK"),
        Detect("DETECT"),
        Bypass("BYPASS"),
        Log("LOG"),
        Redirected("REDIRECTED");

        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Action: " + key);
        }

        static {
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

