/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListWafBlockedRequestsRequest
extends BmcRequest<Void> {
    private String waasPolicyId;
    private String opcRequestId;
    private Date timeObservedGreaterThanOrEqualTo;
    private Date timeObservedLessThan;
    private Integer limit;
    private String page;
    private List<WafFeature> wafFeature;

    public String getWaasPolicyId() {
        return this.waasPolicyId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Date getTimeObservedGreaterThanOrEqualTo() {
        return this.timeObservedGreaterThanOrEqualTo;
    }

    public Date getTimeObservedLessThan() {
        return this.timeObservedLessThan;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public List<WafFeature> getWafFeature() {
        return this.wafFeature;
    }

    public Builder toBuilder() {
        return new Builder().waasPolicyId(this.waasPolicyId).opcRequestId(this.opcRequestId).timeObservedGreaterThanOrEqualTo(this.timeObservedGreaterThanOrEqualTo).timeObservedLessThan(this.timeObservedLessThan).limit(this.limit).page(this.page).wafFeature(this.wafFeature);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",waasPolicyId=").append(String.valueOf(this.waasPolicyId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",timeObservedGreaterThanOrEqualTo=").append(String.valueOf(this.timeObservedGreaterThanOrEqualTo));
        sb.append(",timeObservedLessThan=").append(String.valueOf(this.timeObservedLessThan));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",wafFeature=").append(String.valueOf(this.wafFeature));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListWafBlockedRequestsRequest)) {
            return false;
        }
        ListWafBlockedRequestsRequest other = (ListWafBlockedRequestsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.waasPolicyId, other.waasPolicyId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.timeObservedGreaterThanOrEqualTo, other.timeObservedGreaterThanOrEqualTo) && Objects.equals(this.timeObservedLessThan, other.timeObservedLessThan) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.wafFeature, other.wafFeature);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.waasPolicyId == null ? 43 : this.waasPolicyId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.timeObservedGreaterThanOrEqualTo == null ? 43 : this.timeObservedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeObservedLessThan == null ? 43 : this.timeObservedLessThan.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.wafFeature == null ? 43 : this.wafFeature.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListWafBlockedRequestsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String waasPolicyId = null;
        private String opcRequestId = null;
        private Date timeObservedGreaterThanOrEqualTo = null;
        private Date timeObservedLessThan = null;
        private Integer limit = null;
        private String page = null;
        private List<WafFeature> wafFeature = null;

        public Builder waasPolicyId(String waasPolicyId) {
            this.waasPolicyId = waasPolicyId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder timeObservedGreaterThanOrEqualTo(Date timeObservedGreaterThanOrEqualTo) {
            this.timeObservedGreaterThanOrEqualTo = timeObservedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeObservedLessThan(Date timeObservedLessThan) {
            this.timeObservedLessThan = timeObservedLessThan;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder wafFeature(List<WafFeature> wafFeature) {
            this.wafFeature = wafFeature;
            return this;
        }

        public Builder wafFeature(WafFeature singularValue) {
            return this.wafFeature(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWafBlockedRequestsRequest o) {
            this.waasPolicyId(o.getWaasPolicyId());
            this.opcRequestId(o.getOpcRequestId());
            this.timeObservedGreaterThanOrEqualTo(o.getTimeObservedGreaterThanOrEqualTo());
            this.timeObservedLessThan(o.getTimeObservedLessThan());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.wafFeature(o.getWafFeature());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWafBlockedRequestsRequest build() {
            ListWafBlockedRequestsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListWafBlockedRequestsRequest buildWithoutInvocationCallback() {
            ListWafBlockedRequestsRequest request = new ListWafBlockedRequestsRequest();
            request.waasPolicyId = this.waasPolicyId;
            request.opcRequestId = this.opcRequestId;
            request.timeObservedGreaterThanOrEqualTo = this.timeObservedGreaterThanOrEqualTo;
            request.timeObservedLessThan = this.timeObservedLessThan;
            request.limit = this.limit;
            request.page = this.page;
            request.wafFeature = this.wafFeature;
            return request;
        }
    }

    public static enum WafFeature implements BmcEnum
    {
        ProtectionRules("PROTECTION_RULES"),
        JsChallenge("JS_CHALLENGE"),
        AccessRules("ACCESS_RULES"),
        ThreatFeeds("THREAT_FEEDS"),
        HumanInteractionChallenge("HUMAN_INTERACTION_CHALLENGE"),
        DeviceFingerprintChallenge("DEVICE_FINGERPRINT_CHALLENGE"),
        Captcha("CAPTCHA"),
        AddressRateLimiting("ADDRESS_RATE_LIMITING");

        private final String value;
        private static Map<String, WafFeature> map;

        private WafFeature(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static WafFeature create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid WafFeature: " + key);
        }

        static {
            map = new HashMap<String, WafFeature>();
            for (WafFeature v : WafFeature.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

