/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WafMeterDatum
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeObserved")
    private final Date timeObserved;
    @JsonProperty(value="timeRangeInSeconds")
    private final Integer timeRangeInSeconds;
    @JsonProperty(value="tenancyId")
    private final String tenancyId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="waasPolicyId")
    private final String waasPolicyId;
    @JsonProperty(value="isOciOrigin")
    private final Boolean isOciOrigin;
    @JsonProperty(value="isBotEnabled")
    private final Boolean isBotEnabled;
    @JsonProperty(value="requestCount")
    private final Integer requestCount;
    @JsonProperty(value="trafficInBytes")
    private final Integer trafficInBytes;
    @JsonProperty(value="tagSlug")
    private final byte[] tagSlug;

    @Deprecated
    @ConstructorProperties(value={"timeObserved", "timeRangeInSeconds", "tenancyId", "compartmentId", "waasPolicyId", "isOciOrigin", "isBotEnabled", "requestCount", "trafficInBytes", "tagSlug"})
    public WafMeterDatum(Date timeObserved, Integer timeRangeInSeconds, String tenancyId, String compartmentId, String waasPolicyId, Boolean isOciOrigin, Boolean isBotEnabled, Integer requestCount, Integer trafficInBytes, byte[] tagSlug) {
        this.timeObserved = timeObserved;
        this.timeRangeInSeconds = timeRangeInSeconds;
        this.tenancyId = tenancyId;
        this.compartmentId = compartmentId;
        this.waasPolicyId = waasPolicyId;
        this.isOciOrigin = isOciOrigin;
        this.isBotEnabled = isBotEnabled;
        this.requestCount = requestCount;
        this.trafficInBytes = trafficInBytes;
        this.tagSlug = tagSlug;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeObserved() {
        return this.timeObserved;
    }

    public Integer getTimeRangeInSeconds() {
        return this.timeRangeInSeconds;
    }

    public String getTenancyId() {
        return this.tenancyId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getWaasPolicyId() {
        return this.waasPolicyId;
    }

    public Boolean getIsOciOrigin() {
        return this.isOciOrigin;
    }

    public Boolean getIsBotEnabled() {
        return this.isBotEnabled;
    }

    public Integer getRequestCount() {
        return this.requestCount;
    }

    public Integer getTrafficInBytes() {
        return this.trafficInBytes;
    }

    public byte[] getTagSlug() {
        return this.tagSlug;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WafMeterDatum(");
        sb.append("super=").append(super.toString());
        sb.append("timeObserved=").append(String.valueOf(this.timeObserved));
        sb.append(", timeRangeInSeconds=").append(String.valueOf(this.timeRangeInSeconds));
        sb.append(", tenancyId=").append(String.valueOf(this.tenancyId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", waasPolicyId=").append(String.valueOf(this.waasPolicyId));
        sb.append(", isOciOrigin=").append(String.valueOf(this.isOciOrigin));
        sb.append(", isBotEnabled=").append(String.valueOf(this.isBotEnabled));
        sb.append(", requestCount=").append(String.valueOf(this.requestCount));
        sb.append(", trafficInBytes=").append(String.valueOf(this.trafficInBytes));
        sb.append(", tagSlug=").append(includeByteArrayContents ? Arrays.toString(this.tagSlug) : String.valueOf(this.tagSlug) + (this.tagSlug != null ? " (byte[" + this.tagSlug.length + "])" : ""));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WafMeterDatum)) {
            return false;
        }
        WafMeterDatum other = (WafMeterDatum)((Object)o);
        return Objects.equals(this.timeObserved, other.timeObserved) && Objects.equals(this.timeRangeInSeconds, other.timeRangeInSeconds) && Objects.equals(this.tenancyId, other.tenancyId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.waasPolicyId, other.waasPolicyId) && Objects.equals(this.isOciOrigin, other.isOciOrigin) && Objects.equals(this.isBotEnabled, other.isBotEnabled) && Objects.equals(this.requestCount, other.requestCount) && Objects.equals(this.trafficInBytes, other.trafficInBytes) && Arrays.equals(this.tagSlug, other.tagSlug) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeObserved == null ? 43 : this.timeObserved.hashCode());
        result = result * 59 + (this.timeRangeInSeconds == null ? 43 : this.timeRangeInSeconds.hashCode());
        result = result * 59 + (this.tenancyId == null ? 43 : this.tenancyId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.waasPolicyId == null ? 43 : this.waasPolicyId.hashCode());
        result = result * 59 + (this.isOciOrigin == null ? 43 : this.isOciOrigin.hashCode());
        result = result * 59 + (this.isBotEnabled == null ? 43 : this.isBotEnabled.hashCode());
        result = result * 59 + (this.requestCount == null ? 43 : this.requestCount.hashCode());
        result = result * 59 + (this.trafficInBytes == null ? 43 : this.trafficInBytes.hashCode());
        result = result * 59 + Arrays.hashCode(this.tagSlug);
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeObserved")
        private Date timeObserved;
        @JsonProperty(value="timeRangeInSeconds")
        private Integer timeRangeInSeconds;
        @JsonProperty(value="tenancyId")
        private String tenancyId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="waasPolicyId")
        private String waasPolicyId;
        @JsonProperty(value="isOciOrigin")
        private Boolean isOciOrigin;
        @JsonProperty(value="isBotEnabled")
        private Boolean isBotEnabled;
        @JsonProperty(value="requestCount")
        private Integer requestCount;
        @JsonProperty(value="trafficInBytes")
        private Integer trafficInBytes;
        @JsonProperty(value="tagSlug")
        private byte[] tagSlug;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeObserved(Date timeObserved) {
            this.timeObserved = timeObserved;
            this.__explicitlySet__.add("timeObserved");
            return this;
        }

        public Builder timeRangeInSeconds(Integer timeRangeInSeconds) {
            this.timeRangeInSeconds = timeRangeInSeconds;
            this.__explicitlySet__.add("timeRangeInSeconds");
            return this;
        }

        public Builder tenancyId(String tenancyId) {
            this.tenancyId = tenancyId;
            this.__explicitlySet__.add("tenancyId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder waasPolicyId(String waasPolicyId) {
            this.waasPolicyId = waasPolicyId;
            this.__explicitlySet__.add("waasPolicyId");
            return this;
        }

        public Builder isOciOrigin(Boolean isOciOrigin) {
            this.isOciOrigin = isOciOrigin;
            this.__explicitlySet__.add("isOciOrigin");
            return this;
        }

        public Builder isBotEnabled(Boolean isBotEnabled) {
            this.isBotEnabled = isBotEnabled;
            this.__explicitlySet__.add("isBotEnabled");
            return this;
        }

        public Builder requestCount(Integer requestCount) {
            this.requestCount = requestCount;
            this.__explicitlySet__.add("requestCount");
            return this;
        }

        public Builder trafficInBytes(Integer trafficInBytes) {
            this.trafficInBytes = trafficInBytes;
            this.__explicitlySet__.add("trafficInBytes");
            return this;
        }

        public Builder tagSlug(byte[] tagSlug) {
            this.tagSlug = tagSlug;
            this.__explicitlySet__.add("tagSlug");
            return this;
        }

        public WafMeterDatum build() {
            WafMeterDatum model = new WafMeterDatum(this.timeObserved, this.timeRangeInSeconds, this.tenancyId, this.compartmentId, this.waasPolicyId, this.isOciOrigin, this.isBotEnabled, this.requestCount, this.trafficInBytes, this.tagSlug);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WafMeterDatum model) {
            if (model.wasPropertyExplicitlySet("timeObserved")) {
                this.timeObserved(model.getTimeObserved());
            }
            if (model.wasPropertyExplicitlySet("timeRangeInSeconds")) {
                this.timeRangeInSeconds(model.getTimeRangeInSeconds());
            }
            if (model.wasPropertyExplicitlySet("tenancyId")) {
                this.tenancyId(model.getTenancyId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("waasPolicyId")) {
                this.waasPolicyId(model.getWaasPolicyId());
            }
            if (model.wasPropertyExplicitlySet("isOciOrigin")) {
                this.isOciOrigin(model.getIsOciOrigin());
            }
            if (model.wasPropertyExplicitlySet("isBotEnabled")) {
                this.isBotEnabled(model.getIsBotEnabled());
            }
            if (model.wasPropertyExplicitlySet("requestCount")) {
                this.requestCount(model.getRequestCount());
            }
            if (model.wasPropertyExplicitlySet("trafficInBytes")) {
                this.trafficInBytes(model.getTrafficInBytes());
            }
            if (model.wasPropertyExplicitlySet("tagSlug")) {
                this.tagSlug(model.getTagSlug());
            }
            return this;
        }
    }
}

