/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.waas.model.HealthCheck;
import com.oracle.bmc.waas.model.LoadBalancingMethod;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PolicyConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="certificateId")
    private final String certificateId;
    @JsonProperty(value="isHttpsEnabled")
    private final Boolean isHttpsEnabled;
    @JsonProperty(value="isHttpsForced")
    private final Boolean isHttpsForced;
    @JsonProperty(value="tlsProtocols")
    private final List<TlsProtocols> tlsProtocols;
    @JsonProperty(value="isOriginCompressionEnabled")
    private final Boolean isOriginCompressionEnabled;
    @JsonProperty(value="isBehindCdn")
    private final Boolean isBehindCdn;
    @JsonProperty(value="clientAddressHeader")
    private final ClientAddressHeader clientAddressHeader;
    @JsonProperty(value="isCacheControlRespected")
    private final Boolean isCacheControlRespected;
    @JsonProperty(value="isResponseBufferingEnabled")
    private final Boolean isResponseBufferingEnabled;
    @JsonProperty(value="cipherGroup")
    private final CipherGroup cipherGroup;
    @JsonProperty(value="loadBalancingMethod")
    private final LoadBalancingMethod loadBalancingMethod;
    @JsonProperty(value="websocketPathPrefixes")
    private final List<String> websocketPathPrefixes;
    @JsonProperty(value="isSniEnabled")
    private final Boolean isSniEnabled;
    @JsonProperty(value="healthChecks")
    private final HealthCheck healthChecks;

    @Deprecated
    @ConstructorProperties(value={"certificateId", "isHttpsEnabled", "isHttpsForced", "tlsProtocols", "isOriginCompressionEnabled", "isBehindCdn", "clientAddressHeader", "isCacheControlRespected", "isResponseBufferingEnabled", "cipherGroup", "loadBalancingMethod", "websocketPathPrefixes", "isSniEnabled", "healthChecks"})
    public PolicyConfig(String certificateId, Boolean isHttpsEnabled, Boolean isHttpsForced, List<TlsProtocols> tlsProtocols, Boolean isOriginCompressionEnabled, Boolean isBehindCdn, ClientAddressHeader clientAddressHeader, Boolean isCacheControlRespected, Boolean isResponseBufferingEnabled, CipherGroup cipherGroup, LoadBalancingMethod loadBalancingMethod, List<String> websocketPathPrefixes, Boolean isSniEnabled, HealthCheck healthChecks) {
        this.certificateId = certificateId;
        this.isHttpsEnabled = isHttpsEnabled;
        this.isHttpsForced = isHttpsForced;
        this.tlsProtocols = tlsProtocols;
        this.isOriginCompressionEnabled = isOriginCompressionEnabled;
        this.isBehindCdn = isBehindCdn;
        this.clientAddressHeader = clientAddressHeader;
        this.isCacheControlRespected = isCacheControlRespected;
        this.isResponseBufferingEnabled = isResponseBufferingEnabled;
        this.cipherGroup = cipherGroup;
        this.loadBalancingMethod = loadBalancingMethod;
        this.websocketPathPrefixes = websocketPathPrefixes;
        this.isSniEnabled = isSniEnabled;
        this.healthChecks = healthChecks;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCertificateId() {
        return this.certificateId;
    }

    public Boolean getIsHttpsEnabled() {
        return this.isHttpsEnabled;
    }

    public Boolean getIsHttpsForced() {
        return this.isHttpsForced;
    }

    public List<TlsProtocols> getTlsProtocols() {
        return this.tlsProtocols;
    }

    public Boolean getIsOriginCompressionEnabled() {
        return this.isOriginCompressionEnabled;
    }

    public Boolean getIsBehindCdn() {
        return this.isBehindCdn;
    }

    public ClientAddressHeader getClientAddressHeader() {
        return this.clientAddressHeader;
    }

    public Boolean getIsCacheControlRespected() {
        return this.isCacheControlRespected;
    }

    public Boolean getIsResponseBufferingEnabled() {
        return this.isResponseBufferingEnabled;
    }

    public CipherGroup getCipherGroup() {
        return this.cipherGroup;
    }

    public LoadBalancingMethod getLoadBalancingMethod() {
        return this.loadBalancingMethod;
    }

    public List<String> getWebsocketPathPrefixes() {
        return this.websocketPathPrefixes;
    }

    public Boolean getIsSniEnabled() {
        return this.isSniEnabled;
    }

    public HealthCheck getHealthChecks() {
        return this.healthChecks;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PolicyConfig(");
        sb.append("super=").append(super.toString());
        sb.append("certificateId=").append(String.valueOf(this.certificateId));
        sb.append(", isHttpsEnabled=").append(String.valueOf(this.isHttpsEnabled));
        sb.append(", isHttpsForced=").append(String.valueOf(this.isHttpsForced));
        sb.append(", tlsProtocols=").append(String.valueOf(this.tlsProtocols));
        sb.append(", isOriginCompressionEnabled=").append(String.valueOf(this.isOriginCompressionEnabled));
        sb.append(", isBehindCdn=").append(String.valueOf(this.isBehindCdn));
        sb.append(", clientAddressHeader=").append(String.valueOf((Object)this.clientAddressHeader));
        sb.append(", isCacheControlRespected=").append(String.valueOf(this.isCacheControlRespected));
        sb.append(", isResponseBufferingEnabled=").append(String.valueOf(this.isResponseBufferingEnabled));
        sb.append(", cipherGroup=").append(String.valueOf((Object)this.cipherGroup));
        sb.append(", loadBalancingMethod=").append(String.valueOf((Object)this.loadBalancingMethod));
        sb.append(", websocketPathPrefixes=").append(String.valueOf(this.websocketPathPrefixes));
        sb.append(", isSniEnabled=").append(String.valueOf(this.isSniEnabled));
        sb.append(", healthChecks=").append(String.valueOf((Object)this.healthChecks));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PolicyConfig)) {
            return false;
        }
        PolicyConfig other = (PolicyConfig)((Object)o);
        return Objects.equals(this.certificateId, other.certificateId) && Objects.equals(this.isHttpsEnabled, other.isHttpsEnabled) && Objects.equals(this.isHttpsForced, other.isHttpsForced) && Objects.equals(this.tlsProtocols, other.tlsProtocols) && Objects.equals(this.isOriginCompressionEnabled, other.isOriginCompressionEnabled) && Objects.equals(this.isBehindCdn, other.isBehindCdn) && Objects.equals((Object)this.clientAddressHeader, (Object)other.clientAddressHeader) && Objects.equals(this.isCacheControlRespected, other.isCacheControlRespected) && Objects.equals(this.isResponseBufferingEnabled, other.isResponseBufferingEnabled) && Objects.equals((Object)this.cipherGroup, (Object)other.cipherGroup) && Objects.equals((Object)this.loadBalancingMethod, (Object)other.loadBalancingMethod) && Objects.equals(this.websocketPathPrefixes, other.websocketPathPrefixes) && Objects.equals(this.isSniEnabled, other.isSniEnabled) && Objects.equals((Object)this.healthChecks, (Object)other.healthChecks) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.certificateId == null ? 43 : this.certificateId.hashCode());
        result = result * 59 + (this.isHttpsEnabled == null ? 43 : this.isHttpsEnabled.hashCode());
        result = result * 59 + (this.isHttpsForced == null ? 43 : this.isHttpsForced.hashCode());
        result = result * 59 + (this.tlsProtocols == null ? 43 : this.tlsProtocols.hashCode());
        result = result * 59 + (this.isOriginCompressionEnabled == null ? 43 : this.isOriginCompressionEnabled.hashCode());
        result = result * 59 + (this.isBehindCdn == null ? 43 : this.isBehindCdn.hashCode());
        result = result * 59 + (this.clientAddressHeader == null ? 43 : this.clientAddressHeader.hashCode());
        result = result * 59 + (this.isCacheControlRespected == null ? 43 : this.isCacheControlRespected.hashCode());
        result = result * 59 + (this.isResponseBufferingEnabled == null ? 43 : this.isResponseBufferingEnabled.hashCode());
        result = result * 59 + (this.cipherGroup == null ? 43 : this.cipherGroup.hashCode());
        result = result * 59 + (this.loadBalancingMethod == null ? 43 : this.loadBalancingMethod.hashCode());
        result = result * 59 + (this.websocketPathPrefixes == null ? 43 : this.websocketPathPrefixes.hashCode());
        result = result * 59 + (this.isSniEnabled == null ? 43 : this.isSniEnabled.hashCode());
        result = result * 59 + (this.healthChecks == null ? 43 : this.healthChecks.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum CipherGroup implements BmcEnum
    {
        Default("DEFAULT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CipherGroup> map;

        private CipherGroup(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CipherGroup create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CipherGroup', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CipherGroup.class);
            map = new HashMap<String, CipherGroup>();
            for (CipherGroup v : CipherGroup.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ClientAddressHeader implements BmcEnum
    {
        XForwardedFor("X_FORWARDED_FOR"),
        XClientIp("X_CLIENT_IP"),
        XRealIp("X_REAL_IP"),
        ClientIp("CLIENT_IP"),
        TrueClientIp("TRUE_CLIENT_IP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ClientAddressHeader> map;

        private ClientAddressHeader(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ClientAddressHeader create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ClientAddressHeader', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ClientAddressHeader.class);
            map = new HashMap<String, ClientAddressHeader>();
            for (ClientAddressHeader v : ClientAddressHeader.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TlsProtocols implements BmcEnum
    {
        TlsV1("TLS_V1"),
        TlsV11("TLS_V1_1"),
        TlsV12("TLS_V1_2"),
        TlsV13("TLS_V1_3"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TlsProtocols> map;

        private TlsProtocols(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TlsProtocols create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TlsProtocols', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TlsProtocols.class);
            map = new HashMap<String, TlsProtocols>();
            for (TlsProtocols v : TlsProtocols.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="certificateId")
        private String certificateId;
        @JsonProperty(value="isHttpsEnabled")
        private Boolean isHttpsEnabled;
        @JsonProperty(value="isHttpsForced")
        private Boolean isHttpsForced;
        @JsonProperty(value="tlsProtocols")
        private List<TlsProtocols> tlsProtocols;
        @JsonProperty(value="isOriginCompressionEnabled")
        private Boolean isOriginCompressionEnabled;
        @JsonProperty(value="isBehindCdn")
        private Boolean isBehindCdn;
        @JsonProperty(value="clientAddressHeader")
        private ClientAddressHeader clientAddressHeader;
        @JsonProperty(value="isCacheControlRespected")
        private Boolean isCacheControlRespected;
        @JsonProperty(value="isResponseBufferingEnabled")
        private Boolean isResponseBufferingEnabled;
        @JsonProperty(value="cipherGroup")
        private CipherGroup cipherGroup;
        @JsonProperty(value="loadBalancingMethod")
        private LoadBalancingMethod loadBalancingMethod;
        @JsonProperty(value="websocketPathPrefixes")
        private List<String> websocketPathPrefixes;
        @JsonProperty(value="isSniEnabled")
        private Boolean isSniEnabled;
        @JsonProperty(value="healthChecks")
        private HealthCheck healthChecks;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            this.__explicitlySet__.add("certificateId");
            return this;
        }

        public Builder isHttpsEnabled(Boolean isHttpsEnabled) {
            this.isHttpsEnabled = isHttpsEnabled;
            this.__explicitlySet__.add("isHttpsEnabled");
            return this;
        }

        public Builder isHttpsForced(Boolean isHttpsForced) {
            this.isHttpsForced = isHttpsForced;
            this.__explicitlySet__.add("isHttpsForced");
            return this;
        }

        public Builder tlsProtocols(List<TlsProtocols> tlsProtocols) {
            this.tlsProtocols = tlsProtocols;
            this.__explicitlySet__.add("tlsProtocols");
            return this;
        }

        public Builder isOriginCompressionEnabled(Boolean isOriginCompressionEnabled) {
            this.isOriginCompressionEnabled = isOriginCompressionEnabled;
            this.__explicitlySet__.add("isOriginCompressionEnabled");
            return this;
        }

        public Builder isBehindCdn(Boolean isBehindCdn) {
            this.isBehindCdn = isBehindCdn;
            this.__explicitlySet__.add("isBehindCdn");
            return this;
        }

        public Builder clientAddressHeader(ClientAddressHeader clientAddressHeader) {
            this.clientAddressHeader = clientAddressHeader;
            this.__explicitlySet__.add("clientAddressHeader");
            return this;
        }

        public Builder isCacheControlRespected(Boolean isCacheControlRespected) {
            this.isCacheControlRespected = isCacheControlRespected;
            this.__explicitlySet__.add("isCacheControlRespected");
            return this;
        }

        public Builder isResponseBufferingEnabled(Boolean isResponseBufferingEnabled) {
            this.isResponseBufferingEnabled = isResponseBufferingEnabled;
            this.__explicitlySet__.add("isResponseBufferingEnabled");
            return this;
        }

        public Builder cipherGroup(CipherGroup cipherGroup) {
            this.cipherGroup = cipherGroup;
            this.__explicitlySet__.add("cipherGroup");
            return this;
        }

        public Builder loadBalancingMethod(LoadBalancingMethod loadBalancingMethod) {
            this.loadBalancingMethod = loadBalancingMethod;
            this.__explicitlySet__.add("loadBalancingMethod");
            return this;
        }

        public Builder websocketPathPrefixes(List<String> websocketPathPrefixes) {
            this.websocketPathPrefixes = websocketPathPrefixes;
            this.__explicitlySet__.add("websocketPathPrefixes");
            return this;
        }

        public Builder isSniEnabled(Boolean isSniEnabled) {
            this.isSniEnabled = isSniEnabled;
            this.__explicitlySet__.add("isSniEnabled");
            return this;
        }

        public Builder healthChecks(HealthCheck healthChecks) {
            this.healthChecks = healthChecks;
            this.__explicitlySet__.add("healthChecks");
            return this;
        }

        public PolicyConfig build() {
            PolicyConfig model = new PolicyConfig(this.certificateId, this.isHttpsEnabled, this.isHttpsForced, this.tlsProtocols, this.isOriginCompressionEnabled, this.isBehindCdn, this.clientAddressHeader, this.isCacheControlRespected, this.isResponseBufferingEnabled, this.cipherGroup, this.loadBalancingMethod, this.websocketPathPrefixes, this.isSniEnabled, this.healthChecks);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PolicyConfig model) {
            if (model.wasPropertyExplicitlySet("certificateId")) {
                this.certificateId(model.getCertificateId());
            }
            if (model.wasPropertyExplicitlySet("isHttpsEnabled")) {
                this.isHttpsEnabled(model.getIsHttpsEnabled());
            }
            if (model.wasPropertyExplicitlySet("isHttpsForced")) {
                this.isHttpsForced(model.getIsHttpsForced());
            }
            if (model.wasPropertyExplicitlySet("tlsProtocols")) {
                this.tlsProtocols(model.getTlsProtocols());
            }
            if (model.wasPropertyExplicitlySet("isOriginCompressionEnabled")) {
                this.isOriginCompressionEnabled(model.getIsOriginCompressionEnabled());
            }
            if (model.wasPropertyExplicitlySet("isBehindCdn")) {
                this.isBehindCdn(model.getIsBehindCdn());
            }
            if (model.wasPropertyExplicitlySet("clientAddressHeader")) {
                this.clientAddressHeader(model.getClientAddressHeader());
            }
            if (model.wasPropertyExplicitlySet("isCacheControlRespected")) {
                this.isCacheControlRespected(model.getIsCacheControlRespected());
            }
            if (model.wasPropertyExplicitlySet("isResponseBufferingEnabled")) {
                this.isResponseBufferingEnabled(model.getIsResponseBufferingEnabled());
            }
            if (model.wasPropertyExplicitlySet("cipherGroup")) {
                this.cipherGroup(model.getCipherGroup());
            }
            if (model.wasPropertyExplicitlySet("loadBalancingMethod")) {
                this.loadBalancingMethod(model.getLoadBalancingMethod());
            }
            if (model.wasPropertyExplicitlySet("websocketPathPrefixes")) {
                this.websocketPathPrefixes(model.getWebsocketPathPrefixes());
            }
            if (model.wasPropertyExplicitlySet("isSniEnabled")) {
                this.isSniEnabled(model.getIsSniEnabled());
            }
            if (model.wasPropertyExplicitlySet("healthChecks")) {
                this.healthChecks(model.getHealthChecks());
            }
            return this;
        }
    }
}

