/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.waas.model.AccessRuleCriteria;
import com.oracle.bmc.waas.model.BlockChallengeSettings;
import com.oracle.bmc.waas.model.Header;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JsChallenge
extends ExplicitlySetBmcModel {
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="action")
    private final Action action;
    @JsonProperty(value="failureThreshold")
    private final Integer failureThreshold;
    @JsonProperty(value="actionExpirationInSeconds")
    private final Integer actionExpirationInSeconds;
    @JsonProperty(value="setHttpHeader")
    private final Header setHttpHeader;
    @JsonProperty(value="challengeSettings")
    private final BlockChallengeSettings challengeSettings;
    @JsonProperty(value="areRedirectsChallenged")
    private final Boolean areRedirectsChallenged;
    @JsonProperty(value="criteria")
    private final List<AccessRuleCriteria> criteria;
    @JsonProperty(value="isNatEnabled")
    private final Boolean isNatEnabled;

    @Deprecated
    @ConstructorProperties(value={"isEnabled", "action", "failureThreshold", "actionExpirationInSeconds", "setHttpHeader", "challengeSettings", "areRedirectsChallenged", "criteria", "isNatEnabled"})
    public JsChallenge(Boolean isEnabled, Action action, Integer failureThreshold, Integer actionExpirationInSeconds, Header setHttpHeader, BlockChallengeSettings challengeSettings, Boolean areRedirectsChallenged, List<AccessRuleCriteria> criteria, Boolean isNatEnabled) {
        this.isEnabled = isEnabled;
        this.action = action;
        this.failureThreshold = failureThreshold;
        this.actionExpirationInSeconds = actionExpirationInSeconds;
        this.setHttpHeader = setHttpHeader;
        this.challengeSettings = challengeSettings;
        this.areRedirectsChallenged = areRedirectsChallenged;
        this.criteria = criteria;
        this.isNatEnabled = isNatEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public Action getAction() {
        return this.action;
    }

    public Integer getFailureThreshold() {
        return this.failureThreshold;
    }

    public Integer getActionExpirationInSeconds() {
        return this.actionExpirationInSeconds;
    }

    public Header getSetHttpHeader() {
        return this.setHttpHeader;
    }

    public BlockChallengeSettings getChallengeSettings() {
        return this.challengeSettings;
    }

    public Boolean getAreRedirectsChallenged() {
        return this.areRedirectsChallenged;
    }

    public List<AccessRuleCriteria> getCriteria() {
        return this.criteria;
    }

    public Boolean getIsNatEnabled() {
        return this.isNatEnabled;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JsChallenge(");
        sb.append("super=").append(super.toString());
        sb.append("isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", action=").append(String.valueOf((Object)this.action));
        sb.append(", failureThreshold=").append(String.valueOf(this.failureThreshold));
        sb.append(", actionExpirationInSeconds=").append(String.valueOf(this.actionExpirationInSeconds));
        sb.append(", setHttpHeader=").append(String.valueOf((Object)this.setHttpHeader));
        sb.append(", challengeSettings=").append(String.valueOf((Object)this.challengeSettings));
        sb.append(", areRedirectsChallenged=").append(String.valueOf(this.areRedirectsChallenged));
        sb.append(", criteria=").append(String.valueOf(this.criteria));
        sb.append(", isNatEnabled=").append(String.valueOf(this.isNatEnabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsChallenge)) {
            return false;
        }
        JsChallenge other = (JsChallenge)((Object)o);
        return Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals((Object)this.action, (Object)other.action) && Objects.equals(this.failureThreshold, other.failureThreshold) && Objects.equals(this.actionExpirationInSeconds, other.actionExpirationInSeconds) && Objects.equals((Object)this.setHttpHeader, (Object)other.setHttpHeader) && Objects.equals((Object)this.challengeSettings, (Object)other.challengeSettings) && Objects.equals(this.areRedirectsChallenged, other.areRedirectsChallenged) && Objects.equals(this.criteria, other.criteria) && Objects.equals(this.isNatEnabled, other.isNatEnabled) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.failureThreshold == null ? 43 : this.failureThreshold.hashCode());
        result = result * 59 + (this.actionExpirationInSeconds == null ? 43 : this.actionExpirationInSeconds.hashCode());
        result = result * 59 + (this.setHttpHeader == null ? 43 : this.setHttpHeader.hashCode());
        result = result * 59 + (this.challengeSettings == null ? 43 : this.challengeSettings.hashCode());
        result = result * 59 + (this.areRedirectsChallenged == null ? 43 : this.areRedirectsChallenged.hashCode());
        result = result * 59 + (this.criteria == null ? 43 : this.criteria.hashCode());
        result = result * 59 + (this.isNatEnabled == null ? 43 : this.isNatEnabled.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Action implements BmcEnum
    {
        Detect("DETECT"),
        Block("BLOCK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Action', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Action.class);
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="action")
        private Action action;
        @JsonProperty(value="failureThreshold")
        private Integer failureThreshold;
        @JsonProperty(value="actionExpirationInSeconds")
        private Integer actionExpirationInSeconds;
        @JsonProperty(value="setHttpHeader")
        private Header setHttpHeader;
        @JsonProperty(value="challengeSettings")
        private BlockChallengeSettings challengeSettings;
        @JsonProperty(value="areRedirectsChallenged")
        private Boolean areRedirectsChallenged;
        @JsonProperty(value="criteria")
        private List<AccessRuleCriteria> criteria;
        @JsonProperty(value="isNatEnabled")
        private Boolean isNatEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder failureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
            this.__explicitlySet__.add("failureThreshold");
            return this;
        }

        public Builder actionExpirationInSeconds(Integer actionExpirationInSeconds) {
            this.actionExpirationInSeconds = actionExpirationInSeconds;
            this.__explicitlySet__.add("actionExpirationInSeconds");
            return this;
        }

        public Builder setHttpHeader(Header setHttpHeader) {
            this.setHttpHeader = setHttpHeader;
            this.__explicitlySet__.add("setHttpHeader");
            return this;
        }

        public Builder challengeSettings(BlockChallengeSettings challengeSettings) {
            this.challengeSettings = challengeSettings;
            this.__explicitlySet__.add("challengeSettings");
            return this;
        }

        public Builder areRedirectsChallenged(Boolean areRedirectsChallenged) {
            this.areRedirectsChallenged = areRedirectsChallenged;
            this.__explicitlySet__.add("areRedirectsChallenged");
            return this;
        }

        public Builder criteria(List<AccessRuleCriteria> criteria) {
            this.criteria = criteria;
            this.__explicitlySet__.add("criteria");
            return this;
        }

        public Builder isNatEnabled(Boolean isNatEnabled) {
            this.isNatEnabled = isNatEnabled;
            this.__explicitlySet__.add("isNatEnabled");
            return this;
        }

        public JsChallenge build() {
            JsChallenge model = new JsChallenge(this.isEnabled, this.action, this.failureThreshold, this.actionExpirationInSeconds, this.setHttpHeader, this.challengeSettings, this.areRedirectsChallenged, this.criteria, this.isNatEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JsChallenge model) {
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("failureThreshold")) {
                this.failureThreshold(model.getFailureThreshold());
            }
            if (model.wasPropertyExplicitlySet("actionExpirationInSeconds")) {
                this.actionExpirationInSeconds(model.getActionExpirationInSeconds());
            }
            if (model.wasPropertyExplicitlySet("setHttpHeader")) {
                this.setHttpHeader(model.getSetHttpHeader());
            }
            if (model.wasPropertyExplicitlySet("challengeSettings")) {
                this.challengeSettings(model.getChallengeSettings());
            }
            if (model.wasPropertyExplicitlySet("areRedirectsChallenged")) {
                this.areRedirectsChallenged(model.getAreRedirectsChallenged());
            }
            if (model.wasPropertyExplicitlySet("criteria")) {
                this.criteria(model.getCriteria());
            }
            if (model.wasPropertyExplicitlySet("isNatEnabled")) {
                this.isNatEnabled(model.getIsNatEnabled());
            }
            return this;
        }
    }
}

