/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HealthCheck
extends ExplicitlySetBmcModel {
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="method")
    private final Method method;
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="headers")
    private final Map<String, String> headers;
    @JsonProperty(value="expectedResponseCodeGroup")
    private final List<ExpectedResponseCodeGroup> expectedResponseCodeGroup;
    @JsonProperty(value="isResponseTextCheckEnabled")
    private final Boolean isResponseTextCheckEnabled;
    @JsonProperty(value="expectedResponseText")
    private final String expectedResponseText;
    @JsonProperty(value="intervalInSeconds")
    private final Integer intervalInSeconds;
    @JsonProperty(value="timeoutInSeconds")
    private final Integer timeoutInSeconds;
    @JsonProperty(value="healthyThreshold")
    private final Integer healthyThreshold;
    @JsonProperty(value="unhealthyThreshold")
    private final Integer unhealthyThreshold;

    @Deprecated
    @ConstructorProperties(value={"isEnabled", "method", "path", "headers", "expectedResponseCodeGroup", "isResponseTextCheckEnabled", "expectedResponseText", "intervalInSeconds", "timeoutInSeconds", "healthyThreshold", "unhealthyThreshold"})
    public HealthCheck(Boolean isEnabled, Method method, String path, Map<String, String> headers, List<ExpectedResponseCodeGroup> expectedResponseCodeGroup, Boolean isResponseTextCheckEnabled, String expectedResponseText, Integer intervalInSeconds, Integer timeoutInSeconds, Integer healthyThreshold, Integer unhealthyThreshold) {
        this.isEnabled = isEnabled;
        this.method = method;
        this.path = path;
        this.headers = headers;
        this.expectedResponseCodeGroup = expectedResponseCodeGroup;
        this.isResponseTextCheckEnabled = isResponseTextCheckEnabled;
        this.expectedResponseText = expectedResponseText;
        this.intervalInSeconds = intervalInSeconds;
        this.timeoutInSeconds = timeoutInSeconds;
        this.healthyThreshold = healthyThreshold;
        this.unhealthyThreshold = unhealthyThreshold;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public List<ExpectedResponseCodeGroup> getExpectedResponseCodeGroup() {
        return this.expectedResponseCodeGroup;
    }

    public Boolean getIsResponseTextCheckEnabled() {
        return this.isResponseTextCheckEnabled;
    }

    public String getExpectedResponseText() {
        return this.expectedResponseText;
    }

    public Integer getIntervalInSeconds() {
        return this.intervalInSeconds;
    }

    public Integer getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public Integer getHealthyThreshold() {
        return this.healthyThreshold;
    }

    public Integer getUnhealthyThreshold() {
        return this.unhealthyThreshold;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HealthCheck(");
        sb.append("super=").append(super.toString());
        sb.append("isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", method=").append(String.valueOf((Object)this.method));
        sb.append(", path=").append(String.valueOf(this.path));
        sb.append(", headers=").append(String.valueOf(this.headers));
        sb.append(", expectedResponseCodeGroup=").append(String.valueOf(this.expectedResponseCodeGroup));
        sb.append(", isResponseTextCheckEnabled=").append(String.valueOf(this.isResponseTextCheckEnabled));
        sb.append(", expectedResponseText=").append(String.valueOf(this.expectedResponseText));
        sb.append(", intervalInSeconds=").append(String.valueOf(this.intervalInSeconds));
        sb.append(", timeoutInSeconds=").append(String.valueOf(this.timeoutInSeconds));
        sb.append(", healthyThreshold=").append(String.valueOf(this.healthyThreshold));
        sb.append(", unhealthyThreshold=").append(String.valueOf(this.unhealthyThreshold));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HealthCheck)) {
            return false;
        }
        HealthCheck other = (HealthCheck)((Object)o);
        return Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals((Object)this.method, (Object)other.method) && Objects.equals(this.path, other.path) && Objects.equals(this.headers, other.headers) && Objects.equals(this.expectedResponseCodeGroup, other.expectedResponseCodeGroup) && Objects.equals(this.isResponseTextCheckEnabled, other.isResponseTextCheckEnabled) && Objects.equals(this.expectedResponseText, other.expectedResponseText) && Objects.equals(this.intervalInSeconds, other.intervalInSeconds) && Objects.equals(this.timeoutInSeconds, other.timeoutInSeconds) && Objects.equals(this.healthyThreshold, other.healthyThreshold) && Objects.equals(this.unhealthyThreshold, other.unhealthyThreshold) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.method == null ? 43 : this.method.hashCode());
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.headers == null ? 43 : this.headers.hashCode());
        result = result * 59 + (this.expectedResponseCodeGroup == null ? 43 : this.expectedResponseCodeGroup.hashCode());
        result = result * 59 + (this.isResponseTextCheckEnabled == null ? 43 : this.isResponseTextCheckEnabled.hashCode());
        result = result * 59 + (this.expectedResponseText == null ? 43 : this.expectedResponseText.hashCode());
        result = result * 59 + (this.intervalInSeconds == null ? 43 : this.intervalInSeconds.hashCode());
        result = result * 59 + (this.timeoutInSeconds == null ? 43 : this.timeoutInSeconds.hashCode());
        result = result * 59 + (this.healthyThreshold == null ? 43 : this.healthyThreshold.hashCode());
        result = result * 59 + (this.unhealthyThreshold == null ? 43 : this.unhealthyThreshold.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ExpectedResponseCodeGroup implements BmcEnum
    {
        _2Xx("2XX"),
        _3Xx("3XX"),
        _4Xx("4XX"),
        _5Xx("5XX"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ExpectedResponseCodeGroup> map;

        private ExpectedResponseCodeGroup(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExpectedResponseCodeGroup create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ExpectedResponseCodeGroup', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ExpectedResponseCodeGroup.class);
            map = new HashMap<String, ExpectedResponseCodeGroup>();
            for (ExpectedResponseCodeGroup v : ExpectedResponseCodeGroup.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Method implements BmcEnum
    {
        Get("GET"),
        Head("HEAD"),
        Post("POST"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Method> map;

        private Method(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Method create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Method', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Method.class);
            map = new HashMap<String, Method>();
            for (Method v : Method.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="method")
        private Method method;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="headers")
        private Map<String, String> headers;
        @JsonProperty(value="expectedResponseCodeGroup")
        private List<ExpectedResponseCodeGroup> expectedResponseCodeGroup;
        @JsonProperty(value="isResponseTextCheckEnabled")
        private Boolean isResponseTextCheckEnabled;
        @JsonProperty(value="expectedResponseText")
        private String expectedResponseText;
        @JsonProperty(value="intervalInSeconds")
        private Integer intervalInSeconds;
        @JsonProperty(value="timeoutInSeconds")
        private Integer timeoutInSeconds;
        @JsonProperty(value="healthyThreshold")
        private Integer healthyThreshold;
        @JsonProperty(value="unhealthyThreshold")
        private Integer unhealthyThreshold;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder method(Method method) {
            this.method = method;
            this.__explicitlySet__.add("method");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.__explicitlySet__.add("path");
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            this.__explicitlySet__.add("headers");
            return this;
        }

        public Builder expectedResponseCodeGroup(List<ExpectedResponseCodeGroup> expectedResponseCodeGroup) {
            this.expectedResponseCodeGroup = expectedResponseCodeGroup;
            this.__explicitlySet__.add("expectedResponseCodeGroup");
            return this;
        }

        public Builder isResponseTextCheckEnabled(Boolean isResponseTextCheckEnabled) {
            this.isResponseTextCheckEnabled = isResponseTextCheckEnabled;
            this.__explicitlySet__.add("isResponseTextCheckEnabled");
            return this;
        }

        public Builder expectedResponseText(String expectedResponseText) {
            this.expectedResponseText = expectedResponseText;
            this.__explicitlySet__.add("expectedResponseText");
            return this;
        }

        public Builder intervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
            this.__explicitlySet__.add("intervalInSeconds");
            return this;
        }

        public Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            this.__explicitlySet__.add("timeoutInSeconds");
            return this;
        }

        public Builder healthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
            this.__explicitlySet__.add("healthyThreshold");
            return this;
        }

        public Builder unhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
            this.__explicitlySet__.add("unhealthyThreshold");
            return this;
        }

        public HealthCheck build() {
            HealthCheck model = new HealthCheck(this.isEnabled, this.method, this.path, this.headers, this.expectedResponseCodeGroup, this.isResponseTextCheckEnabled, this.expectedResponseText, this.intervalInSeconds, this.timeoutInSeconds, this.healthyThreshold, this.unhealthyThreshold);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HealthCheck model) {
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("method")) {
                this.method(model.getMethod());
            }
            if (model.wasPropertyExplicitlySet("path")) {
                this.path(model.getPath());
            }
            if (model.wasPropertyExplicitlySet("headers")) {
                this.headers(model.getHeaders());
            }
            if (model.wasPropertyExplicitlySet("expectedResponseCodeGroup")) {
                this.expectedResponseCodeGroup(model.getExpectedResponseCodeGroup());
            }
            if (model.wasPropertyExplicitlySet("isResponseTextCheckEnabled")) {
                this.isResponseTextCheckEnabled(model.getIsResponseTextCheckEnabled());
            }
            if (model.wasPropertyExplicitlySet("expectedResponseText")) {
                this.expectedResponseText(model.getExpectedResponseText());
            }
            if (model.wasPropertyExplicitlySet("intervalInSeconds")) {
                this.intervalInSeconds(model.getIntervalInSeconds());
            }
            if (model.wasPropertyExplicitlySet("timeoutInSeconds")) {
                this.timeoutInSeconds(model.getTimeoutInSeconds());
            }
            if (model.wasPropertyExplicitlySet("healthyThreshold")) {
                this.healthyThreshold(model.getHealthyThreshold());
            }
            if (model.wasPropertyExplicitlySet("unhealthyThreshold")) {
                this.unhealthyThreshold(model.getUnhealthyThreshold());
            }
            return this;
        }
    }
}

