/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.waas.model.BlockChallengeSettings;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DeviceFingerprintChallenge
extends ExplicitlySetBmcModel {
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="action")
    private final Action action;
    @JsonProperty(value="failureThreshold")
    private final Integer failureThreshold;
    @JsonProperty(value="actionExpirationInSeconds")
    private final Integer actionExpirationInSeconds;
    @JsonProperty(value="failureThresholdExpirationInSeconds")
    private final Integer failureThresholdExpirationInSeconds;
    @JsonProperty(value="maxAddressCount")
    private final Integer maxAddressCount;
    @JsonProperty(value="maxAddressCountExpirationInSeconds")
    private final Integer maxAddressCountExpirationInSeconds;
    @JsonProperty(value="challengeSettings")
    private final BlockChallengeSettings challengeSettings;

    @Deprecated
    @ConstructorProperties(value={"isEnabled", "action", "failureThreshold", "actionExpirationInSeconds", "failureThresholdExpirationInSeconds", "maxAddressCount", "maxAddressCountExpirationInSeconds", "challengeSettings"})
    public DeviceFingerprintChallenge(Boolean isEnabled, Action action, Integer failureThreshold, Integer actionExpirationInSeconds, Integer failureThresholdExpirationInSeconds, Integer maxAddressCount, Integer maxAddressCountExpirationInSeconds, BlockChallengeSettings challengeSettings) {
        this.isEnabled = isEnabled;
        this.action = action;
        this.failureThreshold = failureThreshold;
        this.actionExpirationInSeconds = actionExpirationInSeconds;
        this.failureThresholdExpirationInSeconds = failureThresholdExpirationInSeconds;
        this.maxAddressCount = maxAddressCount;
        this.maxAddressCountExpirationInSeconds = maxAddressCountExpirationInSeconds;
        this.challengeSettings = challengeSettings;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public Action getAction() {
        return this.action;
    }

    public Integer getFailureThreshold() {
        return this.failureThreshold;
    }

    public Integer getActionExpirationInSeconds() {
        return this.actionExpirationInSeconds;
    }

    public Integer getFailureThresholdExpirationInSeconds() {
        return this.failureThresholdExpirationInSeconds;
    }

    public Integer getMaxAddressCount() {
        return this.maxAddressCount;
    }

    public Integer getMaxAddressCountExpirationInSeconds() {
        return this.maxAddressCountExpirationInSeconds;
    }

    public BlockChallengeSettings getChallengeSettings() {
        return this.challengeSettings;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DeviceFingerprintChallenge(");
        sb.append("super=").append(super.toString());
        sb.append("isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", action=").append(String.valueOf((Object)this.action));
        sb.append(", failureThreshold=").append(String.valueOf(this.failureThreshold));
        sb.append(", actionExpirationInSeconds=").append(String.valueOf(this.actionExpirationInSeconds));
        sb.append(", failureThresholdExpirationInSeconds=").append(String.valueOf(this.failureThresholdExpirationInSeconds));
        sb.append(", maxAddressCount=").append(String.valueOf(this.maxAddressCount));
        sb.append(", maxAddressCountExpirationInSeconds=").append(String.valueOf(this.maxAddressCountExpirationInSeconds));
        sb.append(", challengeSettings=").append(String.valueOf((Object)this.challengeSettings));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeviceFingerprintChallenge)) {
            return false;
        }
        DeviceFingerprintChallenge other = (DeviceFingerprintChallenge)((Object)o);
        return Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals((Object)this.action, (Object)other.action) && Objects.equals(this.failureThreshold, other.failureThreshold) && Objects.equals(this.actionExpirationInSeconds, other.actionExpirationInSeconds) && Objects.equals(this.failureThresholdExpirationInSeconds, other.failureThresholdExpirationInSeconds) && Objects.equals(this.maxAddressCount, other.maxAddressCount) && Objects.equals(this.maxAddressCountExpirationInSeconds, other.maxAddressCountExpirationInSeconds) && Objects.equals((Object)this.challengeSettings, (Object)other.challengeSettings) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.failureThreshold == null ? 43 : this.failureThreshold.hashCode());
        result = result * 59 + (this.actionExpirationInSeconds == null ? 43 : this.actionExpirationInSeconds.hashCode());
        result = result * 59 + (this.failureThresholdExpirationInSeconds == null ? 43 : this.failureThresholdExpirationInSeconds.hashCode());
        result = result * 59 + (this.maxAddressCount == null ? 43 : this.maxAddressCount.hashCode());
        result = result * 59 + (this.maxAddressCountExpirationInSeconds == null ? 43 : this.maxAddressCountExpirationInSeconds.hashCode());
        result = result * 59 + (this.challengeSettings == null ? 43 : this.challengeSettings.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Action implements BmcEnum
    {
        Detect("DETECT"),
        Block("BLOCK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Action', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Action.class);
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="action")
        private Action action;
        @JsonProperty(value="failureThreshold")
        private Integer failureThreshold;
        @JsonProperty(value="actionExpirationInSeconds")
        private Integer actionExpirationInSeconds;
        @JsonProperty(value="failureThresholdExpirationInSeconds")
        private Integer failureThresholdExpirationInSeconds;
        @JsonProperty(value="maxAddressCount")
        private Integer maxAddressCount;
        @JsonProperty(value="maxAddressCountExpirationInSeconds")
        private Integer maxAddressCountExpirationInSeconds;
        @JsonProperty(value="challengeSettings")
        private BlockChallengeSettings challengeSettings;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder failureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
            this.__explicitlySet__.add("failureThreshold");
            return this;
        }

        public Builder actionExpirationInSeconds(Integer actionExpirationInSeconds) {
            this.actionExpirationInSeconds = actionExpirationInSeconds;
            this.__explicitlySet__.add("actionExpirationInSeconds");
            return this;
        }

        public Builder failureThresholdExpirationInSeconds(Integer failureThresholdExpirationInSeconds) {
            this.failureThresholdExpirationInSeconds = failureThresholdExpirationInSeconds;
            this.__explicitlySet__.add("failureThresholdExpirationInSeconds");
            return this;
        }

        public Builder maxAddressCount(Integer maxAddressCount) {
            this.maxAddressCount = maxAddressCount;
            this.__explicitlySet__.add("maxAddressCount");
            return this;
        }

        public Builder maxAddressCountExpirationInSeconds(Integer maxAddressCountExpirationInSeconds) {
            this.maxAddressCountExpirationInSeconds = maxAddressCountExpirationInSeconds;
            this.__explicitlySet__.add("maxAddressCountExpirationInSeconds");
            return this;
        }

        public Builder challengeSettings(BlockChallengeSettings challengeSettings) {
            this.challengeSettings = challengeSettings;
            this.__explicitlySet__.add("challengeSettings");
            return this;
        }

        public DeviceFingerprintChallenge build() {
            DeviceFingerprintChallenge model = new DeviceFingerprintChallenge(this.isEnabled, this.action, this.failureThreshold, this.actionExpirationInSeconds, this.failureThresholdExpirationInSeconds, this.maxAddressCount, this.maxAddressCountExpirationInSeconds, this.challengeSettings);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DeviceFingerprintChallenge model) {
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("failureThreshold")) {
                this.failureThreshold(model.getFailureThreshold());
            }
            if (model.wasPropertyExplicitlySet("actionExpirationInSeconds")) {
                this.actionExpirationInSeconds(model.getActionExpirationInSeconds());
            }
            if (model.wasPropertyExplicitlySet("failureThresholdExpirationInSeconds")) {
                this.failureThresholdExpirationInSeconds(model.getFailureThresholdExpirationInSeconds());
            }
            if (model.wasPropertyExplicitlySet("maxAddressCount")) {
                this.maxAddressCount(model.getMaxAddressCount());
            }
            if (model.wasPropertyExplicitlySet("maxAddressCountExpirationInSeconds")) {
                this.maxAddressCountExpirationInSeconds(model.getMaxAddressCountExpirationInSeconds());
            }
            if (model.wasPropertyExplicitlySet("challengeSettings")) {
                this.challengeSettings(model.getChallengeSettings());
            }
            return this;
        }
    }
}

