/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CertificateIssuerName
extends ExplicitlySetBmcModel {
    @JsonProperty(value="country")
    private final String country;
    @JsonProperty(value="stateProvince")
    private final String stateProvince;
    @JsonProperty(value="locality")
    private final String locality;
    @JsonProperty(value="organization")
    private final String organization;
    @JsonProperty(value="organizationalUnit")
    private final String organizationalUnit;
    @JsonProperty(value="commonName")
    private final String commonName;
    @JsonProperty(value="emailAddress")
    private final String emailAddress;

    @Deprecated
    @ConstructorProperties(value={"country", "stateProvince", "locality", "organization", "organizationalUnit", "commonName", "emailAddress"})
    public CertificateIssuerName(String country, String stateProvince, String locality, String organization, String organizationalUnit, String commonName, String emailAddress) {
        this.country = country;
        this.stateProvince = stateProvince;
        this.locality = locality;
        this.organization = organization;
        this.organizationalUnit = organizationalUnit;
        this.commonName = commonName;
        this.emailAddress = emailAddress;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCountry() {
        return this.country;
    }

    public String getStateProvince() {
        return this.stateProvince;
    }

    public String getLocality() {
        return this.locality;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getOrganizationalUnit() {
        return this.organizationalUnit;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CertificateIssuerName(");
        sb.append("super=").append(super.toString());
        sb.append("country=").append(String.valueOf(this.country));
        sb.append(", stateProvince=").append(String.valueOf(this.stateProvince));
        sb.append(", locality=").append(String.valueOf(this.locality));
        sb.append(", organization=").append(String.valueOf(this.organization));
        sb.append(", organizationalUnit=").append(String.valueOf(this.organizationalUnit));
        sb.append(", commonName=").append(String.valueOf(this.commonName));
        sb.append(", emailAddress=").append(String.valueOf(this.emailAddress));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CertificateIssuerName)) {
            return false;
        }
        CertificateIssuerName other = (CertificateIssuerName)((Object)o);
        return Objects.equals(this.country, other.country) && Objects.equals(this.stateProvince, other.stateProvince) && Objects.equals(this.locality, other.locality) && Objects.equals(this.organization, other.organization) && Objects.equals(this.organizationalUnit, other.organizationalUnit) && Objects.equals(this.commonName, other.commonName) && Objects.equals(this.emailAddress, other.emailAddress) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.country == null ? 43 : this.country.hashCode());
        result = result * 59 + (this.stateProvince == null ? 43 : this.stateProvince.hashCode());
        result = result * 59 + (this.locality == null ? 43 : this.locality.hashCode());
        result = result * 59 + (this.organization == null ? 43 : this.organization.hashCode());
        result = result * 59 + (this.organizationalUnit == null ? 43 : this.organizationalUnit.hashCode());
        result = result * 59 + (this.commonName == null ? 43 : this.commonName.hashCode());
        result = result * 59 + (this.emailAddress == null ? 43 : this.emailAddress.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="country")
        private String country;
        @JsonProperty(value="stateProvince")
        private String stateProvince;
        @JsonProperty(value="locality")
        private String locality;
        @JsonProperty(value="organization")
        private String organization;
        @JsonProperty(value="organizationalUnit")
        private String organizationalUnit;
        @JsonProperty(value="commonName")
        private String commonName;
        @JsonProperty(value="emailAddress")
        private String emailAddress;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder country(String country) {
            this.country = country;
            this.__explicitlySet__.add("country");
            return this;
        }

        public Builder stateProvince(String stateProvince) {
            this.stateProvince = stateProvince;
            this.__explicitlySet__.add("stateProvince");
            return this;
        }

        public Builder locality(String locality) {
            this.locality = locality;
            this.__explicitlySet__.add("locality");
            return this;
        }

        public Builder organization(String organization) {
            this.organization = organization;
            this.__explicitlySet__.add("organization");
            return this;
        }

        public Builder organizationalUnit(String organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
            this.__explicitlySet__.add("organizationalUnit");
            return this;
        }

        public Builder commonName(String commonName) {
            this.commonName = commonName;
            this.__explicitlySet__.add("commonName");
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            this.__explicitlySet__.add("emailAddress");
            return this;
        }

        public CertificateIssuerName build() {
            CertificateIssuerName model = new CertificateIssuerName(this.country, this.stateProvince, this.locality, this.organization, this.organizationalUnit, this.commonName, this.emailAddress);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CertificateIssuerName model) {
            if (model.wasPropertyExplicitlySet("country")) {
                this.country(model.getCountry());
            }
            if (model.wasPropertyExplicitlySet("stateProvince")) {
                this.stateProvince(model.getStateProvince());
            }
            if (model.wasPropertyExplicitlySet("locality")) {
                this.locality(model.getLocality());
            }
            if (model.wasPropertyExplicitlySet("organization")) {
                this.organization(model.getOrganization());
            }
            if (model.wasPropertyExplicitlySet("organizationalUnit")) {
                this.organizationalUnit(model.getOrganizationalUnit());
            }
            if (model.wasPropertyExplicitlySet("commonName")) {
                this.commonName(model.getCommonName());
            }
            if (model.wasPropertyExplicitlySet("emailAddress")) {
                this.emailAddress(model.getEmailAddress());
            }
            return this;
        }
    }
}

