/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.waas.model.CertificateIssuerName;
import com.oracle.bmc.waas.model.CertificateSubjectName;
import com.oracle.bmc.waas.model.Certificate_extensions;
import com.oracle.bmc.waas.model.Certificate_publicKeyInfo;
import com.oracle.bmc.waas.model.LifecycleStates;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Certificate
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="issuedBy")
    private final String issuedBy;
    @JsonProperty(value="subjectName")
    private final CertificateSubjectName subjectName;
    @JsonProperty(value="issuerName")
    private final CertificateIssuerName issuerName;
    @JsonProperty(value="serialNumber")
    private final String serialNumber;
    @JsonProperty(value="version")
    private final Integer version;
    @JsonProperty(value="signatureAlgorithm")
    private final String signatureAlgorithm;
    @JsonProperty(value="timeNotValidBefore")
    private final Date timeNotValidBefore;
    @JsonProperty(value="timeNotValidAfter")
    private final Date timeNotValidAfter;
    @JsonProperty(value="publicKeyInfo")
    private final Certificate_publicKeyInfo publicKeyInfo;
    @JsonProperty(value="extensions")
    private final List<Certificate_extensions> extensions;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="lifecycleState")
    private final LifecycleStates lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="isTrustVerificationDisabled")
    private final Boolean isTrustVerificationDisabled;
    @JsonProperty(value="certificateData")
    private final String certificateData;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "issuedBy", "subjectName", "issuerName", "serialNumber", "version", "signatureAlgorithm", "timeNotValidBefore", "timeNotValidAfter", "publicKeyInfo", "extensions", "freeformTags", "definedTags", "lifecycleState", "timeCreated", "isTrustVerificationDisabled", "certificateData"})
    public Certificate(String id, String compartmentId, String displayName, String issuedBy, CertificateSubjectName subjectName, CertificateIssuerName issuerName, String serialNumber, Integer version, String signatureAlgorithm, Date timeNotValidBefore, Date timeNotValidAfter, Certificate_publicKeyInfo publicKeyInfo, List<Certificate_extensions> extensions, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, LifecycleStates lifecycleState, Date timeCreated, Boolean isTrustVerificationDisabled, String certificateData) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.issuedBy = issuedBy;
        this.subjectName = subjectName;
        this.issuerName = issuerName;
        this.serialNumber = serialNumber;
        this.version = version;
        this.signatureAlgorithm = signatureAlgorithm;
        this.timeNotValidBefore = timeNotValidBefore;
        this.timeNotValidAfter = timeNotValidAfter;
        this.publicKeyInfo = publicKeyInfo;
        this.extensions = extensions;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.isTrustVerificationDisabled = isTrustVerificationDisabled;
        this.certificateData = certificateData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getIssuedBy() {
        return this.issuedBy;
    }

    public CertificateSubjectName getSubjectName() {
        return this.subjectName;
    }

    public CertificateIssuerName getIssuerName() {
        return this.issuerName;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public Date getTimeNotValidBefore() {
        return this.timeNotValidBefore;
    }

    public Date getTimeNotValidAfter() {
        return this.timeNotValidAfter;
    }

    public Certificate_publicKeyInfo getPublicKeyInfo() {
        return this.publicKeyInfo;
    }

    public List<Certificate_extensions> getExtensions() {
        return this.extensions;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public LifecycleStates getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Boolean getIsTrustVerificationDisabled() {
        return this.isTrustVerificationDisabled;
    }

    public String getCertificateData() {
        return this.certificateData;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Certificate(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", issuedBy=").append(String.valueOf(this.issuedBy));
        sb.append(", subjectName=").append(String.valueOf((Object)this.subjectName));
        sb.append(", issuerName=").append(String.valueOf((Object)this.issuerName));
        sb.append(", serialNumber=").append(String.valueOf(this.serialNumber));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", signatureAlgorithm=").append(String.valueOf(this.signatureAlgorithm));
        sb.append(", timeNotValidBefore=").append(String.valueOf(this.timeNotValidBefore));
        sb.append(", timeNotValidAfter=").append(String.valueOf(this.timeNotValidAfter));
        sb.append(", publicKeyInfo=").append(String.valueOf((Object)this.publicKeyInfo));
        sb.append(", extensions=").append(String.valueOf(this.extensions));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", isTrustVerificationDisabled=").append(String.valueOf(this.isTrustVerificationDisabled));
        sb.append(", certificateData=").append(String.valueOf(this.certificateData));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.issuedBy, other.issuedBy) && Objects.equals((Object)this.subjectName, (Object)other.subjectName) && Objects.equals((Object)this.issuerName, (Object)other.issuerName) && Objects.equals(this.serialNumber, other.serialNumber) && Objects.equals(this.version, other.version) && Objects.equals(this.signatureAlgorithm, other.signatureAlgorithm) && Objects.equals(this.timeNotValidBefore, other.timeNotValidBefore) && Objects.equals(this.timeNotValidAfter, other.timeNotValidAfter) && Objects.equals((Object)this.publicKeyInfo, (Object)other.publicKeyInfo) && Objects.equals(this.extensions, other.extensions) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.isTrustVerificationDisabled, other.isTrustVerificationDisabled) && Objects.equals(this.certificateData, other.certificateData) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.issuedBy == null ? 43 : this.issuedBy.hashCode());
        result = result * 59 + (this.subjectName == null ? 43 : this.subjectName.hashCode());
        result = result * 59 + (this.issuerName == null ? 43 : this.issuerName.hashCode());
        result = result * 59 + (this.serialNumber == null ? 43 : this.serialNumber.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.signatureAlgorithm == null ? 43 : this.signatureAlgorithm.hashCode());
        result = result * 59 + (this.timeNotValidBefore == null ? 43 : this.timeNotValidBefore.hashCode());
        result = result * 59 + (this.timeNotValidAfter == null ? 43 : this.timeNotValidAfter.hashCode());
        result = result * 59 + (this.publicKeyInfo == null ? 43 : this.publicKeyInfo.hashCode());
        result = result * 59 + (this.extensions == null ? 43 : this.extensions.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.isTrustVerificationDisabled == null ? 43 : this.isTrustVerificationDisabled.hashCode());
        result = result * 59 + (this.certificateData == null ? 43 : this.certificateData.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="issuedBy")
        private String issuedBy;
        @JsonProperty(value="subjectName")
        private CertificateSubjectName subjectName;
        @JsonProperty(value="issuerName")
        private CertificateIssuerName issuerName;
        @JsonProperty(value="serialNumber")
        private String serialNumber;
        @JsonProperty(value="version")
        private Integer version;
        @JsonProperty(value="signatureAlgorithm")
        private String signatureAlgorithm;
        @JsonProperty(value="timeNotValidBefore")
        private Date timeNotValidBefore;
        @JsonProperty(value="timeNotValidAfter")
        private Date timeNotValidAfter;
        @JsonProperty(value="publicKeyInfo")
        private Certificate_publicKeyInfo publicKeyInfo;
        @JsonProperty(value="extensions")
        private List<Certificate_extensions> extensions;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="lifecycleState")
        private LifecycleStates lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="isTrustVerificationDisabled")
        private Boolean isTrustVerificationDisabled;
        @JsonProperty(value="certificateData")
        private String certificateData;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder issuedBy(String issuedBy) {
            this.issuedBy = issuedBy;
            this.__explicitlySet__.add("issuedBy");
            return this;
        }

        public Builder subjectName(CertificateSubjectName subjectName) {
            this.subjectName = subjectName;
            this.__explicitlySet__.add("subjectName");
            return this;
        }

        public Builder issuerName(CertificateIssuerName issuerName) {
            this.issuerName = issuerName;
            this.__explicitlySet__.add("issuerName");
            return this;
        }

        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.__explicitlySet__.add("serialNumber");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder signatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            this.__explicitlySet__.add("signatureAlgorithm");
            return this;
        }

        public Builder timeNotValidBefore(Date timeNotValidBefore) {
            this.timeNotValidBefore = timeNotValidBefore;
            this.__explicitlySet__.add("timeNotValidBefore");
            return this;
        }

        public Builder timeNotValidAfter(Date timeNotValidAfter) {
            this.timeNotValidAfter = timeNotValidAfter;
            this.__explicitlySet__.add("timeNotValidAfter");
            return this;
        }

        public Builder publicKeyInfo(Certificate_publicKeyInfo publicKeyInfo) {
            this.publicKeyInfo = publicKeyInfo;
            this.__explicitlySet__.add("publicKeyInfo");
            return this;
        }

        public Builder extensions(List<Certificate_extensions> extensions) {
            this.extensions = extensions;
            this.__explicitlySet__.add("extensions");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder lifecycleState(LifecycleStates lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder isTrustVerificationDisabled(Boolean isTrustVerificationDisabled) {
            this.isTrustVerificationDisabled = isTrustVerificationDisabled;
            this.__explicitlySet__.add("isTrustVerificationDisabled");
            return this;
        }

        public Builder certificateData(String certificateData) {
            this.certificateData = certificateData;
            this.__explicitlySet__.add("certificateData");
            return this;
        }

        public Certificate build() {
            Certificate model = new Certificate(this.id, this.compartmentId, this.displayName, this.issuedBy, this.subjectName, this.issuerName, this.serialNumber, this.version, this.signatureAlgorithm, this.timeNotValidBefore, this.timeNotValidAfter, this.publicKeyInfo, this.extensions, this.freeformTags, this.definedTags, this.lifecycleState, this.timeCreated, this.isTrustVerificationDisabled, this.certificateData);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Certificate model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("issuedBy")) {
                this.issuedBy(model.getIssuedBy());
            }
            if (model.wasPropertyExplicitlySet("subjectName")) {
                this.subjectName(model.getSubjectName());
            }
            if (model.wasPropertyExplicitlySet("issuerName")) {
                this.issuerName(model.getIssuerName());
            }
            if (model.wasPropertyExplicitlySet("serialNumber")) {
                this.serialNumber(model.getSerialNumber());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("signatureAlgorithm")) {
                this.signatureAlgorithm(model.getSignatureAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("timeNotValidBefore")) {
                this.timeNotValidBefore(model.getTimeNotValidBefore());
            }
            if (model.wasPropertyExplicitlySet("timeNotValidAfter")) {
                this.timeNotValidAfter(model.getTimeNotValidAfter());
            }
            if (model.wasPropertyExplicitlySet("publicKeyInfo")) {
                this.publicKeyInfo(model.getPublicKeyInfo());
            }
            if (model.wasPropertyExplicitlySet("extensions")) {
                this.extensions(model.getExtensions());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("isTrustVerificationDisabled")) {
                this.isTrustVerificationDisabled(model.getIsTrustVerificationDisabled());
            }
            if (model.wasPropertyExplicitlySet("certificateData")) {
                this.certificateData(model.getCertificateData());
            }
            return this;
        }
    }
}

