/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BlockChallengeSettings
extends ExplicitlySetBmcModel {
    @JsonProperty(value="blockAction")
    private final BlockAction blockAction;
    @JsonProperty(value="blockResponseCode")
    private final Integer blockResponseCode;
    @JsonProperty(value="blockErrorPageMessage")
    private final String blockErrorPageMessage;
    @JsonProperty(value="blockErrorPageDescription")
    private final String blockErrorPageDescription;
    @JsonProperty(value="blockErrorPageCode")
    private final String blockErrorPageCode;
    @JsonProperty(value="captchaTitle")
    private final String captchaTitle;
    @JsonProperty(value="captchaHeader")
    private final String captchaHeader;
    @JsonProperty(value="captchaFooter")
    private final String captchaFooter;
    @JsonProperty(value="captchaSubmitLabel")
    private final String captchaSubmitLabel;

    @Deprecated
    @ConstructorProperties(value={"blockAction", "blockResponseCode", "blockErrorPageMessage", "blockErrorPageDescription", "blockErrorPageCode", "captchaTitle", "captchaHeader", "captchaFooter", "captchaSubmitLabel"})
    public BlockChallengeSettings(BlockAction blockAction, Integer blockResponseCode, String blockErrorPageMessage, String blockErrorPageDescription, String blockErrorPageCode, String captchaTitle, String captchaHeader, String captchaFooter, String captchaSubmitLabel) {
        this.blockAction = blockAction;
        this.blockResponseCode = blockResponseCode;
        this.blockErrorPageMessage = blockErrorPageMessage;
        this.blockErrorPageDescription = blockErrorPageDescription;
        this.blockErrorPageCode = blockErrorPageCode;
        this.captchaTitle = captchaTitle;
        this.captchaHeader = captchaHeader;
        this.captchaFooter = captchaFooter;
        this.captchaSubmitLabel = captchaSubmitLabel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public BlockAction getBlockAction() {
        return this.blockAction;
    }

    public Integer getBlockResponseCode() {
        return this.blockResponseCode;
    }

    public String getBlockErrorPageMessage() {
        return this.blockErrorPageMessage;
    }

    public String getBlockErrorPageDescription() {
        return this.blockErrorPageDescription;
    }

    public String getBlockErrorPageCode() {
        return this.blockErrorPageCode;
    }

    public String getCaptchaTitle() {
        return this.captchaTitle;
    }

    public String getCaptchaHeader() {
        return this.captchaHeader;
    }

    public String getCaptchaFooter() {
        return this.captchaFooter;
    }

    public String getCaptchaSubmitLabel() {
        return this.captchaSubmitLabel;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BlockChallengeSettings(");
        sb.append("super=").append(super.toString());
        sb.append("blockAction=").append(String.valueOf((Object)this.blockAction));
        sb.append(", blockResponseCode=").append(String.valueOf(this.blockResponseCode));
        sb.append(", blockErrorPageMessage=").append(String.valueOf(this.blockErrorPageMessage));
        sb.append(", blockErrorPageDescription=").append(String.valueOf(this.blockErrorPageDescription));
        sb.append(", blockErrorPageCode=").append(String.valueOf(this.blockErrorPageCode));
        sb.append(", captchaTitle=").append(String.valueOf(this.captchaTitle));
        sb.append(", captchaHeader=").append(String.valueOf(this.captchaHeader));
        sb.append(", captchaFooter=").append(String.valueOf(this.captchaFooter));
        sb.append(", captchaSubmitLabel=").append(String.valueOf(this.captchaSubmitLabel));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockChallengeSettings)) {
            return false;
        }
        BlockChallengeSettings other = (BlockChallengeSettings)((Object)o);
        return Objects.equals((Object)this.blockAction, (Object)other.blockAction) && Objects.equals(this.blockResponseCode, other.blockResponseCode) && Objects.equals(this.blockErrorPageMessage, other.blockErrorPageMessage) && Objects.equals(this.blockErrorPageDescription, other.blockErrorPageDescription) && Objects.equals(this.blockErrorPageCode, other.blockErrorPageCode) && Objects.equals(this.captchaTitle, other.captchaTitle) && Objects.equals(this.captchaHeader, other.captchaHeader) && Objects.equals(this.captchaFooter, other.captchaFooter) && Objects.equals(this.captchaSubmitLabel, other.captchaSubmitLabel) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.blockAction == null ? 43 : this.blockAction.hashCode());
        result = result * 59 + (this.blockResponseCode == null ? 43 : this.blockResponseCode.hashCode());
        result = result * 59 + (this.blockErrorPageMessage == null ? 43 : this.blockErrorPageMessage.hashCode());
        result = result * 59 + (this.blockErrorPageDescription == null ? 43 : this.blockErrorPageDescription.hashCode());
        result = result * 59 + (this.blockErrorPageCode == null ? 43 : this.blockErrorPageCode.hashCode());
        result = result * 59 + (this.captchaTitle == null ? 43 : this.captchaTitle.hashCode());
        result = result * 59 + (this.captchaHeader == null ? 43 : this.captchaHeader.hashCode());
        result = result * 59 + (this.captchaFooter == null ? 43 : this.captchaFooter.hashCode());
        result = result * 59 + (this.captchaSubmitLabel == null ? 43 : this.captchaSubmitLabel.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum BlockAction implements BmcEnum
    {
        SetResponseCode("SET_RESPONSE_CODE"),
        ShowErrorPage("SHOW_ERROR_PAGE"),
        ShowCaptcha("SHOW_CAPTCHA"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BlockAction> map;

        private BlockAction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BlockAction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BlockAction', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BlockAction.class);
            map = new HashMap<String, BlockAction>();
            for (BlockAction v : BlockAction.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="blockAction")
        private BlockAction blockAction;
        @JsonProperty(value="blockResponseCode")
        private Integer blockResponseCode;
        @JsonProperty(value="blockErrorPageMessage")
        private String blockErrorPageMessage;
        @JsonProperty(value="blockErrorPageDescription")
        private String blockErrorPageDescription;
        @JsonProperty(value="blockErrorPageCode")
        private String blockErrorPageCode;
        @JsonProperty(value="captchaTitle")
        private String captchaTitle;
        @JsonProperty(value="captchaHeader")
        private String captchaHeader;
        @JsonProperty(value="captchaFooter")
        private String captchaFooter;
        @JsonProperty(value="captchaSubmitLabel")
        private String captchaSubmitLabel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder blockAction(BlockAction blockAction) {
            this.blockAction = blockAction;
            this.__explicitlySet__.add("blockAction");
            return this;
        }

        public Builder blockResponseCode(Integer blockResponseCode) {
            this.blockResponseCode = blockResponseCode;
            this.__explicitlySet__.add("blockResponseCode");
            return this;
        }

        public Builder blockErrorPageMessage(String blockErrorPageMessage) {
            this.blockErrorPageMessage = blockErrorPageMessage;
            this.__explicitlySet__.add("blockErrorPageMessage");
            return this;
        }

        public Builder blockErrorPageDescription(String blockErrorPageDescription) {
            this.blockErrorPageDescription = blockErrorPageDescription;
            this.__explicitlySet__.add("blockErrorPageDescription");
            return this;
        }

        public Builder blockErrorPageCode(String blockErrorPageCode) {
            this.blockErrorPageCode = blockErrorPageCode;
            this.__explicitlySet__.add("blockErrorPageCode");
            return this;
        }

        public Builder captchaTitle(String captchaTitle) {
            this.captchaTitle = captchaTitle;
            this.__explicitlySet__.add("captchaTitle");
            return this;
        }

        public Builder captchaHeader(String captchaHeader) {
            this.captchaHeader = captchaHeader;
            this.__explicitlySet__.add("captchaHeader");
            return this;
        }

        public Builder captchaFooter(String captchaFooter) {
            this.captchaFooter = captchaFooter;
            this.__explicitlySet__.add("captchaFooter");
            return this;
        }

        public Builder captchaSubmitLabel(String captchaSubmitLabel) {
            this.captchaSubmitLabel = captchaSubmitLabel;
            this.__explicitlySet__.add("captchaSubmitLabel");
            return this;
        }

        public BlockChallengeSettings build() {
            BlockChallengeSettings model = new BlockChallengeSettings(this.blockAction, this.blockResponseCode, this.blockErrorPageMessage, this.blockErrorPageDescription, this.blockErrorPageCode, this.captchaTitle, this.captchaHeader, this.captchaFooter, this.captchaSubmitLabel);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BlockChallengeSettings model) {
            if (model.wasPropertyExplicitlySet("blockAction")) {
                this.blockAction(model.getBlockAction());
            }
            if (model.wasPropertyExplicitlySet("blockResponseCode")) {
                this.blockResponseCode(model.getBlockResponseCode());
            }
            if (model.wasPropertyExplicitlySet("blockErrorPageMessage")) {
                this.blockErrorPageMessage(model.getBlockErrorPageMessage());
            }
            if (model.wasPropertyExplicitlySet("blockErrorPageDescription")) {
                this.blockErrorPageDescription(model.getBlockErrorPageDescription());
            }
            if (model.wasPropertyExplicitlySet("blockErrorPageCode")) {
                this.blockErrorPageCode(model.getBlockErrorPageCode());
            }
            if (model.wasPropertyExplicitlySet("captchaTitle")) {
                this.captchaTitle(model.getCaptchaTitle());
            }
            if (model.wasPropertyExplicitlySet("captchaHeader")) {
                this.captchaHeader(model.getCaptchaHeader());
            }
            if (model.wasPropertyExplicitlySet("captchaFooter")) {
                this.captchaFooter(model.getCaptchaFooter());
            }
            if (model.wasPropertyExplicitlySet("captchaSubmitLabel")) {
                this.captchaSubmitLabel(model.getCaptchaSubmitLabel());
            }
            return this;
        }
    }
}

