/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AccessRuleCriteria
extends ExplicitlySetBmcModel {
    @JsonProperty(value="condition")
    private final Condition condition;
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="isCaseSensitive")
    private final Boolean isCaseSensitive;

    @Deprecated
    @ConstructorProperties(value={"condition", "value", "isCaseSensitive"})
    public AccessRuleCriteria(Condition condition, String value, Boolean isCaseSensitive) {
        this.condition = condition;
        this.value = value;
        this.isCaseSensitive = isCaseSensitive;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Condition getCondition() {
        return this.condition;
    }

    public String getValue() {
        return this.value;
    }

    public Boolean getIsCaseSensitive() {
        return this.isCaseSensitive;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AccessRuleCriteria(");
        sb.append("super=").append(super.toString());
        sb.append("condition=").append(String.valueOf((Object)this.condition));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", isCaseSensitive=").append(String.valueOf(this.isCaseSensitive));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessRuleCriteria)) {
            return false;
        }
        AccessRuleCriteria other = (AccessRuleCriteria)((Object)o);
        return Objects.equals((Object)this.condition, (Object)other.condition) && Objects.equals(this.value, other.value) && Objects.equals(this.isCaseSensitive, other.isCaseSensitive) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.condition == null ? 43 : this.condition.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.isCaseSensitive == null ? 43 : this.isCaseSensitive.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Condition implements BmcEnum
    {
        UrlIs("URL_IS"),
        UrlIsNot("URL_IS_NOT"),
        UrlStartsWith("URL_STARTS_WITH"),
        UrlPartEndsWith("URL_PART_ENDS_WITH"),
        UrlPartContains("URL_PART_CONTAINS"),
        UrlRegex("URL_REGEX"),
        UrlDoesNotMatchRegex("URL_DOES_NOT_MATCH_REGEX"),
        UrlDoesNotStartWith("URL_DOES_NOT_START_WITH"),
        UrlPartDoesNotContain("URL_PART_DOES_NOT_CONTAIN"),
        UrlPartDoesNotEndWith("URL_PART_DOES_NOT_END_WITH"),
        IpIs("IP_IS"),
        IpIsNot("IP_IS_NOT"),
        IpInList("IP_IN_LIST"),
        IpNotInList("IP_NOT_IN_LIST"),
        HttpHeaderContains("HTTP_HEADER_CONTAINS"),
        HttpMethodIs("HTTP_METHOD_IS"),
        HttpMethodIsNot("HTTP_METHOD_IS_NOT"),
        CountryIs("COUNTRY_IS"),
        CountryIsNot("COUNTRY_IS_NOT"),
        UserAgentIs("USER_AGENT_IS"),
        UserAgentIsNot("USER_AGENT_IS_NOT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Condition> map;

        private Condition(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Condition create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Condition', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Condition.class);
            map = new HashMap<String, Condition>();
            for (Condition v : Condition.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="condition")
        private Condition condition;
        @JsonProperty(value="value")
        private String value;
        @JsonProperty(value="isCaseSensitive")
        private Boolean isCaseSensitive;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder condition(Condition condition) {
            this.condition = condition;
            this.__explicitlySet__.add("condition");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder isCaseSensitive(Boolean isCaseSensitive) {
            this.isCaseSensitive = isCaseSensitive;
            this.__explicitlySet__.add("isCaseSensitive");
            return this;
        }

        public AccessRuleCriteria build() {
            AccessRuleCriteria model = new AccessRuleCriteria(this.condition, this.value, this.isCaseSensitive);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AccessRuleCriteria model) {
            if (model.wasPropertyExplicitlySet("condition")) {
                this.condition(model.getCondition());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("isCaseSensitive")) {
                this.isCaseSensitive(model.getIsCaseSensitive());
            }
            return this;
        }
    }
}

