/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waas.Waas;
import com.oracle.bmc.waas.WaasAsyncClient;
import com.oracle.bmc.waas.WaasPaginators;
import com.oracle.bmc.waas.WaasWaiters;
import com.oracle.bmc.waas.model.AccessRule;
import com.oracle.bmc.waas.model.AddressList;
import com.oracle.bmc.waas.model.AddressListSummary;
import com.oracle.bmc.waas.model.AddressRateLimiting;
import com.oracle.bmc.waas.model.CachingRuleSummary;
import com.oracle.bmc.waas.model.Captcha;
import com.oracle.bmc.waas.model.Certificate;
import com.oracle.bmc.waas.model.CertificateSummary;
import com.oracle.bmc.waas.model.CustomProtectionRule;
import com.oracle.bmc.waas.model.CustomProtectionRuleSummary;
import com.oracle.bmc.waas.model.DeviceFingerprintChallenge;
import com.oracle.bmc.waas.model.EdgeSubnet;
import com.oracle.bmc.waas.model.GoodBot;
import com.oracle.bmc.waas.model.HumanInteractionChallenge;
import com.oracle.bmc.waas.model.JsChallenge;
import com.oracle.bmc.waas.model.PolicyConfig;
import com.oracle.bmc.waas.model.ProtectionRule;
import com.oracle.bmc.waas.model.ProtectionSettings;
import com.oracle.bmc.waas.model.Recommendation;
import com.oracle.bmc.waas.model.ThreatFeed;
import com.oracle.bmc.waas.model.WaasPolicy;
import com.oracle.bmc.waas.model.WaasPolicyCustomProtectionRuleSummary;
import com.oracle.bmc.waas.model.WaasPolicySummary;
import com.oracle.bmc.waas.model.WafBlockedRequest;
import com.oracle.bmc.waas.model.WafConfig;
import com.oracle.bmc.waas.model.WafLog;
import com.oracle.bmc.waas.model.WafRequest;
import com.oracle.bmc.waas.model.WafTrafficDatum;
import com.oracle.bmc.waas.model.Whitelist;
import com.oracle.bmc.waas.model.WorkRequest;
import com.oracle.bmc.waas.model.WorkRequestSummary;
import com.oracle.bmc.waas.requests.AcceptRecommendationsRequest;
import com.oracle.bmc.waas.requests.CancelWorkRequestRequest;
import com.oracle.bmc.waas.requests.ChangeAddressListCompartmentRequest;
import com.oracle.bmc.waas.requests.ChangeCertificateCompartmentRequest;
import com.oracle.bmc.waas.requests.ChangeCustomProtectionRuleCompartmentRequest;
import com.oracle.bmc.waas.requests.ChangeWaasPolicyCompartmentRequest;
import com.oracle.bmc.waas.requests.CreateAddressListRequest;
import com.oracle.bmc.waas.requests.CreateCertificateRequest;
import com.oracle.bmc.waas.requests.CreateCustomProtectionRuleRequest;
import com.oracle.bmc.waas.requests.CreateWaasPolicyRequest;
import com.oracle.bmc.waas.requests.DeleteAddressListRequest;
import com.oracle.bmc.waas.requests.DeleteCertificateRequest;
import com.oracle.bmc.waas.requests.DeleteCustomProtectionRuleRequest;
import com.oracle.bmc.waas.requests.DeleteWaasPolicyRequest;
import com.oracle.bmc.waas.requests.GetAddressListRequest;
import com.oracle.bmc.waas.requests.GetCertificateRequest;
import com.oracle.bmc.waas.requests.GetCustomProtectionRuleRequest;
import com.oracle.bmc.waas.requests.GetDeviceFingerprintChallengeRequest;
import com.oracle.bmc.waas.requests.GetHumanInteractionChallengeRequest;
import com.oracle.bmc.waas.requests.GetJsChallengeRequest;
import com.oracle.bmc.waas.requests.GetPolicyConfigRequest;
import com.oracle.bmc.waas.requests.GetProtectionRuleRequest;
import com.oracle.bmc.waas.requests.GetProtectionSettingsRequest;
import com.oracle.bmc.waas.requests.GetWaasPolicyRequest;
import com.oracle.bmc.waas.requests.GetWafAddressRateLimitingRequest;
import com.oracle.bmc.waas.requests.GetWafConfigRequest;
import com.oracle.bmc.waas.requests.GetWorkRequestRequest;
import com.oracle.bmc.waas.requests.ListAccessRulesRequest;
import com.oracle.bmc.waas.requests.ListAddressListsRequest;
import com.oracle.bmc.waas.requests.ListCachingRulesRequest;
import com.oracle.bmc.waas.requests.ListCaptchasRequest;
import com.oracle.bmc.waas.requests.ListCertificatesRequest;
import com.oracle.bmc.waas.requests.ListCustomProtectionRulesRequest;
import com.oracle.bmc.waas.requests.ListEdgeSubnetsRequest;
import com.oracle.bmc.waas.requests.ListGoodBotsRequest;
import com.oracle.bmc.waas.requests.ListProtectionRulesRequest;
import com.oracle.bmc.waas.requests.ListRecommendationsRequest;
import com.oracle.bmc.waas.requests.ListThreatFeedsRequest;
import com.oracle.bmc.waas.requests.ListWaasPoliciesRequest;
import com.oracle.bmc.waas.requests.ListWaasPolicyCustomProtectionRulesRequest;
import com.oracle.bmc.waas.requests.ListWafBlockedRequestsRequest;
import com.oracle.bmc.waas.requests.ListWafLogsRequest;
import com.oracle.bmc.waas.requests.ListWafRequestsRequest;
import com.oracle.bmc.waas.requests.ListWafTrafficRequest;
import com.oracle.bmc.waas.requests.ListWhitelistsRequest;
import com.oracle.bmc.waas.requests.ListWorkRequestsRequest;
import com.oracle.bmc.waas.requests.PurgeCacheRequest;
import com.oracle.bmc.waas.requests.UpdateAccessRulesRequest;
import com.oracle.bmc.waas.requests.UpdateAddressListRequest;
import com.oracle.bmc.waas.requests.UpdateCachingRulesRequest;
import com.oracle.bmc.waas.requests.UpdateCaptchasRequest;
import com.oracle.bmc.waas.requests.UpdateCertificateRequest;
import com.oracle.bmc.waas.requests.UpdateCustomProtectionRuleRequest;
import com.oracle.bmc.waas.requests.UpdateDeviceFingerprintChallengeRequest;
import com.oracle.bmc.waas.requests.UpdateGoodBotsRequest;
import com.oracle.bmc.waas.requests.UpdateHumanInteractionChallengeRequest;
import com.oracle.bmc.waas.requests.UpdateJsChallengeRequest;
import com.oracle.bmc.waas.requests.UpdatePolicyConfigRequest;
import com.oracle.bmc.waas.requests.UpdateProtectionRulesRequest;
import com.oracle.bmc.waas.requests.UpdateProtectionSettingsRequest;
import com.oracle.bmc.waas.requests.UpdateThreatFeedsRequest;
import com.oracle.bmc.waas.requests.UpdateWaasPolicyCustomProtectionRulesRequest;
import com.oracle.bmc.waas.requests.UpdateWaasPolicyRequest;
import com.oracle.bmc.waas.requests.UpdateWafAddressRateLimitingRequest;
import com.oracle.bmc.waas.requests.UpdateWafConfigRequest;
import com.oracle.bmc.waas.requests.UpdateWhitelistsRequest;
import com.oracle.bmc.waas.responses.AcceptRecommendationsResponse;
import com.oracle.bmc.waas.responses.CancelWorkRequestResponse;
import com.oracle.bmc.waas.responses.ChangeAddressListCompartmentResponse;
import com.oracle.bmc.waas.responses.ChangeCertificateCompartmentResponse;
import com.oracle.bmc.waas.responses.ChangeCustomProtectionRuleCompartmentResponse;
import com.oracle.bmc.waas.responses.ChangeWaasPolicyCompartmentResponse;
import com.oracle.bmc.waas.responses.CreateAddressListResponse;
import com.oracle.bmc.waas.responses.CreateCertificateResponse;
import com.oracle.bmc.waas.responses.CreateCustomProtectionRuleResponse;
import com.oracle.bmc.waas.responses.CreateWaasPolicyResponse;
import com.oracle.bmc.waas.responses.DeleteAddressListResponse;
import com.oracle.bmc.waas.responses.DeleteCertificateResponse;
import com.oracle.bmc.waas.responses.DeleteCustomProtectionRuleResponse;
import com.oracle.bmc.waas.responses.DeleteWaasPolicyResponse;
import com.oracle.bmc.waas.responses.GetAddressListResponse;
import com.oracle.bmc.waas.responses.GetCertificateResponse;
import com.oracle.bmc.waas.responses.GetCustomProtectionRuleResponse;
import com.oracle.bmc.waas.responses.GetDeviceFingerprintChallengeResponse;
import com.oracle.bmc.waas.responses.GetHumanInteractionChallengeResponse;
import com.oracle.bmc.waas.responses.GetJsChallengeResponse;
import com.oracle.bmc.waas.responses.GetPolicyConfigResponse;
import com.oracle.bmc.waas.responses.GetProtectionRuleResponse;
import com.oracle.bmc.waas.responses.GetProtectionSettingsResponse;
import com.oracle.bmc.waas.responses.GetWaasPolicyResponse;
import com.oracle.bmc.waas.responses.GetWafAddressRateLimitingResponse;
import com.oracle.bmc.waas.responses.GetWafConfigResponse;
import com.oracle.bmc.waas.responses.GetWorkRequestResponse;
import com.oracle.bmc.waas.responses.ListAccessRulesResponse;
import com.oracle.bmc.waas.responses.ListAddressListsResponse;
import com.oracle.bmc.waas.responses.ListCachingRulesResponse;
import com.oracle.bmc.waas.responses.ListCaptchasResponse;
import com.oracle.bmc.waas.responses.ListCertificatesResponse;
import com.oracle.bmc.waas.responses.ListCustomProtectionRulesResponse;
import com.oracle.bmc.waas.responses.ListEdgeSubnetsResponse;
import com.oracle.bmc.waas.responses.ListGoodBotsResponse;
import com.oracle.bmc.waas.responses.ListProtectionRulesResponse;
import com.oracle.bmc.waas.responses.ListRecommendationsResponse;
import com.oracle.bmc.waas.responses.ListThreatFeedsResponse;
import com.oracle.bmc.waas.responses.ListWaasPoliciesResponse;
import com.oracle.bmc.waas.responses.ListWaasPolicyCustomProtectionRulesResponse;
import com.oracle.bmc.waas.responses.ListWafBlockedRequestsResponse;
import com.oracle.bmc.waas.responses.ListWafLogsResponse;
import com.oracle.bmc.waas.responses.ListWafRequestsResponse;
import com.oracle.bmc.waas.responses.ListWafTrafficResponse;
import com.oracle.bmc.waas.responses.ListWhitelistsResponse;
import com.oracle.bmc.waas.responses.ListWorkRequestsResponse;
import com.oracle.bmc.waas.responses.PurgeCacheResponse;
import com.oracle.bmc.waas.responses.UpdateAccessRulesResponse;
import com.oracle.bmc.waas.responses.UpdateAddressListResponse;
import com.oracle.bmc.waas.responses.UpdateCachingRulesResponse;
import com.oracle.bmc.waas.responses.UpdateCaptchasResponse;
import com.oracle.bmc.waas.responses.UpdateCertificateResponse;
import com.oracle.bmc.waas.responses.UpdateCustomProtectionRuleResponse;
import com.oracle.bmc.waas.responses.UpdateDeviceFingerprintChallengeResponse;
import com.oracle.bmc.waas.responses.UpdateGoodBotsResponse;
import com.oracle.bmc.waas.responses.UpdateHumanInteractionChallengeResponse;
import com.oracle.bmc.waas.responses.UpdateJsChallengeResponse;
import com.oracle.bmc.waas.responses.UpdatePolicyConfigResponse;
import com.oracle.bmc.waas.responses.UpdateProtectionRulesResponse;
import com.oracle.bmc.waas.responses.UpdateProtectionSettingsResponse;
import com.oracle.bmc.waas.responses.UpdateThreatFeedsResponse;
import com.oracle.bmc.waas.responses.UpdateWaasPolicyCustomProtectionRulesResponse;
import com.oracle.bmc.waas.responses.UpdateWaasPolicyResponse;
import com.oracle.bmc.waas.responses.UpdateWafAddressRateLimitingResponse;
import com.oracle.bmc.waas.responses.UpdateWafConfigResponse;
import com.oracle.bmc.waas.responses.UpdateWhitelistsResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaasClient
extends BaseSyncClient
implements Waas {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("WAAS").serviceEndpointPrefix("waas").serviceEndpointTemplate("https://waas.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(WaasAsyncClient.class);
    private final WaasWaiters waiters;
    private final WaasPaginators paginators;

    private WaasClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Waas-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new WaasWaiters(executorService, this);
        this.paginators = new WaasPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AcceptRecommendationsResponse acceptRecommendations(AcceptRecommendationsRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getProtectionRuleKeys(), "protectionRuleKeys is required");
        return (AcceptRecommendationsResponse)this.clientCall(request, AcceptRecommendationsResponse::builder).logger(LOG, "acceptRecommendations").serviceDetails("Waas", "AcceptRecommendations", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/Recommendation/AcceptRecommendations").method(Method.POST).requestBuilder(AcceptRecommendationsRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("actions").appendPathParam("acceptWafConfigRecommendations").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", AcceptRecommendationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", AcceptRecommendationsResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("Waas", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20181116").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeAddressListCompartmentResponse changeAddressListCompartment(ChangeAddressListCompartmentRequest request) {
        Validate.notBlank((String)request.getAddressListId(), (String)"addressListId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAddressListCompartmentDetails(), "changeAddressListCompartmentDetails is required");
        return (ChangeAddressListCompartmentResponse)this.clientCall(request, ChangeAddressListCompartmentResponse::builder).logger(LOG, "changeAddressListCompartment").serviceDetails("Waas", "ChangeAddressListCompartment", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/AddressList/ChangeAddressListCompartment").method(Method.POST).requestBuilder(ChangeAddressListCompartmentRequest::builder).basePath("/20181116").appendPathParam("addressLists").appendPathParam(request.getAddressListId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeAddressListCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeCertificateCompartmentResponse changeCertificateCompartment(ChangeCertificateCompartmentRequest request) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeCertificateCompartmentDetails(), "changeCertificateCompartmentDetails is required");
        return (ChangeCertificateCompartmentResponse)this.clientCall(request, ChangeCertificateCompartmentResponse::builder).logger(LOG, "changeCertificateCompartment").serviceDetails("Waas", "ChangeCertificateCompartment", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/Certificate/ChangeCertificateCompartment").method(Method.POST).requestBuilder(ChangeCertificateCompartmentRequest::builder).basePath("/20181116").appendPathParam("certificates").appendPathParam(request.getCertificateId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeCertificateCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeCustomProtectionRuleCompartmentResponse changeCustomProtectionRuleCompartment(ChangeCustomProtectionRuleCompartmentRequest request) {
        Validate.notBlank((String)request.getCustomProtectionRuleId(), (String)"customProtectionRuleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeCustomProtectionRuleCompartmentDetails(), "changeCustomProtectionRuleCompartmentDetails is required");
        return (ChangeCustomProtectionRuleCompartmentResponse)this.clientCall(request, ChangeCustomProtectionRuleCompartmentResponse::builder).logger(LOG, "changeCustomProtectionRuleCompartment").serviceDetails("Waas", "ChangeCustomProtectionRuleCompartment", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/CustomProtectionRule/ChangeCustomProtectionRuleCompartment").method(Method.POST).requestBuilder(ChangeCustomProtectionRuleCompartmentRequest::builder).basePath("/20181116").appendPathParam("customProtectionRules").appendPathParam(request.getCustomProtectionRuleId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeCustomProtectionRuleCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeWaasPolicyCompartmentResponse changeWaasPolicyCompartment(ChangeWaasPolicyCompartmentRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeWaasPolicyCompartmentDetails(), "changeWaasPolicyCompartmentDetails is required");
        return (ChangeWaasPolicyCompartmentResponse)this.clientCall(request, ChangeWaasPolicyCompartmentResponse::builder).logger(LOG, "changeWaasPolicyCompartment").serviceDetails("Waas", "ChangeWaasPolicyCompartment", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/WaasPolicy/ChangeWaasPolicyCompartment").method(Method.POST).requestBuilder(ChangeWaasPolicyCompartmentRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeWaasPolicyCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateAddressListResponse createAddressList(CreateAddressListRequest request) {
        Objects.requireNonNull(request.getCreateAddressListDetails(), "createAddressListDetails is required");
        return (CreateAddressListResponse)this.clientCall(request, CreateAddressListResponse::builder).logger(LOG, "createAddressList").serviceDetails("Waas", "CreateAddressList", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/AddressList/CreateAddressList").method(Method.POST).requestBuilder(CreateAddressListRequest::builder).basePath("/20181116").appendPathParam("addressLists").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(AddressList.class, CreateAddressListResponse.Builder::addressList).handleResponseHeaderString("opc-request-id", CreateAddressListResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateAddressListResponse.Builder::etag).callSync();
    }

    @Override
    public CreateCertificateResponse createCertificate(CreateCertificateRequest request) {
        Objects.requireNonNull(request.getCreateCertificateDetails(), "createCertificateDetails is required");
        return (CreateCertificateResponse)this.clientCall(request, CreateCertificateResponse::builder).logger(LOG, "createCertificate").serviceDetails("Waas", "CreateCertificate", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/Certificate/CreateCertificate").method(Method.POST).requestBuilder(CreateCertificateRequest::builder).basePath("/20181116").appendPathParam("certificates").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Certificate.class, CreateCertificateResponse.Builder::certificate).handleResponseHeaderString("opc-request-id", CreateCertificateResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateCertificateResponse.Builder::etag).callSync();
    }

    @Override
    public CreateCustomProtectionRuleResponse createCustomProtectionRule(CreateCustomProtectionRuleRequest request) {
        Objects.requireNonNull(request.getCreateCustomProtectionRuleDetails(), "createCustomProtectionRuleDetails is required");
        return (CreateCustomProtectionRuleResponse)this.clientCall(request, CreateCustomProtectionRuleResponse::builder).logger(LOG, "createCustomProtectionRule").serviceDetails("Waas", "CreateCustomProtectionRule", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/CustomProtectionRule/CreateCustomProtectionRule").method(Method.POST).requestBuilder(CreateCustomProtectionRuleRequest::builder).basePath("/20181116").appendPathParam("customProtectionRules").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(CustomProtectionRule.class, CreateCustomProtectionRuleResponse.Builder::customProtectionRule).handleResponseHeaderString("opc-request-id", CreateCustomProtectionRuleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateCustomProtectionRuleResponse.Builder::etag).callSync();
    }

    @Override
    public CreateWaasPolicyResponse createWaasPolicy(CreateWaasPolicyRequest request) {
        Objects.requireNonNull(request.getCreateWaasPolicyDetails(), "createWaasPolicyDetails is required");
        return (CreateWaasPolicyResponse)this.clientCall(request, CreateWaasPolicyResponse::builder).logger(LOG, "createWaasPolicy").serviceDetails("Waas", "CreateWaasPolicy", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/WaasPolicy/CreateWaasPolicy").method(Method.POST).requestBuilder(CreateWaasPolicyRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", CreateWaasPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateWaasPolicyResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateWaasPolicyResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteAddressListResponse deleteAddressList(DeleteAddressListRequest request) {
        Validate.notBlank((String)request.getAddressListId(), (String)"addressListId must not be blank", (Object[])new Object[0]);
        return (DeleteAddressListResponse)this.clientCall(request, DeleteAddressListResponse::builder).logger(LOG, "deleteAddressList").serviceDetails("Waas", "DeleteAddressList", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/AddressList/DeleteAddressList").method(Method.DELETE).requestBuilder(DeleteAddressListRequest::builder).basePath("/20181116").appendPathParam("addressLists").appendPathParam(request.getAddressListId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteAddressListResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteCertificateResponse deleteCertificate(DeleteCertificateRequest request) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        return (DeleteCertificateResponse)this.clientCall(request, DeleteCertificateResponse::builder).logger(LOG, "deleteCertificate").serviceDetails("Waas", "DeleteCertificate", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/Certificate/DeleteCertificate").method(Method.DELETE).requestBuilder(DeleteCertificateRequest::builder).basePath("/20181116").appendPathParam("certificates").appendPathParam(request.getCertificateId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteCertificateResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteCustomProtectionRuleResponse deleteCustomProtectionRule(DeleteCustomProtectionRuleRequest request) {
        Validate.notBlank((String)request.getCustomProtectionRuleId(), (String)"customProtectionRuleId must not be blank", (Object[])new Object[0]);
        return (DeleteCustomProtectionRuleResponse)this.clientCall(request, DeleteCustomProtectionRuleResponse::builder).logger(LOG, "deleteCustomProtectionRule").serviceDetails("Waas", "DeleteCustomProtectionRule", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/CustomProtectionRule/DeleteCustomProtectionRule").method(Method.DELETE).requestBuilder(DeleteCustomProtectionRuleRequest::builder).basePath("/20181116").appendPathParam("customProtectionRules").appendPathParam(request.getCustomProtectionRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteCustomProtectionRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteWaasPolicyResponse deleteWaasPolicy(DeleteWaasPolicyRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (DeleteWaasPolicyResponse)this.clientCall(request, DeleteWaasPolicyResponse::builder).logger(LOG, "deleteWaasPolicy").serviceDetails("Waas", "DeleteWaasPolicy", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/WaasPolicy/DeleteWaasPolicy").method(Method.DELETE).requestBuilder(DeleteWaasPolicyRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteWaasPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteWaasPolicyResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GetAddressListResponse getAddressList(GetAddressListRequest request) {
        Validate.notBlank((String)request.getAddressListId(), (String)"addressListId must not be blank", (Object[])new Object[0]);
        return (GetAddressListResponse)this.clientCall(request, GetAddressListResponse::builder).logger(LOG, "getAddressList").serviceDetails("Waas", "GetAddressList", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/AddressList/GetAddressList").method(Method.GET).requestBuilder(GetAddressListRequest::builder).basePath("/20181116").appendPathParam("addressLists").appendPathParam(request.getAddressListId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AddressList.class, GetAddressListResponse.Builder::addressList).handleResponseHeaderString("etag", GetAddressListResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAddressListResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetCertificateResponse getCertificate(GetCertificateRequest request) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        return (GetCertificateResponse)this.clientCall(request, GetCertificateResponse::builder).logger(LOG, "getCertificate").serviceDetails("Waas", "GetCertificate", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/Certificate/GetCertificate").method(Method.GET).requestBuilder(GetCertificateRequest::builder).basePath("/20181116").appendPathParam("certificates").appendPathParam(request.getCertificateId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Certificate.class, GetCertificateResponse.Builder::certificate).handleResponseHeaderString("etag", GetCertificateResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCertificateResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetCustomProtectionRuleResponse getCustomProtectionRule(GetCustomProtectionRuleRequest request) {
        Validate.notBlank((String)request.getCustomProtectionRuleId(), (String)"customProtectionRuleId must not be blank", (Object[])new Object[0]);
        return (GetCustomProtectionRuleResponse)this.clientCall(request, GetCustomProtectionRuleResponse::builder).logger(LOG, "getCustomProtectionRule").serviceDetails("Waas", "GetCustomProtectionRule", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/CustomProtectionRule/GetCustomProtectionRule").method(Method.GET).requestBuilder(GetCustomProtectionRuleRequest::builder).basePath("/20181116").appendPathParam("customProtectionRules").appendPathParam(request.getCustomProtectionRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CustomProtectionRule.class, GetCustomProtectionRuleResponse.Builder::customProtectionRule).handleResponseHeaderString("etag", GetCustomProtectionRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCustomProtectionRuleResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetDeviceFingerprintChallengeResponse getDeviceFingerprintChallenge(GetDeviceFingerprintChallengeRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (GetDeviceFingerprintChallengeResponse)this.clientCall(request, GetDeviceFingerprintChallengeResponse::builder).logger(LOG, "getDeviceFingerprintChallenge").serviceDetails("Waas", "GetDeviceFingerprintChallenge", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/DeviceFingerprintChallenge/GetDeviceFingerprintChallenge").method(Method.GET).requestBuilder(GetDeviceFingerprintChallengeRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("deviceFingerprintChallenge").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeviceFingerprintChallenge.class, GetDeviceFingerprintChallengeResponse.Builder::deviceFingerprintChallenge).handleResponseHeaderString("etag", GetDeviceFingerprintChallengeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDeviceFingerprintChallengeResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetHumanInteractionChallengeResponse getHumanInteractionChallenge(GetHumanInteractionChallengeRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (GetHumanInteractionChallengeResponse)this.clientCall(request, GetHumanInteractionChallengeResponse::builder).logger(LOG, "getHumanInteractionChallenge").serviceDetails("Waas", "GetHumanInteractionChallenge", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/HumanInteractionChallenge/GetHumanInteractionChallenge").method(Method.GET).requestBuilder(GetHumanInteractionChallengeRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("humanInteractionChallenge").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HumanInteractionChallenge.class, GetHumanInteractionChallengeResponse.Builder::humanInteractionChallenge).handleResponseHeaderString("etag", GetHumanInteractionChallengeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetHumanInteractionChallengeResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetJsChallengeResponse getJsChallenge(GetJsChallengeRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (GetJsChallengeResponse)this.clientCall(request, GetJsChallengeResponse::builder).logger(LOG, "getJsChallenge").serviceDetails("Waas", "GetJsChallenge", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/JsChallenge/GetJsChallenge").method(Method.GET).requestBuilder(GetJsChallengeRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("jsChallenge").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JsChallenge.class, GetJsChallengeResponse.Builder::jsChallenge).handleResponseHeaderString("etag", GetJsChallengeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetJsChallengeResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetPolicyConfigResponse getPolicyConfig(GetPolicyConfigRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (GetPolicyConfigResponse)this.clientCall(request, GetPolicyConfigResponse::builder).logger(LOG, "getPolicyConfig").serviceDetails("Waas", "GetPolicyConfig", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/PolicyConfig/GetPolicyConfig").method(Method.GET).requestBuilder(GetPolicyConfigRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("policyConfig").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PolicyConfig.class, GetPolicyConfigResponse.Builder::policyConfig).handleResponseHeaderString("etag", GetPolicyConfigResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPolicyConfigResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetProtectionRuleResponse getProtectionRule(GetProtectionRuleRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getProtectionRuleKey(), (String)"protectionRuleKey must not be blank", (Object[])new Object[0]);
        return (GetProtectionRuleResponse)this.clientCall(request, GetProtectionRuleResponse::builder).logger(LOG, "getProtectionRule").serviceDetails("Waas", "GetProtectionRule", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/ProtectionRule/GetProtectionRule").method(Method.GET).requestBuilder(GetProtectionRuleRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("protectionRules").appendPathParam(request.getProtectionRuleKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProtectionRule.class, GetProtectionRuleResponse.Builder::protectionRule).handleResponseHeaderString("etag", GetProtectionRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProtectionRuleResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetProtectionSettingsResponse getProtectionSettings(GetProtectionSettingsRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (GetProtectionSettingsResponse)this.clientCall(request, GetProtectionSettingsResponse::builder).logger(LOG, "getProtectionSettings").serviceDetails("Waas", "GetProtectionSettings", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/ProtectionSettings/GetProtectionSettings").method(Method.GET).requestBuilder(GetProtectionSettingsRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("protectionSettings").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProtectionSettings.class, GetProtectionSettingsResponse.Builder::protectionSettings).handleResponseHeaderString("etag", GetProtectionSettingsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProtectionSettingsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetWaasPolicyResponse getWaasPolicy(GetWaasPolicyRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (GetWaasPolicyResponse)this.clientCall(request, GetWaasPolicyResponse::builder).logger(LOG, "getWaasPolicy").serviceDetails("Waas", "GetWaasPolicy", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/WaasPolicy/GetWaasPolicy").method(Method.GET).requestBuilder(GetWaasPolicyRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WaasPolicy.class, GetWaasPolicyResponse.Builder::waasPolicy).handleResponseHeaderString("etag", GetWaasPolicyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWaasPolicyResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetWafAddressRateLimitingResponse getWafAddressRateLimiting(GetWafAddressRateLimitingRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (GetWafAddressRateLimitingResponse)this.clientCall(request, GetWafAddressRateLimitingResponse::builder).logger(LOG, "getWafAddressRateLimiting").serviceDetails("Waas", "GetWafAddressRateLimiting", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/AddressRateLimiting/GetWafAddressRateLimiting").method(Method.GET).requestBuilder(GetWafAddressRateLimitingRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("addressRateLimiting").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AddressRateLimiting.class, GetWafAddressRateLimitingResponse.Builder::addressRateLimiting).handleResponseHeaderString("etag", GetWafAddressRateLimitingResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWafAddressRateLimitingResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetWafConfigResponse getWafConfig(GetWafConfigRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (GetWafConfigResponse)this.clientCall(request, GetWafConfigResponse::builder).logger(LOG, "getWafConfig").serviceDetails("Waas", "GetWafConfig", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/WafConfig/GetWafConfig").method(Method.GET).requestBuilder(GetWafConfigRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WafConfig.class, GetWafConfigResponse.Builder::wafConfig).handleResponseHeaderString("etag", GetWafConfigResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWafConfigResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("Waas", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20181116").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderFloat("Retry-After", GetWorkRequestResponse.Builder::retryAfter).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListAccessRulesResponse listAccessRules(ListAccessRulesRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (ListAccessRulesResponse)this.clientCall(request, ListAccessRulesResponse::builder).logger(LOG, "listAccessRules").serviceDetails("Waas", "ListAccessRules", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/AccessRule/ListAccessRules").method(Method.GET).requestBuilder(ListAccessRulesRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("accessRules").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AccessRule.class, ListAccessRulesResponse.Builder::items).handleResponseHeaderString("etag", ListAccessRulesResponse.Builder::etag).handleResponseHeaderString("opc-next-page", ListAccessRulesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAccessRulesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListAddressListsResponse listAddressLists(ListAddressListsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListAddressListsResponse)this.clientCall(request, ListAddressListsResponse::builder).logger(LOG, "listAddressLists").serviceDetails("Waas", "ListAddressLists", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/AddressList/ListAddressLists").method(Method.GET).requestBuilder(ListAddressListsRequest::builder).basePath("/20181116").appendPathParam("addressLists").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("id", request.getId(), CollectionFormatType.Multi).appendListQueryParam("name", request.getName(), CollectionFormatType.Multi).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).appendQueryParam("timeCreatedGreaterThanOrEqualTo", (Object)request.getTimeCreatedGreaterThanOrEqualTo()).appendQueryParam("timeCreatedLessThan", (Object)request.getTimeCreatedLessThan()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AddressListSummary.class, ListAddressListsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListAddressListsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAddressListsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListCachingRulesResponse listCachingRules(ListCachingRulesRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (ListCachingRulesResponse)this.clientCall(request, ListCachingRulesResponse::builder).logger(LOG, "listCachingRules").serviceDetails("Waas", "ListCachingRules", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/CachingRuleSummary/ListCachingRules").method(Method.GET).requestBuilder(ListCachingRulesRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("cachingRules").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(CachingRuleSummary.class, ListCachingRulesResponse.Builder::items).handleResponseHeaderString("etag", ListCachingRulesResponse.Builder::etag).handleResponseHeaderString("opc-next-page", ListCachingRulesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListCachingRulesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListCaptchasResponse listCaptchas(ListCaptchasRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (ListCaptchasResponse)this.clientCall(request, ListCaptchasResponse::builder).logger(LOG, "listCaptchas").serviceDetails("Waas", "ListCaptchas", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/Captcha/ListCaptchas").method(Method.GET).requestBuilder(ListCaptchasRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("captchas").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(Captcha.class, ListCaptchasResponse.Builder::items).handleResponseHeaderString("etag", ListCaptchasResponse.Builder::etag).handleResponseHeaderString("opc-next-page", ListCaptchasResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListCaptchasResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListCertificatesResponse listCertificates(ListCertificatesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListCertificatesResponse)this.clientCall(request, ListCertificatesResponse::builder).logger(LOG, "listCertificates").serviceDetails("Waas", "ListCertificates", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/CertificateSummary/ListCertificates").method(Method.GET).requestBuilder(ListCertificatesRequest::builder).basePath("/20181116").appendPathParam("certificates").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("id", request.getId(), CollectionFormatType.Multi).appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).appendQueryParam("timeCreatedGreaterThanOrEqualTo", (Object)request.getTimeCreatedGreaterThanOrEqualTo()).appendQueryParam("timeCreatedLessThan", (Object)request.getTimeCreatedLessThan()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(CertificateSummary.class, ListCertificatesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListCertificatesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListCertificatesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListCustomProtectionRulesResponse listCustomProtectionRules(ListCustomProtectionRulesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListCustomProtectionRulesResponse)this.clientCall(request, ListCustomProtectionRulesResponse::builder).logger(LOG, "listCustomProtectionRules").serviceDetails("Waas", "ListCustomProtectionRules", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/CustomProtectionRule/ListCustomProtectionRules").method(Method.GET).requestBuilder(ListCustomProtectionRulesRequest::builder).basePath("/20181116").appendPathParam("customProtectionRules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendListQueryParam("id", request.getId(), CollectionFormatType.Multi).appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).appendQueryParam("timeCreatedGreaterThanOrEqualTo", (Object)request.getTimeCreatedGreaterThanOrEqualTo()).appendQueryParam("timeCreatedLessThan", (Object)request.getTimeCreatedLessThan()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(CustomProtectionRuleSummary.class, ListCustomProtectionRulesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListCustomProtectionRulesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListCustomProtectionRulesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListEdgeSubnetsResponse listEdgeSubnets(ListEdgeSubnetsRequest request) {
        return (ListEdgeSubnetsResponse)this.clientCall(request, ListEdgeSubnetsResponse::builder).logger(LOG, "listEdgeSubnets").serviceDetails("Waas", "ListEdgeSubnets", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/EdgeSubnet/ListEdgeSubnets").method(Method.GET).requestBuilder(ListEdgeSubnetsRequest::builder).basePath("/20181116").appendPathParam("edgeSubnets").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(EdgeSubnet.class, ListEdgeSubnetsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListEdgeSubnetsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListEdgeSubnetsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListGoodBotsResponse listGoodBots(ListGoodBotsRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (ListGoodBotsResponse)this.clientCall(request, ListGoodBotsResponse::builder).logger(LOG, "listGoodBots").serviceDetails("Waas", "ListGoodBots", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/GoodBot/ListGoodBots").method(Method.GET).requestBuilder(ListGoodBotsRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("goodBots").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(GoodBot.class, ListGoodBotsResponse.Builder::items).handleResponseHeaderString("etag", ListGoodBotsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ListGoodBotsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListGoodBotsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListProtectionRulesResponse listProtectionRules(ListProtectionRulesRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (ListProtectionRulesResponse)this.clientCall(request, ListProtectionRulesResponse::builder).logger(LOG, "listProtectionRules").serviceDetails("Waas", "ListProtectionRules", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/ProtectionRule/ListProtectionRules").method(Method.GET).requestBuilder(ListProtectionRulesRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("protectionRules").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendListQueryParam("modSecurityRuleId", request.getModSecurityRuleId(), CollectionFormatType.Multi).appendListQueryParam("action", request.getAction(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ProtectionRule.class, ListProtectionRulesResponse.Builder::items).handleResponseHeaderString("etag", ListProtectionRulesResponse.Builder::etag).handleResponseHeaderString("opc-next-page", ListProtectionRulesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListProtectionRulesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListRecommendationsResponse listRecommendations(ListRecommendationsRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (ListRecommendationsResponse)this.clientCall(request, ListRecommendationsResponse::builder).logger(LOG, "listRecommendations").serviceDetails("Waas", "ListRecommendations", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/Recommendation/ListRecommendations").method(Method.GET).requestBuilder(ListRecommendationsRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("recommendations").appendEnumQueryParam("recommendedAction", (BmcEnum)request.getRecommendedAction()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(Recommendation.class, ListRecommendationsResponse.Builder::items).handleResponseHeaderString("etag", ListRecommendationsResponse.Builder::etag).handleResponseHeaderString("opc-next-page", ListRecommendationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListRecommendationsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListThreatFeedsResponse listThreatFeeds(ListThreatFeedsRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (ListThreatFeedsResponse)this.clientCall(request, ListThreatFeedsResponse::builder).logger(LOG, "listThreatFeeds").serviceDetails("Waas", "ListThreatFeeds", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/ThreatFeed/ListThreatFeeds").method(Method.GET).requestBuilder(ListThreatFeedsRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("threatFeeds").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ThreatFeed.class, ListThreatFeedsResponse.Builder::items).handleResponseHeaderString("etag", ListThreatFeedsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ListThreatFeedsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListThreatFeedsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWaasPoliciesResponse listWaasPolicies(ListWaasPoliciesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWaasPoliciesResponse)this.clientCall(request, ListWaasPoliciesResponse::builder).logger(LOG, "listWaasPolicies").serviceDetails("Waas", "ListWaasPolicies", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/WaasPolicy/ListWaasPolicies").method(Method.GET).requestBuilder(ListWaasPoliciesRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendListQueryParam("id", request.getId(), CollectionFormatType.Multi).appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).appendQueryParam("timeCreatedGreaterThanOrEqualTo", (Object)request.getTimeCreatedGreaterThanOrEqualTo()).appendQueryParam("timeCreatedLessThan", (Object)request.getTimeCreatedLessThan()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WaasPolicySummary.class, ListWaasPoliciesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWaasPoliciesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWaasPoliciesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWaasPolicyCustomProtectionRulesResponse listWaasPolicyCustomProtectionRules(ListWaasPolicyCustomProtectionRulesRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (ListWaasPolicyCustomProtectionRulesResponse)this.clientCall(request, ListWaasPolicyCustomProtectionRulesResponse::builder).logger(LOG, "listWaasPolicyCustomProtectionRules").serviceDetails("Waas", "ListWaasPolicyCustomProtectionRules", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/CustomProtectionRule/ListWaasPolicyCustomProtectionRules").method(Method.GET).requestBuilder(ListWaasPolicyCustomProtectionRulesRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("customProtectionRules").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendListQueryParam("modSecurityRuleId", request.getModSecurityRuleId(), CollectionFormatType.Multi).appendListQueryParam("action", request.getAction(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WaasPolicyCustomProtectionRuleSummary.class, ListWaasPolicyCustomProtectionRulesResponse.Builder::items).handleResponseHeaderString("etag", ListWaasPolicyCustomProtectionRulesResponse.Builder::etag).handleResponseHeaderString("opc-next-page", ListWaasPolicyCustomProtectionRulesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWaasPolicyCustomProtectionRulesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWafBlockedRequestsResponse listWafBlockedRequests(ListWafBlockedRequestsRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (ListWafBlockedRequestsResponse)this.clientCall(request, ListWafBlockedRequestsResponse::builder).logger(LOG, "listWafBlockedRequests").serviceDetails("Waas", "ListWafBlockedRequests", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/WafBlockedRequest/ListWafBlockedRequests").method(Method.GET).requestBuilder(ListWafBlockedRequestsRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("reports").appendPathParam("waf").appendPathParam("blocked").appendQueryParam("timeObservedGreaterThanOrEqualTo", (Object)request.getTimeObservedGreaterThanOrEqualTo()).appendQueryParam("timeObservedLessThan", (Object)request.getTimeObservedLessThan()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendListQueryParam("wafFeature", request.getWafFeature(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WafBlockedRequest.class, ListWafBlockedRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWafBlockedRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWafBlockedRequestsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWafLogsResponse listWafLogs(ListWafLogsRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (ListWafLogsResponse)this.clientCall(request, ListWafLogsResponse::builder).logger(LOG, "listWafLogs").serviceDetails("Waas", "ListWafLogs", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/WafLog/ListWafLogs").method(Method.GET).requestBuilder(ListWafLogsRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafLogs").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("timeObservedGreaterThanOrEqualTo", (Object)request.getTimeObservedGreaterThanOrEqualTo()).appendQueryParam("timeObservedLessThan", (Object)request.getTimeObservedLessThan()).appendQueryParam("textContains", (Object)request.getTextContains()).appendListQueryParam("accessRuleKey", request.getAccessRuleKey(), CollectionFormatType.Multi).appendListQueryParam("action", request.getAction(), CollectionFormatType.Multi).appendListQueryParam("clientAddress", request.getClientAddress(), CollectionFormatType.Multi).appendListQueryParam("countryCode", request.getCountryCode(), CollectionFormatType.Multi).appendListQueryParam("countryName", request.getCountryName(), CollectionFormatType.Multi).appendListQueryParam("fingerprint", request.getFingerprint(), CollectionFormatType.Multi).appendListQueryParam("httpMethod", request.getHttpMethod(), CollectionFormatType.Multi).appendListQueryParam("incidentKey", request.getIncidentKey(), CollectionFormatType.Multi).appendListQueryParam("logType", request.getLogType(), CollectionFormatType.Multi).appendListQueryParam("originAddress", request.getOriginAddress(), CollectionFormatType.Multi).appendListQueryParam("referrer", request.getReferrer(), CollectionFormatType.Multi).appendListQueryParam("requestUrl", request.getRequestUrl(), CollectionFormatType.Multi).appendListQueryParam("responseCode", request.getResponseCode(), CollectionFormatType.Multi).appendListQueryParam("threatFeedKey", request.getThreatFeedKey(), CollectionFormatType.Multi).appendListQueryParam("userAgent", request.getUserAgent(), CollectionFormatType.Multi).appendListQueryParam("protectionRuleKey", request.getProtectionRuleKey(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WafLog.class, ListWafLogsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWafLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWafLogsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWafRequestsResponse listWafRequests(ListWafRequestsRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (ListWafRequestsResponse)this.clientCall(request, ListWafRequestsResponse::builder).logger(LOG, "listWafRequests").serviceDetails("Waas", "ListWafRequests", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/WafRequest/ListWafRequests").method(Method.GET).requestBuilder(ListWafRequestsRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("reports").appendPathParam("waf").appendPathParam("requests").appendQueryParam("timeObservedGreaterThanOrEqualTo", (Object)request.getTimeObservedGreaterThanOrEqualTo()).appendQueryParam("timeObservedLessThan", (Object)request.getTimeObservedLessThan()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WafRequest.class, ListWafRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWafRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWafRequestsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWafTrafficResponse listWafTraffic(ListWafTrafficRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (ListWafTrafficResponse)this.clientCall(request, ListWafTrafficResponse::builder).logger(LOG, "listWafTraffic").serviceDetails("Waas", "ListWafTraffic", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/WafTrafficDatum/ListWafTraffic").method(Method.GET).requestBuilder(ListWafTrafficRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("reports").appendPathParam("waf").appendPathParam("traffic").appendQueryParam("timeObservedGreaterThanOrEqualTo", (Object)request.getTimeObservedGreaterThanOrEqualTo()).appendQueryParam("timeObservedLessThan", (Object)request.getTimeObservedLessThan()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WafTrafficDatum.class, ListWafTrafficResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWafTrafficResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWafTrafficResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWhitelistsResponse listWhitelists(ListWhitelistsRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (ListWhitelistsResponse)this.clientCall(request, ListWhitelistsResponse::builder).logger(LOG, "listWhitelists").serviceDetails("Waas", "ListWhitelists", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/Whitelist/ListWhitelists").method(Method.GET).requestBuilder(ListWhitelistsRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("whitelists").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(Whitelist.class, ListWhitelistsResponse.Builder::items).handleResponseHeaderString("etag", ListWhitelistsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ListWhitelistsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWhitelistsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getWaasPolicyId(), "waasPolicyId is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("Waas", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/WorkRequestSummary/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20181116").appendPathParam("workRequests").appendQueryParam("waasPolicyId", (Object)request.getWaasPolicyId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestSummary.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public PurgeCacheResponse purgeCache(PurgeCacheRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        return (PurgeCacheResponse)this.clientCall(request, PurgeCacheResponse::builder).logger(LOG, "purgeCache").serviceDetails("Waas", "PurgeCache", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/PurgeCache/PurgeCache").method(Method.POST).requestBuilder(PurgeCacheRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("actions").appendPathParam("purgeCache").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", PurgeCacheResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", PurgeCacheResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateAccessRulesResponse updateAccessRules(UpdateAccessRulesRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAccessRules(), "accessRules is required");
        return (UpdateAccessRulesResponse)this.clientCall(request, UpdateAccessRulesResponse::builder).logger(LOG, "updateAccessRules").serviceDetails("Waas", "UpdateAccessRules", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/AccessRule/UpdateAccessRules").method(Method.PUT).requestBuilder(UpdateAccessRulesRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("accessRules").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateAccessRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateAccessRulesResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateAddressListResponse updateAddressList(UpdateAddressListRequest request) {
        Validate.notBlank((String)request.getAddressListId(), (String)"addressListId must not be blank", (Object[])new Object[0]);
        return (UpdateAddressListResponse)this.clientCall(request, UpdateAddressListResponse::builder).logger(LOG, "updateAddressList").serviceDetails("Waas", "UpdateAddressList", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/AddressList/UpdateAddressList").method(Method.PUT).requestBuilder(UpdateAddressListRequest::builder).basePath("/20181116").appendPathParam("addressLists").appendPathParam(request.getAddressListId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(AddressList.class, UpdateAddressListResponse.Builder::addressList).handleResponseHeaderString("opc-request-id", UpdateAddressListResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateAddressListResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateCachingRulesResponse updateCachingRules(UpdateCachingRulesRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCachingRulesDetails(), "cachingRulesDetails is required");
        return (UpdateCachingRulesResponse)this.clientCall(request, UpdateCachingRulesResponse::builder).logger(LOG, "updateCachingRules").serviceDetails("Waas", "UpdateCachingRules", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/CachingRule/UpdateCachingRules").method(Method.PUT).requestBuilder(UpdateCachingRulesRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("cachingRules").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateCachingRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateCachingRulesResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateCaptchasResponse updateCaptchas(UpdateCaptchasRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCaptchas(), "captchas is required");
        return (UpdateCaptchasResponse)this.clientCall(request, UpdateCaptchasResponse::builder).logger(LOG, "updateCaptchas").serviceDetails("Waas", "UpdateCaptchas", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/Captcha/UpdateCaptchas").method(Method.PUT).requestBuilder(UpdateCaptchasRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("captchas").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateCaptchasResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateCaptchasResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateCertificateResponse updateCertificate(UpdateCertificateRequest request) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        return (UpdateCertificateResponse)this.clientCall(request, UpdateCertificateResponse::builder).logger(LOG, "updateCertificate").serviceDetails("Waas", "UpdateCertificate", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/Certificate/UpdateCertificate").method(Method.PUT).requestBuilder(UpdateCertificateRequest::builder).basePath("/20181116").appendPathParam("certificates").appendPathParam(request.getCertificateId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Certificate.class, UpdateCertificateResponse.Builder::certificate).handleResponseHeaderString("opc-request-id", UpdateCertificateResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateCertificateResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateCustomProtectionRuleResponse updateCustomProtectionRule(UpdateCustomProtectionRuleRequest request) {
        Validate.notBlank((String)request.getCustomProtectionRuleId(), (String)"customProtectionRuleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateCustomProtectionRuleDetails(), "updateCustomProtectionRuleDetails is required");
        return (UpdateCustomProtectionRuleResponse)this.clientCall(request, UpdateCustomProtectionRuleResponse::builder).logger(LOG, "updateCustomProtectionRule").serviceDetails("Waas", "UpdateCustomProtectionRule", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/CustomProtectionRule/UpdateCustomProtectionRule").method(Method.PUT).requestBuilder(UpdateCustomProtectionRuleRequest::builder).basePath("/20181116").appendPathParam("customProtectionRules").appendPathParam(request.getCustomProtectionRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(CustomProtectionRule.class, UpdateCustomProtectionRuleResponse.Builder::customProtectionRule).handleResponseHeaderString("opc-request-id", UpdateCustomProtectionRuleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateCustomProtectionRuleResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateDeviceFingerprintChallengeResponse updateDeviceFingerprintChallenge(UpdateDeviceFingerprintChallengeRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDeviceFingerprintChallengeDetails(), "updateDeviceFingerprintChallengeDetails is required");
        return (UpdateDeviceFingerprintChallengeResponse)this.clientCall(request, UpdateDeviceFingerprintChallengeResponse::builder).logger(LOG, "updateDeviceFingerprintChallenge").serviceDetails("Waas", "UpdateDeviceFingerprintChallenge", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/DeviceFingerprintChallenge/UpdateDeviceFingerprintChallenge").method(Method.PUT).requestBuilder(UpdateDeviceFingerprintChallengeRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("deviceFingerprintChallenge").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateDeviceFingerprintChallengeResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateDeviceFingerprintChallengeResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateGoodBotsResponse updateGoodBots(UpdateGoodBotsRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getGoodBots(), "goodBots is required");
        return (UpdateGoodBotsResponse)this.clientCall(request, UpdateGoodBotsResponse::builder).logger(LOG, "updateGoodBots").serviceDetails("Waas", "UpdateGoodBots", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/GoodBot/UpdateGoodBots").method(Method.PUT).requestBuilder(UpdateGoodBotsRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("goodBots").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateGoodBotsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateGoodBotsResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateHumanInteractionChallengeResponse updateHumanInteractionChallenge(UpdateHumanInteractionChallengeRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateHumanInteractionChallengeDetails(), "updateHumanInteractionChallengeDetails is required");
        return (UpdateHumanInteractionChallengeResponse)this.clientCall(request, UpdateHumanInteractionChallengeResponse::builder).logger(LOG, "updateHumanInteractionChallenge").serviceDetails("Waas", "UpdateHumanInteractionChallenge", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/HumanInteractionChallenge/UpdateHumanInteractionChallenge").method(Method.PUT).requestBuilder(UpdateHumanInteractionChallengeRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("humanInteractionChallenge").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateHumanInteractionChallengeResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateHumanInteractionChallengeResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateJsChallengeResponse updateJsChallenge(UpdateJsChallengeRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateJsChallengeDetails(), "updateJsChallengeDetails is required");
        return (UpdateJsChallengeResponse)this.clientCall(request, UpdateJsChallengeResponse::builder).logger(LOG, "updateJsChallenge").serviceDetails("Waas", "UpdateJsChallenge", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/JsChallenge/UpdateJsChallenge").method(Method.PUT).requestBuilder(UpdateJsChallengeRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("jsChallenge").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateJsChallengeResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateJsChallengeResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdatePolicyConfigResponse updatePolicyConfig(UpdatePolicyConfigRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePolicyConfigDetails(), "updatePolicyConfigDetails is required");
        return (UpdatePolicyConfigResponse)this.clientCall(request, UpdatePolicyConfigResponse::builder).logger(LOG, "updatePolicyConfig").serviceDetails("Waas", "UpdatePolicyConfig", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/PolicyConfig/UpdatePolicyConfig").method(Method.PUT).requestBuilder(UpdatePolicyConfigRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("policyConfig").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdatePolicyConfigResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdatePolicyConfigResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateProtectionRulesResponse updateProtectionRules(UpdateProtectionRulesRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getProtectionRules(), "protectionRules is required");
        return (UpdateProtectionRulesResponse)this.clientCall(request, UpdateProtectionRulesResponse::builder).logger(LOG, "updateProtectionRules").serviceDetails("Waas", "UpdateProtectionRules", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/ProtectionRule/UpdateProtectionRules").method(Method.PUT).requestBuilder(UpdateProtectionRulesRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("protectionRules").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateProtectionRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateProtectionRulesResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateProtectionSettingsResponse updateProtectionSettings(UpdateProtectionSettingsRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProtectionSettingsDetails(), "updateProtectionSettingsDetails is required");
        return (UpdateProtectionSettingsResponse)this.clientCall(request, UpdateProtectionSettingsResponse::builder).logger(LOG, "updateProtectionSettings").serviceDetails("Waas", "UpdateProtectionSettings", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/ProtectionSettings/UpdateProtectionSettings").method(Method.PUT).requestBuilder(UpdateProtectionSettingsRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("protectionSettings").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateProtectionSettingsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateProtectionSettingsResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateThreatFeedsResponse updateThreatFeeds(UpdateThreatFeedsRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getThreatFeeds(), "threatFeeds is required");
        return (UpdateThreatFeedsResponse)this.clientCall(request, UpdateThreatFeedsResponse::builder).logger(LOG, "updateThreatFeeds").serviceDetails("Waas", "UpdateThreatFeeds", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/ThreatFeed/UpdateThreatFeeds").method(Method.PUT).requestBuilder(UpdateThreatFeedsRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("threatFeeds").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateThreatFeedsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateThreatFeedsResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateWaasPolicyResponse updateWaasPolicy(UpdateWaasPolicyRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateWaasPolicyDetails(), "updateWaasPolicyDetails is required");
        return (UpdateWaasPolicyResponse)this.clientCall(request, UpdateWaasPolicyResponse::builder).logger(LOG, "updateWaasPolicy").serviceDetails("Waas", "UpdateWaasPolicy", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/WaasPolicy/UpdateWaasPolicy").method(Method.PUT).requestBuilder(UpdateWaasPolicyRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateWaasPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateWaasPolicyResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateWaasPolicyCustomProtectionRulesResponse updateWaasPolicyCustomProtectionRules(UpdateWaasPolicyCustomProtectionRulesRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateCustomProtectionRulesDetails(), "updateCustomProtectionRulesDetails is required");
        return (UpdateWaasPolicyCustomProtectionRulesResponse)this.clientCall(request, UpdateWaasPolicyCustomProtectionRulesResponse::builder).logger(LOG, "updateWaasPolicyCustomProtectionRules").serviceDetails("Waas", "UpdateWaasPolicyCustomProtectionRules", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/CustomProtectionRule/UpdateWaasPolicyCustomProtectionRules").method(Method.PUT).requestBuilder(UpdateWaasPolicyCustomProtectionRulesRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("customProtectionRules").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateWaasPolicyCustomProtectionRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateWaasPolicyCustomProtectionRulesResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateWafAddressRateLimitingResponse updateWafAddressRateLimiting(UpdateWafAddressRateLimitingRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateWafAddressRateLimitingDetails(), "updateWafAddressRateLimitingDetails is required");
        return (UpdateWafAddressRateLimitingResponse)this.clientCall(request, UpdateWafAddressRateLimitingResponse::builder).logger(LOG, "updateWafAddressRateLimiting").serviceDetails("Waas", "UpdateWafAddressRateLimiting", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/AddressRateLimiting/UpdateWafAddressRateLimiting").method(Method.PUT).requestBuilder(UpdateWafAddressRateLimitingRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("addressRateLimiting").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateWafAddressRateLimitingResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateWafAddressRateLimitingResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateWafConfigResponse updateWafConfig(UpdateWafConfigRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateWafConfigDetails(), "updateWafConfigDetails is required");
        return (UpdateWafConfigResponse)this.clientCall(request, UpdateWafConfigResponse::builder).logger(LOG, "updateWafConfig").serviceDetails("Waas", "UpdateWafConfig", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/WafConfig/UpdateWafConfig").method(Method.PUT).requestBuilder(UpdateWafConfigRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateWafConfigResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateWafConfigResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateWhitelistsResponse updateWhitelists(UpdateWhitelistsRequest request) {
        Validate.notBlank((String)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getWhitelists(), "whitelists is required");
        return (UpdateWhitelistsResponse)this.clientCall(request, UpdateWhitelistsResponse::builder).logger(LOG, "updateWhitelists").serviceDetails("Waas", "UpdateWhitelists", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/Whitelist/UpdateWhitelists").method(Method.PUT).requestBuilder(UpdateWhitelistsRequest::builder).basePath("/20181116").appendPathParam("waasPolicies").appendPathParam(request.getWaasPolicyId()).appendPathParam("wafConfig").appendPathParam("whitelists").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateWhitelistsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateWhitelistsResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public WaasWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public WaasPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public WaasClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)WaasClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public WaasClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(WaasClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public WaasClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)WaasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public WaasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)WaasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public WaasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)WaasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public WaasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)WaasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public WaasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)WaasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public WaasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)WaasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, WaasClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public WaasClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new WaasClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

