/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waas.Redirect;
import com.oracle.bmc.waas.RedirectAsyncClient;
import com.oracle.bmc.waas.RedirectPaginators;
import com.oracle.bmc.waas.RedirectWaiters;
import com.oracle.bmc.waas.model.HttpRedirect;
import com.oracle.bmc.waas.model.HttpRedirectSummary;
import com.oracle.bmc.waas.requests.ChangeHttpRedirectCompartmentRequest;
import com.oracle.bmc.waas.requests.CreateHttpRedirectRequest;
import com.oracle.bmc.waas.requests.DeleteHttpRedirectRequest;
import com.oracle.bmc.waas.requests.GetHttpRedirectRequest;
import com.oracle.bmc.waas.requests.ListHttpRedirectsRequest;
import com.oracle.bmc.waas.requests.UpdateHttpRedirectRequest;
import com.oracle.bmc.waas.responses.ChangeHttpRedirectCompartmentResponse;
import com.oracle.bmc.waas.responses.CreateHttpRedirectResponse;
import com.oracle.bmc.waas.responses.DeleteHttpRedirectResponse;
import com.oracle.bmc.waas.responses.GetHttpRedirectResponse;
import com.oracle.bmc.waas.responses.ListHttpRedirectsResponse;
import com.oracle.bmc.waas.responses.UpdateHttpRedirectResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectClient
extends BaseSyncClient
implements Redirect {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("REDIRECT").serviceEndpointPrefix("waas").serviceEndpointTemplate("https://waas.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(RedirectAsyncClient.class);
    private final RedirectWaiters waiters;
    private final RedirectPaginators paginators;

    private RedirectClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Redirect-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new RedirectWaiters(executorService, this);
        this.paginators = new RedirectPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeHttpRedirectCompartmentResponse changeHttpRedirectCompartment(ChangeHttpRedirectCompartmentRequest request) {
        Validate.notBlank((String)request.getHttpRedirectId(), (String)"httpRedirectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeHttpRedirectCompartmentDetails(), "changeHttpRedirectCompartmentDetails is required");
        return (ChangeHttpRedirectCompartmentResponse)this.clientCall(request, ChangeHttpRedirectCompartmentResponse::builder).logger(LOG, "changeHttpRedirectCompartment").serviceDetails("Redirect", "ChangeHttpRedirectCompartment", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/HttpRedirect/ChangeHttpRedirectCompartment").method(Method.POST).requestBuilder(ChangeHttpRedirectCompartmentRequest::builder).basePath("/20181116").appendPathParam("httpRedirects").appendPathParam(request.getHttpRedirectId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeHttpRedirectCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateHttpRedirectResponse createHttpRedirect(CreateHttpRedirectRequest request) {
        Objects.requireNonNull(request.getCreateHttpRedirectDetails(), "createHttpRedirectDetails is required");
        return (CreateHttpRedirectResponse)this.clientCall(request, CreateHttpRedirectResponse::builder).logger(LOG, "createHttpRedirect").serviceDetails("Redirect", "CreateHttpRedirect", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/HttpRedirect/CreateHttpRedirect").method(Method.POST).requestBuilder(CreateHttpRedirectRequest::builder).basePath("/20181116").appendPathParam("httpRedirects").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", CreateHttpRedirectResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateHttpRedirectResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteHttpRedirectResponse deleteHttpRedirect(DeleteHttpRedirectRequest request) {
        Validate.notBlank((String)request.getHttpRedirectId(), (String)"httpRedirectId must not be blank", (Object[])new Object[0]);
        return (DeleteHttpRedirectResponse)this.clientCall(request, DeleteHttpRedirectResponse::builder).logger(LOG, "deleteHttpRedirect").serviceDetails("Redirect", "DeleteHttpRedirect", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/HttpRedirect/DeleteHttpRedirect").method(Method.DELETE).requestBuilder(DeleteHttpRedirectRequest::builder).basePath("/20181116").appendPathParam("httpRedirects").appendPathParam(request.getHttpRedirectId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteHttpRedirectResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteHttpRedirectResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GetHttpRedirectResponse getHttpRedirect(GetHttpRedirectRequest request) {
        Validate.notBlank((String)request.getHttpRedirectId(), (String)"httpRedirectId must not be blank", (Object[])new Object[0]);
        return (GetHttpRedirectResponse)this.clientCall(request, GetHttpRedirectResponse::builder).logger(LOG, "getHttpRedirect").serviceDetails("Redirect", "GetHttpRedirect", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/HttpRedirect/GetHttpRedirect").method(Method.GET).requestBuilder(GetHttpRedirectRequest::builder).basePath("/20181116").appendPathParam("httpRedirects").appendPathParam(request.getHttpRedirectId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HttpRedirect.class, GetHttpRedirectResponse.Builder::httpRedirect).handleResponseHeaderString("etag", GetHttpRedirectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetHttpRedirectResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListHttpRedirectsResponse listHttpRedirects(ListHttpRedirectsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListHttpRedirectsResponse)this.clientCall(request, ListHttpRedirectsResponse::builder).logger(LOG, "listHttpRedirects").serviceDetails("Redirect", "ListHttpRedirects", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/HttpRedirect/ListHttpRedirects").method(Method.GET).requestBuilder(ListHttpRedirectsRequest::builder).basePath("/20181116").appendPathParam("httpRedirects").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("id", request.getId(), CollectionFormatType.Multi).appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).appendQueryParam("timeCreatedGreaterThanOrEqualTo", (Object)request.getTimeCreatedGreaterThanOrEqualTo()).appendQueryParam("timeCreatedLessThan", (Object)request.getTimeCreatedLessThan()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(HttpRedirectSummary.class, ListHttpRedirectsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListHttpRedirectsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListHttpRedirectsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateHttpRedirectResponse updateHttpRedirect(UpdateHttpRedirectRequest request) {
        Validate.notBlank((String)request.getHttpRedirectId(), (String)"httpRedirectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateHttpRedirectDetails(), "updateHttpRedirectDetails is required");
        return (UpdateHttpRedirectResponse)this.clientCall(request, UpdateHttpRedirectResponse::builder).logger(LOG, "updateHttpRedirect").serviceDetails("Redirect", "UpdateHttpRedirect", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/HttpRedirect/UpdateHttpRedirect").method(Method.PUT).requestBuilder(UpdateHttpRedirectRequest::builder).basePath("/20181116").appendPathParam("httpRedirects").appendPathParam(request.getHttpRedirectId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateHttpRedirectResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateHttpRedirectResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public RedirectWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public RedirectPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public RedirectClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)RedirectClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public RedirectClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(RedirectClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public RedirectClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)RedirectClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public RedirectClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)RedirectClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RedirectClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)RedirectClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RedirectClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)RedirectClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RedirectClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)RedirectClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RedirectClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)RedirectClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RedirectClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public RedirectClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new RedirectClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

