/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waa.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetWebAppAccelerationPolicyRequest
extends BmcRequest<Void> {
    private String webAppAccelerationPolicyId;
    private String opcRequestId;

    public String getWebAppAccelerationPolicyId() {
        return this.webAppAccelerationPolicyId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().webAppAccelerationPolicyId(this.webAppAccelerationPolicyId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",webAppAccelerationPolicyId=").append(String.valueOf(this.webAppAccelerationPolicyId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetWebAppAccelerationPolicyRequest)) {
            return false;
        }
        GetWebAppAccelerationPolicyRequest other = (GetWebAppAccelerationPolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.webAppAccelerationPolicyId, other.webAppAccelerationPolicyId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.webAppAccelerationPolicyId == null ? 43 : this.webAppAccelerationPolicyId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetWebAppAccelerationPolicyRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String webAppAccelerationPolicyId = null;
        private String opcRequestId = null;

        public Builder webAppAccelerationPolicyId(String webAppAccelerationPolicyId) {
            this.webAppAccelerationPolicyId = webAppAccelerationPolicyId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetWebAppAccelerationPolicyRequest o) {
            this.webAppAccelerationPolicyId(o.getWebAppAccelerationPolicyId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetWebAppAccelerationPolicyRequest build() {
            GetWebAppAccelerationPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetWebAppAccelerationPolicyRequest buildWithoutInvocationCallback() {
            GetWebAppAccelerationPolicyRequest request = new GetWebAppAccelerationPolicyRequest();
            request.webAppAccelerationPolicyId = this.webAppAccelerationPolicyId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

