/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetHostVulnerabilityRequest
extends BmcRequest<Void> {
    private String hostVulnerabilityId;
    private String opcRequestId;

    public String getHostVulnerabilityId() {
        return this.hostVulnerabilityId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().hostVulnerabilityId(this.hostVulnerabilityId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",hostVulnerabilityId=").append(String.valueOf(this.hostVulnerabilityId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetHostVulnerabilityRequest)) {
            return false;
        }
        GetHostVulnerabilityRequest other = (GetHostVulnerabilityRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.hostVulnerabilityId, other.hostVulnerabilityId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.hostVulnerabilityId == null ? 43 : this.hostVulnerabilityId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetHostVulnerabilityRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String hostVulnerabilityId = null;
        private String opcRequestId = null;

        public Builder hostVulnerabilityId(String hostVulnerabilityId) {
            this.hostVulnerabilityId = hostVulnerabilityId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetHostVulnerabilityRequest o) {
            this.hostVulnerabilityId(o.getHostVulnerabilityId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetHostVulnerabilityRequest build() {
            GetHostVulnerabilityRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetHostVulnerabilityRequest buildWithoutInvocationCallback() {
            GetHostVulnerabilityRequest request = new GetHostVulnerabilityRequest();
            request.hostVulnerabilityId = this.hostVulnerabilityId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

