/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetHostAgentScanResultRequest
extends BmcRequest<Void> {
    private String hostAgentScanResultId;
    private String opcRequestId;

    public String getHostAgentScanResultId() {
        return this.hostAgentScanResultId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().hostAgentScanResultId(this.hostAgentScanResultId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",hostAgentScanResultId=").append(String.valueOf(this.hostAgentScanResultId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetHostAgentScanResultRequest)) {
            return false;
        }
        GetHostAgentScanResultRequest other = (GetHostAgentScanResultRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.hostAgentScanResultId, other.hostAgentScanResultId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.hostAgentScanResultId == null ? 43 : this.hostAgentScanResultId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetHostAgentScanResultRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String hostAgentScanResultId = null;
        private String opcRequestId = null;

        public Builder hostAgentScanResultId(String hostAgentScanResultId) {
            this.hostAgentScanResultId = hostAgentScanResultId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetHostAgentScanResultRequest o) {
            this.hostAgentScanResultId(o.getHostAgentScanResultId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetHostAgentScanResultRequest build() {
            GetHostAgentScanResultRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetHostAgentScanResultRequest buildWithoutInvocationCallback() {
            GetHostAgentScanResultRequest request = new GetHostAgentScanResultRequest();
            request.hostAgentScanResultId = this.hostAgentScanResultId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

