/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetContainerScanRecipeRequest
extends BmcRequest<Void> {
    private String containerScanRecipeId;
    private String opcRequestId;

    public String getContainerScanRecipeId() {
        return this.containerScanRecipeId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().containerScanRecipeId(this.containerScanRecipeId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",containerScanRecipeId=").append(String.valueOf(this.containerScanRecipeId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetContainerScanRecipeRequest)) {
            return false;
        }
        GetContainerScanRecipeRequest other = (GetContainerScanRecipeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.containerScanRecipeId, other.containerScanRecipeId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.containerScanRecipeId == null ? 43 : this.containerScanRecipeId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetContainerScanRecipeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String containerScanRecipeId = null;
        private String opcRequestId = null;

        public Builder containerScanRecipeId(String containerScanRecipeId) {
            this.containerScanRecipeId = containerScanRecipeId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetContainerScanRecipeRequest o) {
            this.containerScanRecipeId(o.getContainerScanRecipeId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetContainerScanRecipeRequest build() {
            GetContainerScanRecipeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetContainerScanRecipeRequest buildWithoutInvocationCallback() {
            GetContainerScanRecipeRequest request = new GetContainerScanRecipeRequest();
            request.containerScanRecipeId = this.containerScanRecipeId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

