/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.vulnerabilityscanning.model.ImpactedResourcesCount;
import com.oracle.bmc.vulnerabilityscanning.model.LifecycleState;
import com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity;
import com.oracle.bmc.vulnerabilityscanning.model.ScanResultVulnerabilityState;
import com.oracle.bmc.vulnerabilityscanning.model.VulnerabilityType;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VulnerabilitySummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="vulnerabilityReference")
    private final String vulnerabilityReference;
    @JsonProperty(value="severity")
    private final ScanResultProblemSeverity severity;
    @JsonProperty(value="state")
    private final ScanResultVulnerabilityState state;
    @JsonProperty(value="cveDescription")
    private final String cveDescription;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="timeLastDetected")
    private final Date timeLastDetected;
    @JsonProperty(value="timeFirstDetected")
    private final Date timeFirstDetected;
    @JsonProperty(value="impactedResourcesCount")
    private final ImpactedResourcesCount impactedResourcesCount;
    @JsonProperty(value="vulnerabilityType")
    private final VulnerabilityType vulnerabilityType;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "vulnerabilityReference", "severity", "state", "cveDescription", "name", "timeLastDetected", "timeFirstDetected", "impactedResourcesCount", "vulnerabilityType", "lifecycleState"})
    public VulnerabilitySummary(String id, String compartmentId, String vulnerabilityReference, ScanResultProblemSeverity severity, ScanResultVulnerabilityState state, String cveDescription, String name, Date timeLastDetected, Date timeFirstDetected, ImpactedResourcesCount impactedResourcesCount, VulnerabilityType vulnerabilityType, LifecycleState lifecycleState) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.vulnerabilityReference = vulnerabilityReference;
        this.severity = severity;
        this.state = state;
        this.cveDescription = cveDescription;
        this.name = name;
        this.timeLastDetected = timeLastDetected;
        this.timeFirstDetected = timeFirstDetected;
        this.impactedResourcesCount = impactedResourcesCount;
        this.vulnerabilityType = vulnerabilityType;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getVulnerabilityReference() {
        return this.vulnerabilityReference;
    }

    public ScanResultProblemSeverity getSeverity() {
        return this.severity;
    }

    public ScanResultVulnerabilityState getState() {
        return this.state;
    }

    public String getCveDescription() {
        return this.cveDescription;
    }

    public String getName() {
        return this.name;
    }

    public Date getTimeLastDetected() {
        return this.timeLastDetected;
    }

    public Date getTimeFirstDetected() {
        return this.timeFirstDetected;
    }

    public ImpactedResourcesCount getImpactedResourcesCount() {
        return this.impactedResourcesCount;
    }

    public VulnerabilityType getVulnerabilityType() {
        return this.vulnerabilityType;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VulnerabilitySummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", vulnerabilityReference=").append(String.valueOf(this.vulnerabilityReference));
        sb.append(", severity=").append(String.valueOf((Object)this.severity));
        sb.append(", state=").append(String.valueOf((Object)this.state));
        sb.append(", cveDescription=").append(String.valueOf(this.cveDescription));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", timeLastDetected=").append(String.valueOf(this.timeLastDetected));
        sb.append(", timeFirstDetected=").append(String.valueOf(this.timeFirstDetected));
        sb.append(", impactedResourcesCount=").append(String.valueOf((Object)this.impactedResourcesCount));
        sb.append(", vulnerabilityType=").append(String.valueOf((Object)this.vulnerabilityType));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VulnerabilitySummary)) {
            return false;
        }
        VulnerabilitySummary other = (VulnerabilitySummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.vulnerabilityReference, other.vulnerabilityReference) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.cveDescription, other.cveDescription) && Objects.equals(this.name, other.name) && Objects.equals(this.timeLastDetected, other.timeLastDetected) && Objects.equals(this.timeFirstDetected, other.timeFirstDetected) && Objects.equals((Object)this.impactedResourcesCount, (Object)other.impactedResourcesCount) && Objects.equals((Object)this.vulnerabilityType, (Object)other.vulnerabilityType) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.vulnerabilityReference == null ? 43 : this.vulnerabilityReference.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.state == null ? 43 : this.state.hashCode());
        result = result * 59 + (this.cveDescription == null ? 43 : this.cveDescription.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.timeLastDetected == null ? 43 : this.timeLastDetected.hashCode());
        result = result * 59 + (this.timeFirstDetected == null ? 43 : this.timeFirstDetected.hashCode());
        result = result * 59 + (this.impactedResourcesCount == null ? 43 : this.impactedResourcesCount.hashCode());
        result = result * 59 + (this.vulnerabilityType == null ? 43 : this.vulnerabilityType.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="vulnerabilityReference")
        private String vulnerabilityReference;
        @JsonProperty(value="severity")
        private ScanResultProblemSeverity severity;
        @JsonProperty(value="state")
        private ScanResultVulnerabilityState state;
        @JsonProperty(value="cveDescription")
        private String cveDescription;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="timeLastDetected")
        private Date timeLastDetected;
        @JsonProperty(value="timeFirstDetected")
        private Date timeFirstDetected;
        @JsonProperty(value="impactedResourcesCount")
        private ImpactedResourcesCount impactedResourcesCount;
        @JsonProperty(value="vulnerabilityType")
        private VulnerabilityType vulnerabilityType;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder vulnerabilityReference(String vulnerabilityReference) {
            this.vulnerabilityReference = vulnerabilityReference;
            this.__explicitlySet__.add("vulnerabilityReference");
            return this;
        }

        public Builder severity(ScanResultProblemSeverity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        public Builder state(ScanResultVulnerabilityState state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }

        public Builder cveDescription(String cveDescription) {
            this.cveDescription = cveDescription;
            this.__explicitlySet__.add("cveDescription");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder timeLastDetected(Date timeLastDetected) {
            this.timeLastDetected = timeLastDetected;
            this.__explicitlySet__.add("timeLastDetected");
            return this;
        }

        public Builder timeFirstDetected(Date timeFirstDetected) {
            this.timeFirstDetected = timeFirstDetected;
            this.__explicitlySet__.add("timeFirstDetected");
            return this;
        }

        public Builder impactedResourcesCount(ImpactedResourcesCount impactedResourcesCount) {
            this.impactedResourcesCount = impactedResourcesCount;
            this.__explicitlySet__.add("impactedResourcesCount");
            return this;
        }

        public Builder vulnerabilityType(VulnerabilityType vulnerabilityType) {
            this.vulnerabilityType = vulnerabilityType;
            this.__explicitlySet__.add("vulnerabilityType");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public VulnerabilitySummary build() {
            VulnerabilitySummary model = new VulnerabilitySummary(this.id, this.compartmentId, this.vulnerabilityReference, this.severity, this.state, this.cveDescription, this.name, this.timeLastDetected, this.timeFirstDetected, this.impactedResourcesCount, this.vulnerabilityType, this.lifecycleState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VulnerabilitySummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("vulnerabilityReference")) {
                this.vulnerabilityReference(model.getVulnerabilityReference());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            if (model.wasPropertyExplicitlySet("cveDescription")) {
                this.cveDescription(model.getCveDescription());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("timeLastDetected")) {
                this.timeLastDetected(model.getTimeLastDetected());
            }
            if (model.wasPropertyExplicitlySet("timeFirstDetected")) {
                this.timeFirstDetected(model.getTimeFirstDetected());
            }
            if (model.wasPropertyExplicitlySet("impactedResourcesCount")) {
                this.impactedResourcesCount(model.getImpactedResourcesCount());
            }
            if (model.wasPropertyExplicitlySet("vulnerabilityType")) {
                this.vulnerabilityType(model.getVulnerabilityType());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            return this;
        }
    }
}

