/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ImpactedResourcesCount
extends ExplicitlySetBmcModel {
    @JsonProperty(value="hostCount")
    private final Integer hostCount;
    @JsonProperty(value="imageCount")
    private final Integer imageCount;

    @Deprecated
    @ConstructorProperties(value={"hostCount", "imageCount"})
    public ImpactedResourcesCount(Integer hostCount, Integer imageCount) {
        this.hostCount = hostCount;
        this.imageCount = imageCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getHostCount() {
        return this.hostCount;
    }

    public Integer getImageCount() {
        return this.imageCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ImpactedResourcesCount(");
        sb.append("super=").append(super.toString());
        sb.append("hostCount=").append(String.valueOf(this.hostCount));
        sb.append(", imageCount=").append(String.valueOf(this.imageCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImpactedResourcesCount)) {
            return false;
        }
        ImpactedResourcesCount other = (ImpactedResourcesCount)((Object)o);
        return Objects.equals(this.hostCount, other.hostCount) && Objects.equals(this.imageCount, other.imageCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.hostCount == null ? 43 : this.hostCount.hashCode());
        result = result * 59 + (this.imageCount == null ? 43 : this.imageCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="hostCount")
        private Integer hostCount;
        @JsonProperty(value="imageCount")
        private Integer imageCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder hostCount(Integer hostCount) {
            this.hostCount = hostCount;
            this.__explicitlySet__.add("hostCount");
            return this;
        }

        public Builder imageCount(Integer imageCount) {
            this.imageCount = imageCount;
            this.__explicitlySet__.add("imageCount");
            return this;
        }

        public ImpactedResourcesCount build() {
            ImpactedResourcesCount model = new ImpactedResourcesCount(this.hostCount, this.imageCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ImpactedResourcesCount model) {
            if (model.wasPropertyExplicitlySet("hostCount")) {
                this.hostCount(model.getHostCount());
            }
            if (model.wasPropertyExplicitlySet("imageCount")) {
                this.imageCount(model.getImageCount());
            }
            return this;
        }
    }
}

