/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.vulnerabilityscanning.model.Package;
import com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity;
import com.oracle.bmc.vulnerabilityscanning.model.ScanResultVulnerabilityState;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HostAgentScanResultProblem
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="severity")
    private final ScanResultProblemSeverity severity;
    @JsonProperty(value="state")
    private final ScanResultVulnerabilityState state;
    @JsonProperty(value="cveReference")
    private final String cveReference;
    @JsonProperty(value="issueId")
    private final Integer issueId;
    @JsonProperty(value="timeFirstDetected")
    private final Date timeFirstDetected;
    @JsonProperty(value="timeLastDetected")
    private final Date timeLastDetected;
    @JsonProperty(value="vulnerablePackages")
    private final List<Package> vulnerablePackages;

    @Deprecated
    @ConstructorProperties(value={"name", "description", "severity", "state", "cveReference", "issueId", "timeFirstDetected", "timeLastDetected", "vulnerablePackages"})
    public HostAgentScanResultProblem(String name, String description, ScanResultProblemSeverity severity, ScanResultVulnerabilityState state, String cveReference, Integer issueId, Date timeFirstDetected, Date timeLastDetected, List<Package> vulnerablePackages) {
        this.name = name;
        this.description = description;
        this.severity = severity;
        this.state = state;
        this.cveReference = cveReference;
        this.issueId = issueId;
        this.timeFirstDetected = timeFirstDetected;
        this.timeLastDetected = timeLastDetected;
        this.vulnerablePackages = vulnerablePackages;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ScanResultProblemSeverity getSeverity() {
        return this.severity;
    }

    public ScanResultVulnerabilityState getState() {
        return this.state;
    }

    public String getCveReference() {
        return this.cveReference;
    }

    public Integer getIssueId() {
        return this.issueId;
    }

    public Date getTimeFirstDetected() {
        return this.timeFirstDetected;
    }

    public Date getTimeLastDetected() {
        return this.timeLastDetected;
    }

    public List<Package> getVulnerablePackages() {
        return this.vulnerablePackages;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostAgentScanResultProblem(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", severity=").append(String.valueOf((Object)this.severity));
        sb.append(", state=").append(String.valueOf((Object)this.state));
        sb.append(", cveReference=").append(String.valueOf(this.cveReference));
        sb.append(", issueId=").append(String.valueOf(this.issueId));
        sb.append(", timeFirstDetected=").append(String.valueOf(this.timeFirstDetected));
        sb.append(", timeLastDetected=").append(String.valueOf(this.timeLastDetected));
        sb.append(", vulnerablePackages=").append(String.valueOf(this.vulnerablePackages));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostAgentScanResultProblem)) {
            return false;
        }
        HostAgentScanResultProblem other = (HostAgentScanResultProblem)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.cveReference, other.cveReference) && Objects.equals(this.issueId, other.issueId) && Objects.equals(this.timeFirstDetected, other.timeFirstDetected) && Objects.equals(this.timeLastDetected, other.timeLastDetected) && Objects.equals(this.vulnerablePackages, other.vulnerablePackages) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.state == null ? 43 : this.state.hashCode());
        result = result * 59 + (this.cveReference == null ? 43 : this.cveReference.hashCode());
        result = result * 59 + (this.issueId == null ? 43 : this.issueId.hashCode());
        result = result * 59 + (this.timeFirstDetected == null ? 43 : this.timeFirstDetected.hashCode());
        result = result * 59 + (this.timeLastDetected == null ? 43 : this.timeLastDetected.hashCode());
        result = result * 59 + (this.vulnerablePackages == null ? 43 : this.vulnerablePackages.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="severity")
        private ScanResultProblemSeverity severity;
        @JsonProperty(value="state")
        private ScanResultVulnerabilityState state;
        @JsonProperty(value="cveReference")
        private String cveReference;
        @JsonProperty(value="issueId")
        private Integer issueId;
        @JsonProperty(value="timeFirstDetected")
        private Date timeFirstDetected;
        @JsonProperty(value="timeLastDetected")
        private Date timeLastDetected;
        @JsonProperty(value="vulnerablePackages")
        private List<Package> vulnerablePackages;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder severity(ScanResultProblemSeverity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        public Builder state(ScanResultVulnerabilityState state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }

        public Builder cveReference(String cveReference) {
            this.cveReference = cveReference;
            this.__explicitlySet__.add("cveReference");
            return this;
        }

        public Builder issueId(Integer issueId) {
            this.issueId = issueId;
            this.__explicitlySet__.add("issueId");
            return this;
        }

        public Builder timeFirstDetected(Date timeFirstDetected) {
            this.timeFirstDetected = timeFirstDetected;
            this.__explicitlySet__.add("timeFirstDetected");
            return this;
        }

        public Builder timeLastDetected(Date timeLastDetected) {
            this.timeLastDetected = timeLastDetected;
            this.__explicitlySet__.add("timeLastDetected");
            return this;
        }

        public Builder vulnerablePackages(List<Package> vulnerablePackages) {
            this.vulnerablePackages = vulnerablePackages;
            this.__explicitlySet__.add("vulnerablePackages");
            return this;
        }

        public HostAgentScanResultProblem build() {
            HostAgentScanResultProblem model = new HostAgentScanResultProblem(this.name, this.description, this.severity, this.state, this.cveReference, this.issueId, this.timeFirstDetected, this.timeLastDetected, this.vulnerablePackages);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostAgentScanResultProblem model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            if (model.wasPropertyExplicitlySet("cveReference")) {
                this.cveReference(model.getCveReference());
            }
            if (model.wasPropertyExplicitlySet("issueId")) {
                this.issueId(model.getIssueId());
            }
            if (model.wasPropertyExplicitlySet("timeFirstDetected")) {
                this.timeFirstDetected(model.getTimeFirstDetected());
            }
            if (model.wasPropertyExplicitlySet("timeLastDetected")) {
                this.timeLastDetected(model.getTimeLastDetected());
            }
            if (model.wasPropertyExplicitlySet("vulnerablePackages")) {
                this.vulnerablePackages(model.getVulnerablePackages());
            }
            return this;
        }
    }
}

