/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.vulnerabilityscanning.VulnerabilityScanning;
import com.oracle.bmc.vulnerabilityscanning.model.ContainerScanRecipeSummary;
import com.oracle.bmc.vulnerabilityscanning.model.ContainerScanResultSummary;
import com.oracle.bmc.vulnerabilityscanning.model.ContainerScanTargetSummary;
import com.oracle.bmc.vulnerabilityscanning.model.HostAgentScanResultSummary;
import com.oracle.bmc.vulnerabilityscanning.model.HostCisBenchmarkScanResultSummary;
import com.oracle.bmc.vulnerabilityscanning.model.HostEndpointProtectionScanResultSummary;
import com.oracle.bmc.vulnerabilityscanning.model.HostPortScanResultSummary;
import com.oracle.bmc.vulnerabilityscanning.model.HostScanRecipeSummary;
import com.oracle.bmc.vulnerabilityscanning.model.HostScanTargetErrorSummary;
import com.oracle.bmc.vulnerabilityscanning.model.HostScanTargetSummary;
import com.oracle.bmc.vulnerabilityscanning.model.HostVulnerabilityImpactedHostSummary;
import com.oracle.bmc.vulnerabilityscanning.model.HostVulnerabilitySummary;
import com.oracle.bmc.vulnerabilityscanning.model.VulnerabilityImpactedContainerSummary;
import com.oracle.bmc.vulnerabilityscanning.model.VulnerabilityImpactedHostSummary;
import com.oracle.bmc.vulnerabilityscanning.model.VulnerabilitySummary;
import com.oracle.bmc.vulnerabilityscanning.model.WorkRequest;
import com.oracle.bmc.vulnerabilityscanning.model.WorkRequestError;
import com.oracle.bmc.vulnerabilityscanning.model.WorkRequestLogEntry;
import com.oracle.bmc.vulnerabilityscanning.requests.ListContainerScanRecipesRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListContainerScanResultsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListContainerScanTargetsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListHostAgentScanResultsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListHostCisBenchmarkScanResultsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListHostEndpointProtectionScanResultsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListHostPortScanResultsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListHostScanRecipesRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListHostScanTargetErrorsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListHostScanTargetsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListHostVulnerabilitiesRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListHostVulnerabilityImpactedHostsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListVulnerabilitiesRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListVulnerabilityImpactedContainersRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListVulnerabilityImpactedHostsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListWorkRequestsRequest;
import com.oracle.bmc.vulnerabilityscanning.responses.ListContainerScanRecipesResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListContainerScanResultsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListContainerScanTargetsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListHostAgentScanResultsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListHostCisBenchmarkScanResultsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListHostEndpointProtectionScanResultsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListHostPortScanResultsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListHostScanRecipesResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListHostScanTargetErrorsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListHostScanTargetsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListHostVulnerabilitiesResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListHostVulnerabilityImpactedHostsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListVulnerabilitiesResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListVulnerabilityImpactedContainersResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListVulnerabilityImpactedHostsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListWorkRequestsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class VulnerabilityScanningPaginators {
    private final VulnerabilityScanning client;

    public VulnerabilityScanningPaginators(VulnerabilityScanning client) {
        this.client = client;
    }

    public Iterable<ListContainerScanRecipesResponse> listContainerScanRecipesResponseIterator(final ListContainerScanRecipesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListContainerScanRecipesRequest.Builder>(){

            @Override
            public ListContainerScanRecipesRequest.Builder get() {
                return ListContainerScanRecipesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerScanRecipesResponse, String>(){

            @Override
            public String apply(ListContainerScanRecipesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerScanRecipesRequest.Builder>, ListContainerScanRecipesRequest>(){

            @Override
            public ListContainerScanRecipesRequest apply(RequestBuilderAndToken<ListContainerScanRecipesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListContainerScanRecipesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerScanRecipesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListContainerScanRecipesRequest, ListContainerScanRecipesResponse>(){

            @Override
            public ListContainerScanRecipesResponse apply(ListContainerScanRecipesRequest request) {
                return VulnerabilityScanningPaginators.this.client.listContainerScanRecipes(request);
            }
        });
    }

    public Iterable<ContainerScanRecipeSummary> listContainerScanRecipesRecordIterator(final ListContainerScanRecipesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListContainerScanRecipesRequest.Builder>(){

            @Override
            public ListContainerScanRecipesRequest.Builder get() {
                return ListContainerScanRecipesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerScanRecipesResponse, String>(){

            @Override
            public String apply(ListContainerScanRecipesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerScanRecipesRequest.Builder>, ListContainerScanRecipesRequest>(){

            @Override
            public ListContainerScanRecipesRequest apply(RequestBuilderAndToken<ListContainerScanRecipesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListContainerScanRecipesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerScanRecipesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListContainerScanRecipesRequest, ListContainerScanRecipesResponse>(){

            @Override
            public ListContainerScanRecipesResponse apply(ListContainerScanRecipesRequest request) {
                return VulnerabilityScanningPaginators.this.client.listContainerScanRecipes(request);
            }
        }, (Function)new Function<ListContainerScanRecipesResponse, List<ContainerScanRecipeSummary>>(){

            @Override
            public List<ContainerScanRecipeSummary> apply(ListContainerScanRecipesResponse response) {
                return response.getContainerScanRecipeSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListContainerScanResultsResponse> listContainerScanResultsResponseIterator(final ListContainerScanResultsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListContainerScanResultsRequest.Builder>(){

            @Override
            public ListContainerScanResultsRequest.Builder get() {
                return ListContainerScanResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerScanResultsResponse, String>(){

            @Override
            public String apply(ListContainerScanResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerScanResultsRequest.Builder>, ListContainerScanResultsRequest>(){

            @Override
            public ListContainerScanResultsRequest apply(RequestBuilderAndToken<ListContainerScanResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListContainerScanResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerScanResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListContainerScanResultsRequest, ListContainerScanResultsResponse>(){

            @Override
            public ListContainerScanResultsResponse apply(ListContainerScanResultsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listContainerScanResults(request);
            }
        });
    }

    public Iterable<ContainerScanResultSummary> listContainerScanResultsRecordIterator(final ListContainerScanResultsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListContainerScanResultsRequest.Builder>(){

            @Override
            public ListContainerScanResultsRequest.Builder get() {
                return ListContainerScanResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerScanResultsResponse, String>(){

            @Override
            public String apply(ListContainerScanResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerScanResultsRequest.Builder>, ListContainerScanResultsRequest>(){

            @Override
            public ListContainerScanResultsRequest apply(RequestBuilderAndToken<ListContainerScanResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListContainerScanResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerScanResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListContainerScanResultsRequest, ListContainerScanResultsResponse>(){

            @Override
            public ListContainerScanResultsResponse apply(ListContainerScanResultsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listContainerScanResults(request);
            }
        }, (Function)new Function<ListContainerScanResultsResponse, List<ContainerScanResultSummary>>(){

            @Override
            public List<ContainerScanResultSummary> apply(ListContainerScanResultsResponse response) {
                return response.getContainerScanResultSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListContainerScanTargetsResponse> listContainerScanTargetsResponseIterator(final ListContainerScanTargetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListContainerScanTargetsRequest.Builder>(){

            @Override
            public ListContainerScanTargetsRequest.Builder get() {
                return ListContainerScanTargetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerScanTargetsResponse, String>(){

            @Override
            public String apply(ListContainerScanTargetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerScanTargetsRequest.Builder>, ListContainerScanTargetsRequest>(){

            @Override
            public ListContainerScanTargetsRequest apply(RequestBuilderAndToken<ListContainerScanTargetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListContainerScanTargetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerScanTargetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListContainerScanTargetsRequest, ListContainerScanTargetsResponse>(){

            @Override
            public ListContainerScanTargetsResponse apply(ListContainerScanTargetsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listContainerScanTargets(request);
            }
        });
    }

    public Iterable<ContainerScanTargetSummary> listContainerScanTargetsRecordIterator(final ListContainerScanTargetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListContainerScanTargetsRequest.Builder>(){

            @Override
            public ListContainerScanTargetsRequest.Builder get() {
                return ListContainerScanTargetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerScanTargetsResponse, String>(){

            @Override
            public String apply(ListContainerScanTargetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerScanTargetsRequest.Builder>, ListContainerScanTargetsRequest>(){

            @Override
            public ListContainerScanTargetsRequest apply(RequestBuilderAndToken<ListContainerScanTargetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListContainerScanTargetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerScanTargetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListContainerScanTargetsRequest, ListContainerScanTargetsResponse>(){

            @Override
            public ListContainerScanTargetsResponse apply(ListContainerScanTargetsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listContainerScanTargets(request);
            }
        }, (Function)new Function<ListContainerScanTargetsResponse, List<ContainerScanTargetSummary>>(){

            @Override
            public List<ContainerScanTargetSummary> apply(ListContainerScanTargetsResponse response) {
                return response.getContainerScanTargetSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListHostAgentScanResultsResponse> listHostAgentScanResultsResponseIterator(final ListHostAgentScanResultsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHostAgentScanResultsRequest.Builder>(){

            @Override
            public ListHostAgentScanResultsRequest.Builder get() {
                return ListHostAgentScanResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHostAgentScanResultsResponse, String>(){

            @Override
            public String apply(ListHostAgentScanResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHostAgentScanResultsRequest.Builder>, ListHostAgentScanResultsRequest>(){

            @Override
            public ListHostAgentScanResultsRequest apply(RequestBuilderAndToken<ListHostAgentScanResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHostAgentScanResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHostAgentScanResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHostAgentScanResultsRequest, ListHostAgentScanResultsResponse>(){

            @Override
            public ListHostAgentScanResultsResponse apply(ListHostAgentScanResultsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listHostAgentScanResults(request);
            }
        });
    }

    public Iterable<HostAgentScanResultSummary> listHostAgentScanResultsRecordIterator(final ListHostAgentScanResultsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHostAgentScanResultsRequest.Builder>(){

            @Override
            public ListHostAgentScanResultsRequest.Builder get() {
                return ListHostAgentScanResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHostAgentScanResultsResponse, String>(){

            @Override
            public String apply(ListHostAgentScanResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHostAgentScanResultsRequest.Builder>, ListHostAgentScanResultsRequest>(){

            @Override
            public ListHostAgentScanResultsRequest apply(RequestBuilderAndToken<ListHostAgentScanResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHostAgentScanResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHostAgentScanResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHostAgentScanResultsRequest, ListHostAgentScanResultsResponse>(){

            @Override
            public ListHostAgentScanResultsResponse apply(ListHostAgentScanResultsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listHostAgentScanResults(request);
            }
        }, (Function)new Function<ListHostAgentScanResultsResponse, List<HostAgentScanResultSummary>>(){

            @Override
            public List<HostAgentScanResultSummary> apply(ListHostAgentScanResultsResponse response) {
                return response.getHostAgentScanResultSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListHostCisBenchmarkScanResultsResponse> listHostCisBenchmarkScanResultsResponseIterator(final ListHostCisBenchmarkScanResultsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHostCisBenchmarkScanResultsRequest.Builder>(){

            @Override
            public ListHostCisBenchmarkScanResultsRequest.Builder get() {
                return ListHostCisBenchmarkScanResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHostCisBenchmarkScanResultsResponse, String>(){

            @Override
            public String apply(ListHostCisBenchmarkScanResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHostCisBenchmarkScanResultsRequest.Builder>, ListHostCisBenchmarkScanResultsRequest>(){

            @Override
            public ListHostCisBenchmarkScanResultsRequest apply(RequestBuilderAndToken<ListHostCisBenchmarkScanResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHostCisBenchmarkScanResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHostCisBenchmarkScanResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHostCisBenchmarkScanResultsRequest, ListHostCisBenchmarkScanResultsResponse>(){

            @Override
            public ListHostCisBenchmarkScanResultsResponse apply(ListHostCisBenchmarkScanResultsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listHostCisBenchmarkScanResults(request);
            }
        });
    }

    public Iterable<HostCisBenchmarkScanResultSummary> listHostCisBenchmarkScanResultsRecordIterator(final ListHostCisBenchmarkScanResultsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHostCisBenchmarkScanResultsRequest.Builder>(){

            @Override
            public ListHostCisBenchmarkScanResultsRequest.Builder get() {
                return ListHostCisBenchmarkScanResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHostCisBenchmarkScanResultsResponse, String>(){

            @Override
            public String apply(ListHostCisBenchmarkScanResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHostCisBenchmarkScanResultsRequest.Builder>, ListHostCisBenchmarkScanResultsRequest>(){

            @Override
            public ListHostCisBenchmarkScanResultsRequest apply(RequestBuilderAndToken<ListHostCisBenchmarkScanResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHostCisBenchmarkScanResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHostCisBenchmarkScanResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHostCisBenchmarkScanResultsRequest, ListHostCisBenchmarkScanResultsResponse>(){

            @Override
            public ListHostCisBenchmarkScanResultsResponse apply(ListHostCisBenchmarkScanResultsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listHostCisBenchmarkScanResults(request);
            }
        }, (Function)new Function<ListHostCisBenchmarkScanResultsResponse, List<HostCisBenchmarkScanResultSummary>>(){

            @Override
            public List<HostCisBenchmarkScanResultSummary> apply(ListHostCisBenchmarkScanResultsResponse response) {
                return response.getHostCisBenchmarkScanResultSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListHostEndpointProtectionScanResultsResponse> listHostEndpointProtectionScanResultsResponseIterator(final ListHostEndpointProtectionScanResultsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHostEndpointProtectionScanResultsRequest.Builder>(){

            @Override
            public ListHostEndpointProtectionScanResultsRequest.Builder get() {
                return ListHostEndpointProtectionScanResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHostEndpointProtectionScanResultsResponse, String>(){

            @Override
            public String apply(ListHostEndpointProtectionScanResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHostEndpointProtectionScanResultsRequest.Builder>, ListHostEndpointProtectionScanResultsRequest>(){

            @Override
            public ListHostEndpointProtectionScanResultsRequest apply(RequestBuilderAndToken<ListHostEndpointProtectionScanResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHostEndpointProtectionScanResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHostEndpointProtectionScanResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHostEndpointProtectionScanResultsRequest, ListHostEndpointProtectionScanResultsResponse>(){

            @Override
            public ListHostEndpointProtectionScanResultsResponse apply(ListHostEndpointProtectionScanResultsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listHostEndpointProtectionScanResults(request);
            }
        });
    }

    public Iterable<HostEndpointProtectionScanResultSummary> listHostEndpointProtectionScanResultsRecordIterator(final ListHostEndpointProtectionScanResultsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHostEndpointProtectionScanResultsRequest.Builder>(){

            @Override
            public ListHostEndpointProtectionScanResultsRequest.Builder get() {
                return ListHostEndpointProtectionScanResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHostEndpointProtectionScanResultsResponse, String>(){

            @Override
            public String apply(ListHostEndpointProtectionScanResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHostEndpointProtectionScanResultsRequest.Builder>, ListHostEndpointProtectionScanResultsRequest>(){

            @Override
            public ListHostEndpointProtectionScanResultsRequest apply(RequestBuilderAndToken<ListHostEndpointProtectionScanResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHostEndpointProtectionScanResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHostEndpointProtectionScanResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHostEndpointProtectionScanResultsRequest, ListHostEndpointProtectionScanResultsResponse>(){

            @Override
            public ListHostEndpointProtectionScanResultsResponse apply(ListHostEndpointProtectionScanResultsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listHostEndpointProtectionScanResults(request);
            }
        }, (Function)new Function<ListHostEndpointProtectionScanResultsResponse, List<HostEndpointProtectionScanResultSummary>>(){

            @Override
            public List<HostEndpointProtectionScanResultSummary> apply(ListHostEndpointProtectionScanResultsResponse response) {
                return response.getHostEndpointProtectionScanResultSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListHostPortScanResultsResponse> listHostPortScanResultsResponseIterator(final ListHostPortScanResultsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHostPortScanResultsRequest.Builder>(){

            @Override
            public ListHostPortScanResultsRequest.Builder get() {
                return ListHostPortScanResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHostPortScanResultsResponse, String>(){

            @Override
            public String apply(ListHostPortScanResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHostPortScanResultsRequest.Builder>, ListHostPortScanResultsRequest>(){

            @Override
            public ListHostPortScanResultsRequest apply(RequestBuilderAndToken<ListHostPortScanResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHostPortScanResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHostPortScanResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHostPortScanResultsRequest, ListHostPortScanResultsResponse>(){

            @Override
            public ListHostPortScanResultsResponse apply(ListHostPortScanResultsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listHostPortScanResults(request);
            }
        });
    }

    public Iterable<HostPortScanResultSummary> listHostPortScanResultsRecordIterator(final ListHostPortScanResultsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHostPortScanResultsRequest.Builder>(){

            @Override
            public ListHostPortScanResultsRequest.Builder get() {
                return ListHostPortScanResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHostPortScanResultsResponse, String>(){

            @Override
            public String apply(ListHostPortScanResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHostPortScanResultsRequest.Builder>, ListHostPortScanResultsRequest>(){

            @Override
            public ListHostPortScanResultsRequest apply(RequestBuilderAndToken<ListHostPortScanResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHostPortScanResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHostPortScanResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHostPortScanResultsRequest, ListHostPortScanResultsResponse>(){

            @Override
            public ListHostPortScanResultsResponse apply(ListHostPortScanResultsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listHostPortScanResults(request);
            }
        }, (Function)new Function<ListHostPortScanResultsResponse, List<HostPortScanResultSummary>>(){

            @Override
            public List<HostPortScanResultSummary> apply(ListHostPortScanResultsResponse response) {
                return response.getHostPortScanResultSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListHostScanRecipesResponse> listHostScanRecipesResponseIterator(final ListHostScanRecipesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHostScanRecipesRequest.Builder>(){

            @Override
            public ListHostScanRecipesRequest.Builder get() {
                return ListHostScanRecipesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHostScanRecipesResponse, String>(){

            @Override
            public String apply(ListHostScanRecipesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHostScanRecipesRequest.Builder>, ListHostScanRecipesRequest>(){

            @Override
            public ListHostScanRecipesRequest apply(RequestBuilderAndToken<ListHostScanRecipesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHostScanRecipesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHostScanRecipesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHostScanRecipesRequest, ListHostScanRecipesResponse>(){

            @Override
            public ListHostScanRecipesResponse apply(ListHostScanRecipesRequest request) {
                return VulnerabilityScanningPaginators.this.client.listHostScanRecipes(request);
            }
        });
    }

    public Iterable<HostScanRecipeSummary> listHostScanRecipesRecordIterator(final ListHostScanRecipesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHostScanRecipesRequest.Builder>(){

            @Override
            public ListHostScanRecipesRequest.Builder get() {
                return ListHostScanRecipesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHostScanRecipesResponse, String>(){

            @Override
            public String apply(ListHostScanRecipesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHostScanRecipesRequest.Builder>, ListHostScanRecipesRequest>(){

            @Override
            public ListHostScanRecipesRequest apply(RequestBuilderAndToken<ListHostScanRecipesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHostScanRecipesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHostScanRecipesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHostScanRecipesRequest, ListHostScanRecipesResponse>(){

            @Override
            public ListHostScanRecipesResponse apply(ListHostScanRecipesRequest request) {
                return VulnerabilityScanningPaginators.this.client.listHostScanRecipes(request);
            }
        }, (Function)new Function<ListHostScanRecipesResponse, List<HostScanRecipeSummary>>(){

            @Override
            public List<HostScanRecipeSummary> apply(ListHostScanRecipesResponse response) {
                return response.getHostScanRecipeSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListHostScanTargetErrorsResponse> listHostScanTargetErrorsResponseIterator(final ListHostScanTargetErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHostScanTargetErrorsRequest.Builder>(){

            @Override
            public ListHostScanTargetErrorsRequest.Builder get() {
                return ListHostScanTargetErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHostScanTargetErrorsResponse, String>(){

            @Override
            public String apply(ListHostScanTargetErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHostScanTargetErrorsRequest.Builder>, ListHostScanTargetErrorsRequest>(){

            @Override
            public ListHostScanTargetErrorsRequest apply(RequestBuilderAndToken<ListHostScanTargetErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHostScanTargetErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHostScanTargetErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHostScanTargetErrorsRequest, ListHostScanTargetErrorsResponse>(){

            @Override
            public ListHostScanTargetErrorsResponse apply(ListHostScanTargetErrorsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listHostScanTargetErrors(request);
            }
        });
    }

    public Iterable<HostScanTargetErrorSummary> listHostScanTargetErrorsRecordIterator(final ListHostScanTargetErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHostScanTargetErrorsRequest.Builder>(){

            @Override
            public ListHostScanTargetErrorsRequest.Builder get() {
                return ListHostScanTargetErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHostScanTargetErrorsResponse, String>(){

            @Override
            public String apply(ListHostScanTargetErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHostScanTargetErrorsRequest.Builder>, ListHostScanTargetErrorsRequest>(){

            @Override
            public ListHostScanTargetErrorsRequest apply(RequestBuilderAndToken<ListHostScanTargetErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHostScanTargetErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHostScanTargetErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHostScanTargetErrorsRequest, ListHostScanTargetErrorsResponse>(){

            @Override
            public ListHostScanTargetErrorsResponse apply(ListHostScanTargetErrorsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listHostScanTargetErrors(request);
            }
        }, (Function)new Function<ListHostScanTargetErrorsResponse, List<HostScanTargetErrorSummary>>(){

            @Override
            public List<HostScanTargetErrorSummary> apply(ListHostScanTargetErrorsResponse response) {
                return response.getHostScanTargetErrorSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListHostScanTargetsResponse> listHostScanTargetsResponseIterator(final ListHostScanTargetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHostScanTargetsRequest.Builder>(){

            @Override
            public ListHostScanTargetsRequest.Builder get() {
                return ListHostScanTargetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHostScanTargetsResponse, String>(){

            @Override
            public String apply(ListHostScanTargetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHostScanTargetsRequest.Builder>, ListHostScanTargetsRequest>(){

            @Override
            public ListHostScanTargetsRequest apply(RequestBuilderAndToken<ListHostScanTargetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHostScanTargetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHostScanTargetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHostScanTargetsRequest, ListHostScanTargetsResponse>(){

            @Override
            public ListHostScanTargetsResponse apply(ListHostScanTargetsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listHostScanTargets(request);
            }
        });
    }

    public Iterable<HostScanTargetSummary> listHostScanTargetsRecordIterator(final ListHostScanTargetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHostScanTargetsRequest.Builder>(){

            @Override
            public ListHostScanTargetsRequest.Builder get() {
                return ListHostScanTargetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHostScanTargetsResponse, String>(){

            @Override
            public String apply(ListHostScanTargetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHostScanTargetsRequest.Builder>, ListHostScanTargetsRequest>(){

            @Override
            public ListHostScanTargetsRequest apply(RequestBuilderAndToken<ListHostScanTargetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHostScanTargetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHostScanTargetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHostScanTargetsRequest, ListHostScanTargetsResponse>(){

            @Override
            public ListHostScanTargetsResponse apply(ListHostScanTargetsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listHostScanTargets(request);
            }
        }, (Function)new Function<ListHostScanTargetsResponse, List<HostScanTargetSummary>>(){

            @Override
            public List<HostScanTargetSummary> apply(ListHostScanTargetsResponse response) {
                return response.getHostScanTargetSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListHostVulnerabilitiesResponse> listHostVulnerabilitiesResponseIterator(final ListHostVulnerabilitiesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHostVulnerabilitiesRequest.Builder>(){

            @Override
            public ListHostVulnerabilitiesRequest.Builder get() {
                return ListHostVulnerabilitiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHostVulnerabilitiesResponse, String>(){

            @Override
            public String apply(ListHostVulnerabilitiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHostVulnerabilitiesRequest.Builder>, ListHostVulnerabilitiesRequest>(){

            @Override
            public ListHostVulnerabilitiesRequest apply(RequestBuilderAndToken<ListHostVulnerabilitiesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHostVulnerabilitiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHostVulnerabilitiesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHostVulnerabilitiesRequest, ListHostVulnerabilitiesResponse>(){

            @Override
            public ListHostVulnerabilitiesResponse apply(ListHostVulnerabilitiesRequest request) {
                return VulnerabilityScanningPaginators.this.client.listHostVulnerabilities(request);
            }
        });
    }

    public Iterable<HostVulnerabilitySummary> listHostVulnerabilitiesRecordIterator(final ListHostVulnerabilitiesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHostVulnerabilitiesRequest.Builder>(){

            @Override
            public ListHostVulnerabilitiesRequest.Builder get() {
                return ListHostVulnerabilitiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHostVulnerabilitiesResponse, String>(){

            @Override
            public String apply(ListHostVulnerabilitiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHostVulnerabilitiesRequest.Builder>, ListHostVulnerabilitiesRequest>(){

            @Override
            public ListHostVulnerabilitiesRequest apply(RequestBuilderAndToken<ListHostVulnerabilitiesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHostVulnerabilitiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHostVulnerabilitiesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHostVulnerabilitiesRequest, ListHostVulnerabilitiesResponse>(){

            @Override
            public ListHostVulnerabilitiesResponse apply(ListHostVulnerabilitiesRequest request) {
                return VulnerabilityScanningPaginators.this.client.listHostVulnerabilities(request);
            }
        }, (Function)new Function<ListHostVulnerabilitiesResponse, List<HostVulnerabilitySummary>>(){

            @Override
            public List<HostVulnerabilitySummary> apply(ListHostVulnerabilitiesResponse response) {
                return response.getHostVulnerabilitySummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListHostVulnerabilityImpactedHostsResponse> listHostVulnerabilityImpactedHostsResponseIterator(final ListHostVulnerabilityImpactedHostsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHostVulnerabilityImpactedHostsRequest.Builder>(){

            @Override
            public ListHostVulnerabilityImpactedHostsRequest.Builder get() {
                return ListHostVulnerabilityImpactedHostsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHostVulnerabilityImpactedHostsResponse, String>(){

            @Override
            public String apply(ListHostVulnerabilityImpactedHostsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHostVulnerabilityImpactedHostsRequest.Builder>, ListHostVulnerabilityImpactedHostsRequest>(){

            @Override
            public ListHostVulnerabilityImpactedHostsRequest apply(RequestBuilderAndToken<ListHostVulnerabilityImpactedHostsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHostVulnerabilityImpactedHostsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHostVulnerabilityImpactedHostsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHostVulnerabilityImpactedHostsRequest, ListHostVulnerabilityImpactedHostsResponse>(){

            @Override
            public ListHostVulnerabilityImpactedHostsResponse apply(ListHostVulnerabilityImpactedHostsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listHostVulnerabilityImpactedHosts(request);
            }
        });
    }

    public Iterable<HostVulnerabilityImpactedHostSummary> listHostVulnerabilityImpactedHostsRecordIterator(final ListHostVulnerabilityImpactedHostsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHostVulnerabilityImpactedHostsRequest.Builder>(){

            @Override
            public ListHostVulnerabilityImpactedHostsRequest.Builder get() {
                return ListHostVulnerabilityImpactedHostsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHostVulnerabilityImpactedHostsResponse, String>(){

            @Override
            public String apply(ListHostVulnerabilityImpactedHostsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHostVulnerabilityImpactedHostsRequest.Builder>, ListHostVulnerabilityImpactedHostsRequest>(){

            @Override
            public ListHostVulnerabilityImpactedHostsRequest apply(RequestBuilderAndToken<ListHostVulnerabilityImpactedHostsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHostVulnerabilityImpactedHostsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHostVulnerabilityImpactedHostsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHostVulnerabilityImpactedHostsRequest, ListHostVulnerabilityImpactedHostsResponse>(){

            @Override
            public ListHostVulnerabilityImpactedHostsResponse apply(ListHostVulnerabilityImpactedHostsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listHostVulnerabilityImpactedHosts(request);
            }
        }, (Function)new Function<ListHostVulnerabilityImpactedHostsResponse, List<HostVulnerabilityImpactedHostSummary>>(){

            @Override
            public List<HostVulnerabilityImpactedHostSummary> apply(ListHostVulnerabilityImpactedHostsResponse response) {
                return response.getHostVulnerabilityImpactedHostSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListVulnerabilitiesResponse> listVulnerabilitiesResponseIterator(final ListVulnerabilitiesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListVulnerabilitiesRequest.Builder>(){

            @Override
            public ListVulnerabilitiesRequest.Builder get() {
                return ListVulnerabilitiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVulnerabilitiesResponse, String>(){

            @Override
            public String apply(ListVulnerabilitiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVulnerabilitiesRequest.Builder>, ListVulnerabilitiesRequest>(){

            @Override
            public ListVulnerabilitiesRequest apply(RequestBuilderAndToken<ListVulnerabilitiesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVulnerabilitiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVulnerabilitiesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVulnerabilitiesRequest, ListVulnerabilitiesResponse>(){

            @Override
            public ListVulnerabilitiesResponse apply(ListVulnerabilitiesRequest request) {
                return VulnerabilityScanningPaginators.this.client.listVulnerabilities(request);
            }
        });
    }

    public Iterable<VulnerabilitySummary> listVulnerabilitiesRecordIterator(final ListVulnerabilitiesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListVulnerabilitiesRequest.Builder>(){

            @Override
            public ListVulnerabilitiesRequest.Builder get() {
                return ListVulnerabilitiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVulnerabilitiesResponse, String>(){

            @Override
            public String apply(ListVulnerabilitiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVulnerabilitiesRequest.Builder>, ListVulnerabilitiesRequest>(){

            @Override
            public ListVulnerabilitiesRequest apply(RequestBuilderAndToken<ListVulnerabilitiesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVulnerabilitiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVulnerabilitiesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVulnerabilitiesRequest, ListVulnerabilitiesResponse>(){

            @Override
            public ListVulnerabilitiesResponse apply(ListVulnerabilitiesRequest request) {
                return VulnerabilityScanningPaginators.this.client.listVulnerabilities(request);
            }
        }, (Function)new Function<ListVulnerabilitiesResponse, List<VulnerabilitySummary>>(){

            @Override
            public List<VulnerabilitySummary> apply(ListVulnerabilitiesResponse response) {
                return response.getVulnerabilitySummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListVulnerabilityImpactedContainersResponse> listVulnerabilityImpactedContainersResponseIterator(final ListVulnerabilityImpactedContainersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListVulnerabilityImpactedContainersRequest.Builder>(){

            @Override
            public ListVulnerabilityImpactedContainersRequest.Builder get() {
                return ListVulnerabilityImpactedContainersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVulnerabilityImpactedContainersResponse, String>(){

            @Override
            public String apply(ListVulnerabilityImpactedContainersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVulnerabilityImpactedContainersRequest.Builder>, ListVulnerabilityImpactedContainersRequest>(){

            @Override
            public ListVulnerabilityImpactedContainersRequest apply(RequestBuilderAndToken<ListVulnerabilityImpactedContainersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVulnerabilityImpactedContainersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVulnerabilityImpactedContainersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVulnerabilityImpactedContainersRequest, ListVulnerabilityImpactedContainersResponse>(){

            @Override
            public ListVulnerabilityImpactedContainersResponse apply(ListVulnerabilityImpactedContainersRequest request) {
                return VulnerabilityScanningPaginators.this.client.listVulnerabilityImpactedContainers(request);
            }
        });
    }

    public Iterable<VulnerabilityImpactedContainerSummary> listVulnerabilityImpactedContainersRecordIterator(final ListVulnerabilityImpactedContainersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListVulnerabilityImpactedContainersRequest.Builder>(){

            @Override
            public ListVulnerabilityImpactedContainersRequest.Builder get() {
                return ListVulnerabilityImpactedContainersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVulnerabilityImpactedContainersResponse, String>(){

            @Override
            public String apply(ListVulnerabilityImpactedContainersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVulnerabilityImpactedContainersRequest.Builder>, ListVulnerabilityImpactedContainersRequest>(){

            @Override
            public ListVulnerabilityImpactedContainersRequest apply(RequestBuilderAndToken<ListVulnerabilityImpactedContainersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVulnerabilityImpactedContainersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVulnerabilityImpactedContainersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVulnerabilityImpactedContainersRequest, ListVulnerabilityImpactedContainersResponse>(){

            @Override
            public ListVulnerabilityImpactedContainersResponse apply(ListVulnerabilityImpactedContainersRequest request) {
                return VulnerabilityScanningPaginators.this.client.listVulnerabilityImpactedContainers(request);
            }
        }, (Function)new Function<ListVulnerabilityImpactedContainersResponse, List<VulnerabilityImpactedContainerSummary>>(){

            @Override
            public List<VulnerabilityImpactedContainerSummary> apply(ListVulnerabilityImpactedContainersResponse response) {
                return response.getVulnerabilityImpactedContainerSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListVulnerabilityImpactedHostsResponse> listVulnerabilityImpactedHostsResponseIterator(final ListVulnerabilityImpactedHostsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListVulnerabilityImpactedHostsRequest.Builder>(){

            @Override
            public ListVulnerabilityImpactedHostsRequest.Builder get() {
                return ListVulnerabilityImpactedHostsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVulnerabilityImpactedHostsResponse, String>(){

            @Override
            public String apply(ListVulnerabilityImpactedHostsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVulnerabilityImpactedHostsRequest.Builder>, ListVulnerabilityImpactedHostsRequest>(){

            @Override
            public ListVulnerabilityImpactedHostsRequest apply(RequestBuilderAndToken<ListVulnerabilityImpactedHostsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVulnerabilityImpactedHostsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVulnerabilityImpactedHostsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVulnerabilityImpactedHostsRequest, ListVulnerabilityImpactedHostsResponse>(){

            @Override
            public ListVulnerabilityImpactedHostsResponse apply(ListVulnerabilityImpactedHostsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listVulnerabilityImpactedHosts(request);
            }
        });
    }

    public Iterable<VulnerabilityImpactedHostSummary> listVulnerabilityImpactedHostsRecordIterator(final ListVulnerabilityImpactedHostsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListVulnerabilityImpactedHostsRequest.Builder>(){

            @Override
            public ListVulnerabilityImpactedHostsRequest.Builder get() {
                return ListVulnerabilityImpactedHostsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVulnerabilityImpactedHostsResponse, String>(){

            @Override
            public String apply(ListVulnerabilityImpactedHostsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVulnerabilityImpactedHostsRequest.Builder>, ListVulnerabilityImpactedHostsRequest>(){

            @Override
            public ListVulnerabilityImpactedHostsRequest apply(RequestBuilderAndToken<ListVulnerabilityImpactedHostsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVulnerabilityImpactedHostsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVulnerabilityImpactedHostsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVulnerabilityImpactedHostsRequest, ListVulnerabilityImpactedHostsResponse>(){

            @Override
            public ListVulnerabilityImpactedHostsResponse apply(ListVulnerabilityImpactedHostsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listVulnerabilityImpactedHosts(request);
            }
        }, (Function)new Function<ListVulnerabilityImpactedHostsResponse, List<VulnerabilityImpactedHostSummary>>(){

            @Override
            public List<VulnerabilityImpactedHostSummary> apply(ListVulnerabilityImpactedHostsResponse response) {
                return response.getVulnerabilityImpactedHostSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequest> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return VulnerabilityScanningPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequest>>(){

            @Override
            public List<WorkRequest> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestCollection().getItems();
            }
        });
    }
}

