/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.vulnerabilityscanning.VulnerabilityScanning;
import com.oracle.bmc.vulnerabilityscanning.VulnerabilityScanningAsyncClient;
import com.oracle.bmc.vulnerabilityscanning.VulnerabilityScanningPaginators;
import com.oracle.bmc.vulnerabilityscanning.VulnerabilityScanningWaiters;
import com.oracle.bmc.vulnerabilityscanning.model.ContainerScanRecipe;
import com.oracle.bmc.vulnerabilityscanning.model.ContainerScanRecipeSummaryCollection;
import com.oracle.bmc.vulnerabilityscanning.model.ContainerScanResult;
import com.oracle.bmc.vulnerabilityscanning.model.ContainerScanResultSummaryCollection;
import com.oracle.bmc.vulnerabilityscanning.model.ContainerScanTarget;
import com.oracle.bmc.vulnerabilityscanning.model.ContainerScanTargetSummaryCollection;
import com.oracle.bmc.vulnerabilityscanning.model.HostAgentScanResult;
import com.oracle.bmc.vulnerabilityscanning.model.HostAgentScanResultSummaryCollection;
import com.oracle.bmc.vulnerabilityscanning.model.HostCisBenchmarkScanResult;
import com.oracle.bmc.vulnerabilityscanning.model.HostCisBenchmarkScanResultSummaryCollection;
import com.oracle.bmc.vulnerabilityscanning.model.HostEndpointProtectionScanResult;
import com.oracle.bmc.vulnerabilityscanning.model.HostEndpointProtectionScanResultSummaryCollection;
import com.oracle.bmc.vulnerabilityscanning.model.HostPortScanResult;
import com.oracle.bmc.vulnerabilityscanning.model.HostPortScanResultSummaryCollection;
import com.oracle.bmc.vulnerabilityscanning.model.HostScanRecipe;
import com.oracle.bmc.vulnerabilityscanning.model.HostScanRecipeSummaryCollection;
import com.oracle.bmc.vulnerabilityscanning.model.HostScanTarget;
import com.oracle.bmc.vulnerabilityscanning.model.HostScanTargetErrorSummaryCollection;
import com.oracle.bmc.vulnerabilityscanning.model.HostScanTargetSummaryCollection;
import com.oracle.bmc.vulnerabilityscanning.model.HostVulnerability;
import com.oracle.bmc.vulnerabilityscanning.model.HostVulnerabilityImpactedHostSummaryCollection;
import com.oracle.bmc.vulnerabilityscanning.model.HostVulnerabilitySummaryCollection;
import com.oracle.bmc.vulnerabilityscanning.model.Vulnerability;
import com.oracle.bmc.vulnerabilityscanning.model.VulnerabilityImpactedContainerSummaryCollection;
import com.oracle.bmc.vulnerabilityscanning.model.VulnerabilityImpactedHostSummaryCollection;
import com.oracle.bmc.vulnerabilityscanning.model.VulnerabilitySummaryCollection;
import com.oracle.bmc.vulnerabilityscanning.model.WorkRequest;
import com.oracle.bmc.vulnerabilityscanning.model.WorkRequestCollection;
import com.oracle.bmc.vulnerabilityscanning.model.WorkRequestErrorCollection;
import com.oracle.bmc.vulnerabilityscanning.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.vulnerabilityscanning.requests.ChangeContainerScanRecipeCompartmentRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ChangeContainerScanResultCompartmentRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ChangeContainerScanTargetCompartmentRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ChangeHostAgentScanResultCompartmentRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ChangeHostCisBenchmarkScanResultCompartmentRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ChangeHostEndpointProtectionScanResultCompartmentRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ChangeHostPortScanResultCompartmentRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ChangeHostScanRecipeCompartmentRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ChangeHostScanTargetCompartmentRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.CreateContainerScanRecipeRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.CreateContainerScanTargetRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.CreateHostScanRecipeRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.CreateHostScanTargetRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.DeleteContainerScanRecipeRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.DeleteContainerScanResultRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.DeleteContainerScanTargetRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.DeleteHostAgentScanResultRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.DeleteHostCisBenchmarkScanResultRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.DeleteHostEndpointProtectionScanResultRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.DeleteHostPortScanResultRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.DeleteHostScanRecipeRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.DeleteHostScanTargetRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ExportHostAgentScanResultCsvRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ExportHostVulnerabilityCsvRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetContainerScanRecipeRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetContainerScanResultRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetContainerScanTargetRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetHostAgentScanResultRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetHostCisBenchmarkScanResultRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetHostEndpointProtectionScanResultRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetHostPortScanResultRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetHostScanRecipeRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetHostScanTargetRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetHostVulnerabilityRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetVulnerabilityRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetWorkRequestRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListContainerScanRecipesRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListContainerScanResultsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListContainerScanTargetsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListHostAgentScanResultsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListHostCisBenchmarkScanResultsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListHostEndpointProtectionScanResultsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListHostPortScanResultsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListHostScanRecipesRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListHostScanTargetErrorsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListHostScanTargetsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListHostVulnerabilitiesRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListHostVulnerabilityImpactedHostsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListVulnerabilitiesRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListVulnerabilityImpactedContainersRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListVulnerabilityImpactedHostsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.ListWorkRequestsRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.UpdateContainerScanRecipeRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.UpdateContainerScanTargetRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.UpdateHostScanRecipeRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.UpdateHostScanTargetRequest;
import com.oracle.bmc.vulnerabilityscanning.responses.ChangeContainerScanRecipeCompartmentResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ChangeContainerScanResultCompartmentResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ChangeContainerScanTargetCompartmentResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ChangeHostAgentScanResultCompartmentResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ChangeHostCisBenchmarkScanResultCompartmentResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ChangeHostEndpointProtectionScanResultCompartmentResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ChangeHostPortScanResultCompartmentResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ChangeHostScanRecipeCompartmentResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ChangeHostScanTargetCompartmentResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.CreateContainerScanRecipeResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.CreateContainerScanTargetResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.CreateHostScanRecipeResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.CreateHostScanTargetResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.DeleteContainerScanRecipeResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.DeleteContainerScanResultResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.DeleteContainerScanTargetResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.DeleteHostAgentScanResultResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.DeleteHostCisBenchmarkScanResultResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.DeleteHostEndpointProtectionScanResultResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.DeleteHostPortScanResultResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.DeleteHostScanRecipeResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.DeleteHostScanTargetResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ExportHostAgentScanResultCsvResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ExportHostVulnerabilityCsvResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetContainerScanRecipeResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetContainerScanResultResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetContainerScanTargetResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetHostAgentScanResultResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetHostCisBenchmarkScanResultResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetHostEndpointProtectionScanResultResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetHostPortScanResultResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetHostScanRecipeResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetHostScanTargetResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetHostVulnerabilityResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetVulnerabilityResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetWorkRequestResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListContainerScanRecipesResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListContainerScanResultsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListContainerScanTargetsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListHostAgentScanResultsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListHostCisBenchmarkScanResultsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListHostEndpointProtectionScanResultsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListHostPortScanResultsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListHostScanRecipesResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListHostScanTargetErrorsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListHostScanTargetsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListHostVulnerabilitiesResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListHostVulnerabilityImpactedHostsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListVulnerabilitiesResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListVulnerabilityImpactedContainersResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListVulnerabilityImpactedHostsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.ListWorkRequestsResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.UpdateContainerScanRecipeResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.UpdateContainerScanTargetResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.UpdateHostScanRecipeResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.UpdateHostScanTargetResponse;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VulnerabilityScanningClient
extends BaseSyncClient
implements VulnerabilityScanning {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("VULNERABILITYSCANNING").serviceEndpointPrefix("").serviceEndpointTemplate("https://vss-cp-api.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(VulnerabilityScanningAsyncClient.class);
    private final VulnerabilityScanningWaiters waiters;
    private final VulnerabilityScanningPaginators paginators;

    private VulnerabilityScanningClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("VulnerabilityScanning-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new VulnerabilityScanningWaiters(executorService, this);
        this.paginators = new VulnerabilityScanningPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeContainerScanRecipeCompartmentResponse changeContainerScanRecipeCompartment(ChangeContainerScanRecipeCompartmentRequest request) {
        Validate.notBlank((String)request.getContainerScanRecipeId(), (String)"containerScanRecipeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeContainerScanRecipeCompartmentDetails(), "changeContainerScanRecipeCompartmentDetails is required");
        return (ChangeContainerScanRecipeCompartmentResponse)this.clientCall(request, ChangeContainerScanRecipeCompartmentResponse::builder).logger(LOG, "changeContainerScanRecipeCompartment").serviceDetails("VulnerabilityScanning", "ChangeContainerScanRecipeCompartment", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanRecipe/ChangeContainerScanRecipeCompartment").method(Method.POST).requestBuilder(ChangeContainerScanRecipeCompartmentRequest::builder).basePath("/20210215").appendPathParam("containerScanRecipes").appendPathParam(request.getContainerScanRecipeId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeContainerScanRecipeCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeContainerScanResultCompartmentResponse changeContainerScanResultCompartment(ChangeContainerScanResultCompartmentRequest request) {
        Validate.notBlank((String)request.getContainerScanResultId(), (String)"containerScanResultId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeContainerScanResultCompartmentDetails(), "changeContainerScanResultCompartmentDetails is required");
        return (ChangeContainerScanResultCompartmentResponse)this.clientCall(request, ChangeContainerScanResultCompartmentResponse::builder).logger(LOG, "changeContainerScanResultCompartment").serviceDetails("VulnerabilityScanning", "ChangeContainerScanResultCompartment", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanResult/ChangeContainerScanResultCompartment").method(Method.POST).requestBuilder(ChangeContainerScanResultCompartmentRequest::builder).basePath("/20210215").appendPathParam("containerScanResults").appendPathParam(request.getContainerScanResultId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeContainerScanResultCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeContainerScanTargetCompartmentResponse changeContainerScanTargetCompartment(ChangeContainerScanTargetCompartmentRequest request) {
        Validate.notBlank((String)request.getContainerScanTargetId(), (String)"containerScanTargetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeContainerScanTargetCompartmentDetails(), "changeContainerScanTargetCompartmentDetails is required");
        return (ChangeContainerScanTargetCompartmentResponse)this.clientCall(request, ChangeContainerScanTargetCompartmentResponse::builder).logger(LOG, "changeContainerScanTargetCompartment").serviceDetails("VulnerabilityScanning", "ChangeContainerScanTargetCompartment", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanTarget/ChangeContainerScanTargetCompartment").method(Method.POST).requestBuilder(ChangeContainerScanTargetCompartmentRequest::builder).basePath("/20210215").appendPathParam("containerScanTargets").appendPathParam(request.getContainerScanTargetId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeContainerScanTargetCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeHostAgentScanResultCompartmentResponse changeHostAgentScanResultCompartment(ChangeHostAgentScanResultCompartmentRequest request) {
        Validate.notBlank((String)request.getHostAgentScanResultId(), (String)"hostAgentScanResultId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeHostAgentScanResultCompartmentDetails(), "changeHostAgentScanResultCompartmentDetails is required");
        return (ChangeHostAgentScanResultCompartmentResponse)this.clientCall(request, ChangeHostAgentScanResultCompartmentResponse::builder).logger(LOG, "changeHostAgentScanResultCompartment").serviceDetails("VulnerabilityScanning", "ChangeHostAgentScanResultCompartment", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostAgentScanResult/ChangeHostAgentScanResultCompartment").method(Method.POST).requestBuilder(ChangeHostAgentScanResultCompartmentRequest::builder).basePath("/20210215").appendPathParam("hostAgentScanResults").appendPathParam(request.getHostAgentScanResultId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeHostAgentScanResultCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeHostCisBenchmarkScanResultCompartmentResponse changeHostCisBenchmarkScanResultCompartment(ChangeHostCisBenchmarkScanResultCompartmentRequest request) {
        Validate.notBlank((String)request.getHostCisBenchmarkScanResultId(), (String)"hostCisBenchmarkScanResultId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeHostCisBenchmarkScanResultCompartmentDetails(), "changeHostCisBenchmarkScanResultCompartmentDetails is required");
        return (ChangeHostCisBenchmarkScanResultCompartmentResponse)this.clientCall(request, ChangeHostCisBenchmarkScanResultCompartmentResponse::builder).logger(LOG, "changeHostCisBenchmarkScanResultCompartment").serviceDetails("VulnerabilityScanning", "ChangeHostCisBenchmarkScanResultCompartment", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostCisBenchmarkScanResult/ChangeHostCisBenchmarkScanResultCompartment").method(Method.POST).requestBuilder(ChangeHostCisBenchmarkScanResultCompartmentRequest::builder).basePath("/20210215").appendPathParam("hostCisBenchmarkScanResults").appendPathParam(request.getHostCisBenchmarkScanResultId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeHostCisBenchmarkScanResultCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeHostEndpointProtectionScanResultCompartmentResponse changeHostEndpointProtectionScanResultCompartment(ChangeHostEndpointProtectionScanResultCompartmentRequest request) {
        Validate.notBlank((String)request.getHostEndpointProtectionScanResultId(), (String)"hostEndpointProtectionScanResultId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeHostEndpointProtectionScanResultCompartmentDetails(), "changeHostEndpointProtectionScanResultCompartmentDetails is required");
        return (ChangeHostEndpointProtectionScanResultCompartmentResponse)this.clientCall(request, ChangeHostEndpointProtectionScanResultCompartmentResponse::builder).logger(LOG, "changeHostEndpointProtectionScanResultCompartment").serviceDetails("VulnerabilityScanning", "ChangeHostEndpointProtectionScanResultCompartment", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostEndpointProtectionScanResult/ChangeHostEndpointProtectionScanResultCompartment").method(Method.POST).requestBuilder(ChangeHostEndpointProtectionScanResultCompartmentRequest::builder).basePath("/20210215").appendPathParam("hostEndpointProtectionScanResults").appendPathParam(request.getHostEndpointProtectionScanResultId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeHostEndpointProtectionScanResultCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeHostPortScanResultCompartmentResponse changeHostPortScanResultCompartment(ChangeHostPortScanResultCompartmentRequest request) {
        Validate.notBlank((String)request.getHostPortScanResultId(), (String)"hostPortScanResultId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeHostPortScanResultCompartmentDetails(), "changeHostPortScanResultCompartmentDetails is required");
        return (ChangeHostPortScanResultCompartmentResponse)this.clientCall(request, ChangeHostPortScanResultCompartmentResponse::builder).logger(LOG, "changeHostPortScanResultCompartment").serviceDetails("VulnerabilityScanning", "ChangeHostPortScanResultCompartment", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostPortScanResult/ChangeHostPortScanResultCompartment").method(Method.POST).requestBuilder(ChangeHostPortScanResultCompartmentRequest::builder).basePath("/20210215").appendPathParam("hostPortScanResults").appendPathParam(request.getHostPortScanResultId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeHostPortScanResultCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeHostScanRecipeCompartmentResponse changeHostScanRecipeCompartment(ChangeHostScanRecipeCompartmentRequest request) {
        Validate.notBlank((String)request.getHostScanRecipeId(), (String)"hostScanRecipeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeHostScanRecipeCompartmentDetails(), "changeHostScanRecipeCompartmentDetails is required");
        return (ChangeHostScanRecipeCompartmentResponse)this.clientCall(request, ChangeHostScanRecipeCompartmentResponse::builder).logger(LOG, "changeHostScanRecipeCompartment").serviceDetails("VulnerabilityScanning", "ChangeHostScanRecipeCompartment", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanRecipe/ChangeHostScanRecipeCompartment").method(Method.POST).requestBuilder(ChangeHostScanRecipeCompartmentRequest::builder).basePath("/20210215").appendPathParam("hostScanRecipes").appendPathParam(request.getHostScanRecipeId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeHostScanRecipeCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeHostScanTargetCompartmentResponse changeHostScanTargetCompartment(ChangeHostScanTargetCompartmentRequest request) {
        Validate.notBlank((String)request.getHostScanTargetId(), (String)"hostScanTargetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeHostScanTargetCompartmentDetails(), "changeHostScanTargetCompartmentDetails is required");
        return (ChangeHostScanTargetCompartmentResponse)this.clientCall(request, ChangeHostScanTargetCompartmentResponse::builder).logger(LOG, "changeHostScanTargetCompartment").serviceDetails("VulnerabilityScanning", "ChangeHostScanTargetCompartment", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanTarget/ChangeHostScanTargetCompartment").method(Method.POST).requestBuilder(ChangeHostScanTargetCompartmentRequest::builder).basePath("/20210215").appendPathParam("hostScanTargets").appendPathParam(request.getHostScanTargetId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeHostScanTargetCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateContainerScanRecipeResponse createContainerScanRecipe(CreateContainerScanRecipeRequest request) {
        Objects.requireNonNull(request.getCreateContainerScanRecipeDetails(), "createContainerScanRecipeDetails is required");
        return (CreateContainerScanRecipeResponse)this.clientCall(request, CreateContainerScanRecipeResponse::builder).logger(LOG, "createContainerScanRecipe").serviceDetails("VulnerabilityScanning", "CreateContainerScanRecipe", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanRecipe/CreateContainerScanRecipe").method(Method.POST).requestBuilder(CreateContainerScanRecipeRequest::builder).basePath("/20210215").appendPathParam("containerScanRecipes").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ContainerScanRecipe.class, CreateContainerScanRecipeResponse.Builder::containerScanRecipe).handleResponseHeaderString("etag", CreateContainerScanRecipeResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateContainerScanRecipeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateContainerScanRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateContainerScanTargetResponse createContainerScanTarget(CreateContainerScanTargetRequest request) {
        Objects.requireNonNull(request.getCreateContainerScanTargetDetails(), "createContainerScanTargetDetails is required");
        return (CreateContainerScanTargetResponse)this.clientCall(request, CreateContainerScanTargetResponse::builder).logger(LOG, "createContainerScanTarget").serviceDetails("VulnerabilityScanning", "CreateContainerScanTarget", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanTarget/CreateContainerScanTarget").method(Method.POST).requestBuilder(CreateContainerScanTargetRequest::builder).basePath("/20210215").appendPathParam("containerScanTargets").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ContainerScanTarget.class, CreateContainerScanTargetResponse.Builder::containerScanTarget).handleResponseHeaderString("etag", CreateContainerScanTargetResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateContainerScanTargetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateContainerScanTargetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateHostScanRecipeResponse createHostScanRecipe(CreateHostScanRecipeRequest request) {
        Objects.requireNonNull(request.getCreateHostScanRecipeDetails(), "createHostScanRecipeDetails is required");
        return (CreateHostScanRecipeResponse)this.clientCall(request, CreateHostScanRecipeResponse::builder).logger(LOG, "createHostScanRecipe").serviceDetails("VulnerabilityScanning", "CreateHostScanRecipe", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanRecipe/CreateHostScanRecipe").method(Method.POST).requestBuilder(CreateHostScanRecipeRequest::builder).basePath("/20210215").appendPathParam("hostScanRecipes").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(HostScanRecipe.class, CreateHostScanRecipeResponse.Builder::hostScanRecipe).handleResponseHeaderString("etag", CreateHostScanRecipeResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateHostScanRecipeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateHostScanRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateHostScanTargetResponse createHostScanTarget(CreateHostScanTargetRequest request) {
        Objects.requireNonNull(request.getCreateHostScanTargetDetails(), "createHostScanTargetDetails is required");
        return (CreateHostScanTargetResponse)this.clientCall(request, CreateHostScanTargetResponse::builder).logger(LOG, "createHostScanTarget").serviceDetails("VulnerabilityScanning", "CreateHostScanTarget", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanTarget/CreateHostScanTarget").method(Method.POST).requestBuilder(CreateHostScanTargetRequest::builder).basePath("/20210215").appendPathParam("hostScanTargets").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(HostScanTarget.class, CreateHostScanTargetResponse.Builder::hostScanTarget).handleResponseHeaderString("etag", CreateHostScanTargetResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateHostScanTargetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateHostScanTargetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteContainerScanRecipeResponse deleteContainerScanRecipe(DeleteContainerScanRecipeRequest request) {
        Validate.notBlank((String)request.getContainerScanRecipeId(), (String)"containerScanRecipeId must not be blank", (Object[])new Object[0]);
        return (DeleteContainerScanRecipeResponse)this.clientCall(request, DeleteContainerScanRecipeResponse::builder).logger(LOG, "deleteContainerScanRecipe").serviceDetails("VulnerabilityScanning", "DeleteContainerScanRecipe", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanRecipe/DeleteContainerScanRecipe").method(Method.DELETE).requestBuilder(DeleteContainerScanRecipeRequest::builder).basePath("/20210215").appendPathParam("containerScanRecipes").appendPathParam(request.getContainerScanRecipeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteContainerScanRecipeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteContainerScanRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteContainerScanResultResponse deleteContainerScanResult(DeleteContainerScanResultRequest request) {
        Validate.notBlank((String)request.getContainerScanResultId(), (String)"containerScanResultId must not be blank", (Object[])new Object[0]);
        return (DeleteContainerScanResultResponse)this.clientCall(request, DeleteContainerScanResultResponse::builder).logger(LOG, "deleteContainerScanResult").serviceDetails("VulnerabilityScanning", "DeleteContainerScanResult", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanResult/DeleteContainerScanResult").method(Method.DELETE).requestBuilder(DeleteContainerScanResultRequest::builder).basePath("/20210215").appendPathParam("containerScanResults").appendPathParam(request.getContainerScanResultId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteContainerScanResultResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteContainerScanResultResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteContainerScanTargetResponse deleteContainerScanTarget(DeleteContainerScanTargetRequest request) {
        Validate.notBlank((String)request.getContainerScanTargetId(), (String)"containerScanTargetId must not be blank", (Object[])new Object[0]);
        return (DeleteContainerScanTargetResponse)this.clientCall(request, DeleteContainerScanTargetResponse::builder).logger(LOG, "deleteContainerScanTarget").serviceDetails("VulnerabilityScanning", "DeleteContainerScanTarget", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanTarget/DeleteContainerScanTarget").method(Method.DELETE).requestBuilder(DeleteContainerScanTargetRequest::builder).basePath("/20210215").appendPathParam("containerScanTargets").appendPathParam(request.getContainerScanTargetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteContainerScanTargetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteContainerScanTargetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteHostAgentScanResultResponse deleteHostAgentScanResult(DeleteHostAgentScanResultRequest request) {
        Validate.notBlank((String)request.getHostAgentScanResultId(), (String)"hostAgentScanResultId must not be blank", (Object[])new Object[0]);
        return (DeleteHostAgentScanResultResponse)this.clientCall(request, DeleteHostAgentScanResultResponse::builder).logger(LOG, "deleteHostAgentScanResult").serviceDetails("VulnerabilityScanning", "DeleteHostAgentScanResult", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostAgentScanResult/DeleteHostAgentScanResult").method(Method.DELETE).requestBuilder(DeleteHostAgentScanResultRequest::builder).basePath("/20210215").appendPathParam("hostAgentScanResults").appendPathParam(request.getHostAgentScanResultId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteHostAgentScanResultResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteHostAgentScanResultResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteHostCisBenchmarkScanResultResponse deleteHostCisBenchmarkScanResult(DeleteHostCisBenchmarkScanResultRequest request) {
        Validate.notBlank((String)request.getHostCisBenchmarkScanResultId(), (String)"hostCisBenchmarkScanResultId must not be blank", (Object[])new Object[0]);
        return (DeleteHostCisBenchmarkScanResultResponse)this.clientCall(request, DeleteHostCisBenchmarkScanResultResponse::builder).logger(LOG, "deleteHostCisBenchmarkScanResult").serviceDetails("VulnerabilityScanning", "DeleteHostCisBenchmarkScanResult", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostCisBenchmarkScanResult/DeleteHostCisBenchmarkScanResult").method(Method.DELETE).requestBuilder(DeleteHostCisBenchmarkScanResultRequest::builder).basePath("/20210215").appendPathParam("hostCisBenchmarkScanResults").appendPathParam(request.getHostCisBenchmarkScanResultId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteHostCisBenchmarkScanResultResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteHostCisBenchmarkScanResultResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteHostEndpointProtectionScanResultResponse deleteHostEndpointProtectionScanResult(DeleteHostEndpointProtectionScanResultRequest request) {
        Validate.notBlank((String)request.getHostEndpointProtectionScanResultId(), (String)"hostEndpointProtectionScanResultId must not be blank", (Object[])new Object[0]);
        return (DeleteHostEndpointProtectionScanResultResponse)this.clientCall(request, DeleteHostEndpointProtectionScanResultResponse::builder).logger(LOG, "deleteHostEndpointProtectionScanResult").serviceDetails("VulnerabilityScanning", "DeleteHostEndpointProtectionScanResult", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostEndpointProtectionScanResult/DeleteHostEndpointProtectionScanResult").method(Method.DELETE).requestBuilder(DeleteHostEndpointProtectionScanResultRequest::builder).basePath("/20210215").appendPathParam("hostEndpointProtectionScanResults").appendPathParam(request.getHostEndpointProtectionScanResultId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteHostEndpointProtectionScanResultResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteHostEndpointProtectionScanResultResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteHostPortScanResultResponse deleteHostPortScanResult(DeleteHostPortScanResultRequest request) {
        Validate.notBlank((String)request.getHostPortScanResultId(), (String)"hostPortScanResultId must not be blank", (Object[])new Object[0]);
        return (DeleteHostPortScanResultResponse)this.clientCall(request, DeleteHostPortScanResultResponse::builder).logger(LOG, "deleteHostPortScanResult").serviceDetails("VulnerabilityScanning", "DeleteHostPortScanResult", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostPortScanResult/DeleteHostPortScanResult").method(Method.DELETE).requestBuilder(DeleteHostPortScanResultRequest::builder).basePath("/20210215").appendPathParam("hostPortScanResults").appendPathParam(request.getHostPortScanResultId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteHostPortScanResultResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteHostPortScanResultResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteHostScanRecipeResponse deleteHostScanRecipe(DeleteHostScanRecipeRequest request) {
        Validate.notBlank((String)request.getHostScanRecipeId(), (String)"hostScanRecipeId must not be blank", (Object[])new Object[0]);
        return (DeleteHostScanRecipeResponse)this.clientCall(request, DeleteHostScanRecipeResponse::builder).logger(LOG, "deleteHostScanRecipe").serviceDetails("VulnerabilityScanning", "DeleteHostScanRecipe", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanRecipe/DeleteHostScanRecipe").method(Method.DELETE).requestBuilder(DeleteHostScanRecipeRequest::builder).basePath("/20210215").appendPathParam("hostScanRecipes").appendPathParam(request.getHostScanRecipeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteHostScanRecipeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteHostScanRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteHostScanTargetResponse deleteHostScanTarget(DeleteHostScanTargetRequest request) {
        Validate.notBlank((String)request.getHostScanTargetId(), (String)"hostScanTargetId must not be blank", (Object[])new Object[0]);
        return (DeleteHostScanTargetResponse)this.clientCall(request, DeleteHostScanTargetResponse::builder).logger(LOG, "deleteHostScanTarget").serviceDetails("VulnerabilityScanning", "DeleteHostScanTarget", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanTarget/DeleteHostScanTarget").method(Method.DELETE).requestBuilder(DeleteHostScanTargetRequest::builder).basePath("/20210215").appendPathParam("hostScanTargets").appendPathParam(request.getHostScanTargetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteHostScanTargetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteHostScanTargetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ExportHostAgentScanResultCsvResponse exportHostAgentScanResultCsv(ExportHostAgentScanResultCsvRequest request) {
        Objects.requireNonNull(request.getExportHostAgentScanResultCsvDetails(), "exportHostAgentScanResultCsvDetails is required");
        return (ExportHostAgentScanResultCsvResponse)this.clientCall(request, ExportHostAgentScanResultCsvResponse::builder).logger(LOG, "exportHostAgentScanResultCsv").serviceDetails("VulnerabilityScanning", "ExportHostAgentScanResultCsv", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostAgentScanResult/ExportHostAgentScanResultCsv").method(Method.POST).requestBuilder(ExportHostAgentScanResultCsvRequest::builder).basePath("/20210215").appendPathParam("hostAgentScanResults").appendPathParam("actions").appendPathParam("exportCsv").accept(new String[]{"text/csv"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(InputStream.class, ExportHostAgentScanResultCsvResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", ExportHostAgentScanResultCsvResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ExportHostVulnerabilityCsvResponse exportHostVulnerabilityCsv(ExportHostVulnerabilityCsvRequest request) {
        Objects.requireNonNull(request.getExportHostVulnerabilityCsvDetails(), "exportHostVulnerabilityCsvDetails is required");
        return (ExportHostVulnerabilityCsvResponse)this.clientCall(request, ExportHostVulnerabilityCsvResponse::builder).logger(LOG, "exportHostVulnerabilityCsv").serviceDetails("VulnerabilityScanning", "ExportHostVulnerabilityCsv", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostVulnerability/ExportHostVulnerabilityCsv").method(Method.POST).requestBuilder(ExportHostVulnerabilityCsvRequest::builder).basePath("/20210215").appendPathParam("hostVulnerabilities").appendPathParam("actions").appendPathParam("exportCsv").accept(new String[]{"text/csv"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(InputStream.class, ExportHostVulnerabilityCsvResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", ExportHostVulnerabilityCsvResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetContainerScanRecipeResponse getContainerScanRecipe(GetContainerScanRecipeRequest request) {
        Validate.notBlank((String)request.getContainerScanRecipeId(), (String)"containerScanRecipeId must not be blank", (Object[])new Object[0]);
        return (GetContainerScanRecipeResponse)this.clientCall(request, GetContainerScanRecipeResponse::builder).logger(LOG, "getContainerScanRecipe").serviceDetails("VulnerabilityScanning", "GetContainerScanRecipe", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanRecipe/GetContainerScanRecipe").method(Method.GET).requestBuilder(GetContainerScanRecipeRequest::builder).basePath("/20210215").appendPathParam("containerScanRecipes").appendPathParam(request.getContainerScanRecipeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ContainerScanRecipe.class, GetContainerScanRecipeResponse.Builder::containerScanRecipe).handleResponseHeaderString("etag", GetContainerScanRecipeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetContainerScanRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetContainerScanResultResponse getContainerScanResult(GetContainerScanResultRequest request) {
        Validate.notBlank((String)request.getContainerScanResultId(), (String)"containerScanResultId must not be blank", (Object[])new Object[0]);
        return (GetContainerScanResultResponse)this.clientCall(request, GetContainerScanResultResponse::builder).logger(LOG, "getContainerScanResult").serviceDetails("VulnerabilityScanning", "GetContainerScanResult", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanResult/GetContainerScanResult").method(Method.GET).requestBuilder(GetContainerScanResultRequest::builder).basePath("/20210215").appendPathParam("containerScanResults").appendPathParam(request.getContainerScanResultId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ContainerScanResult.class, GetContainerScanResultResponse.Builder::containerScanResult).handleResponseHeaderString("etag", GetContainerScanResultResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetContainerScanResultResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetContainerScanTargetResponse getContainerScanTarget(GetContainerScanTargetRequest request) {
        Validate.notBlank((String)request.getContainerScanTargetId(), (String)"containerScanTargetId must not be blank", (Object[])new Object[0]);
        return (GetContainerScanTargetResponse)this.clientCall(request, GetContainerScanTargetResponse::builder).logger(LOG, "getContainerScanTarget").serviceDetails("VulnerabilityScanning", "GetContainerScanTarget", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanTarget/GetContainerScanTarget").method(Method.GET).requestBuilder(GetContainerScanTargetRequest::builder).basePath("/20210215").appendPathParam("containerScanTargets").appendPathParam(request.getContainerScanTargetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ContainerScanTarget.class, GetContainerScanTargetResponse.Builder::containerScanTarget).handleResponseHeaderString("etag", GetContainerScanTargetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetContainerScanTargetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetHostAgentScanResultResponse getHostAgentScanResult(GetHostAgentScanResultRequest request) {
        Validate.notBlank((String)request.getHostAgentScanResultId(), (String)"hostAgentScanResultId must not be blank", (Object[])new Object[0]);
        return (GetHostAgentScanResultResponse)this.clientCall(request, GetHostAgentScanResultResponse::builder).logger(LOG, "getHostAgentScanResult").serviceDetails("VulnerabilityScanning", "GetHostAgentScanResult", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostAgentScanResult/GetHostAgentScanResult").method(Method.GET).requestBuilder(GetHostAgentScanResultRequest::builder).basePath("/20210215").appendPathParam("hostAgentScanResults").appendPathParam(request.getHostAgentScanResultId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HostAgentScanResult.class, GetHostAgentScanResultResponse.Builder::hostAgentScanResult).handleResponseHeaderString("etag", GetHostAgentScanResultResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetHostAgentScanResultResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetHostCisBenchmarkScanResultResponse getHostCisBenchmarkScanResult(GetHostCisBenchmarkScanResultRequest request) {
        Validate.notBlank((String)request.getHostCisBenchmarkScanResultId(), (String)"hostCisBenchmarkScanResultId must not be blank", (Object[])new Object[0]);
        return (GetHostCisBenchmarkScanResultResponse)this.clientCall(request, GetHostCisBenchmarkScanResultResponse::builder).logger(LOG, "getHostCisBenchmarkScanResult").serviceDetails("VulnerabilityScanning", "GetHostCisBenchmarkScanResult", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostCisBenchmarkScanResult/GetHostCisBenchmarkScanResult").method(Method.GET).requestBuilder(GetHostCisBenchmarkScanResultRequest::builder).basePath("/20210215").appendPathParam("hostCisBenchmarkScanResults").appendPathParam(request.getHostCisBenchmarkScanResultId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HostCisBenchmarkScanResult.class, GetHostCisBenchmarkScanResultResponse.Builder::hostCisBenchmarkScanResult).handleResponseHeaderString("etag", GetHostCisBenchmarkScanResultResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetHostCisBenchmarkScanResultResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetHostEndpointProtectionScanResultResponse getHostEndpointProtectionScanResult(GetHostEndpointProtectionScanResultRequest request) {
        Validate.notBlank((String)request.getHostEndpointProtectionScanResultId(), (String)"hostEndpointProtectionScanResultId must not be blank", (Object[])new Object[0]);
        return (GetHostEndpointProtectionScanResultResponse)this.clientCall(request, GetHostEndpointProtectionScanResultResponse::builder).logger(LOG, "getHostEndpointProtectionScanResult").serviceDetails("VulnerabilityScanning", "GetHostEndpointProtectionScanResult", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostEndpointProtectionScanResult/GetHostEndpointProtectionScanResult").method(Method.GET).requestBuilder(GetHostEndpointProtectionScanResultRequest::builder).basePath("/20210215").appendPathParam("hostEndpointProtectionScanResults").appendPathParam(request.getHostEndpointProtectionScanResultId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HostEndpointProtectionScanResult.class, GetHostEndpointProtectionScanResultResponse.Builder::hostEndpointProtectionScanResult).handleResponseHeaderString("etag", GetHostEndpointProtectionScanResultResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetHostEndpointProtectionScanResultResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetHostPortScanResultResponse getHostPortScanResult(GetHostPortScanResultRequest request) {
        Validate.notBlank((String)request.getHostPortScanResultId(), (String)"hostPortScanResultId must not be blank", (Object[])new Object[0]);
        return (GetHostPortScanResultResponse)this.clientCall(request, GetHostPortScanResultResponse::builder).logger(LOG, "getHostPortScanResult").serviceDetails("VulnerabilityScanning", "GetHostPortScanResult", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostPortScanResult/GetHostPortScanResult").method(Method.GET).requestBuilder(GetHostPortScanResultRequest::builder).basePath("/20210215").appendPathParam("hostPortScanResults").appendPathParam(request.getHostPortScanResultId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HostPortScanResult.class, GetHostPortScanResultResponse.Builder::hostPortScanResult).handleResponseHeaderString("etag", GetHostPortScanResultResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetHostPortScanResultResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetHostScanRecipeResponse getHostScanRecipe(GetHostScanRecipeRequest request) {
        Validate.notBlank((String)request.getHostScanRecipeId(), (String)"hostScanRecipeId must not be blank", (Object[])new Object[0]);
        return (GetHostScanRecipeResponse)this.clientCall(request, GetHostScanRecipeResponse::builder).logger(LOG, "getHostScanRecipe").serviceDetails("VulnerabilityScanning", "GetHostScanRecipe", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanRecipe/GetHostScanRecipe").method(Method.GET).requestBuilder(GetHostScanRecipeRequest::builder).basePath("/20210215").appendPathParam("hostScanRecipes").appendPathParam(request.getHostScanRecipeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HostScanRecipe.class, GetHostScanRecipeResponse.Builder::hostScanRecipe).handleResponseHeaderString("etag", GetHostScanRecipeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetHostScanRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetHostScanTargetResponse getHostScanTarget(GetHostScanTargetRequest request) {
        Validate.notBlank((String)request.getHostScanTargetId(), (String)"hostScanTargetId must not be blank", (Object[])new Object[0]);
        return (GetHostScanTargetResponse)this.clientCall(request, GetHostScanTargetResponse::builder).logger(LOG, "getHostScanTarget").serviceDetails("VulnerabilityScanning", "GetHostScanTarget", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanTarget/GetHostScanTarget").method(Method.GET).requestBuilder(GetHostScanTargetRequest::builder).basePath("/20210215").appendPathParam("hostScanTargets").appendPathParam(request.getHostScanTargetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HostScanTarget.class, GetHostScanTargetResponse.Builder::hostScanTarget).handleResponseHeaderString("etag", GetHostScanTargetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetHostScanTargetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetHostVulnerabilityResponse getHostVulnerability(GetHostVulnerabilityRequest request) {
        Validate.notBlank((String)request.getHostVulnerabilityId(), (String)"hostVulnerabilityId must not be blank", (Object[])new Object[0]);
        return (GetHostVulnerabilityResponse)this.clientCall(request, GetHostVulnerabilityResponse::builder).logger(LOG, "getHostVulnerability").serviceDetails("VulnerabilityScanning", "GetHostVulnerability", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostVulnerability/GetHostVulnerability").method(Method.GET).requestBuilder(GetHostVulnerabilityRequest::builder).basePath("/20210215").appendPathParam("hostVulnerabilities").appendPathParam(request.getHostVulnerabilityId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HostVulnerability.class, GetHostVulnerabilityResponse.Builder::hostVulnerability).handleResponseHeaderString("etag", GetHostVulnerabilityResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetHostVulnerabilityResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVulnerabilityResponse getVulnerability(GetVulnerabilityRequest request) {
        Validate.notBlank((String)request.getVulnerabilityId(), (String)"vulnerabilityId must not be blank", (Object[])new Object[0]);
        return (GetVulnerabilityResponse)this.clientCall(request, GetVulnerabilityResponse::builder).logger(LOG, "getVulnerability").serviceDetails("VulnerabilityScanning", "GetVulnerability", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/Vulnerability/GetVulnerability").method(Method.GET).requestBuilder(GetVulnerabilityRequest::builder).basePath("/20210215").appendPathParam("vulnerabilities").appendPathParam(request.getVulnerabilityId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Vulnerability.class, GetVulnerabilityResponse.Builder::vulnerability).handleResponseHeaderString("etag", GetVulnerabilityResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVulnerabilityResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("VulnerabilityScanning", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210215").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListContainerScanRecipesResponse listContainerScanRecipes(ListContainerScanRecipesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListContainerScanRecipesResponse)this.clientCall(request, ListContainerScanRecipesResponse::builder).logger(LOG, "listContainerScanRecipes").serviceDetails("VulnerabilityScanning", "ListContainerScanRecipes", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanRecipe/ListContainerScanRecipes").method(Method.GET).requestBuilder(ListContainerScanRecipesRequest::builder).basePath("/20210215").appendPathParam("containerScanRecipes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ContainerScanRecipeSummaryCollection.class, ListContainerScanRecipesResponse.Builder::containerScanRecipeSummaryCollection).handleResponseHeaderString("opc-request-id", ListContainerScanRecipesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListContainerScanRecipesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListContainerScanResultsResponse listContainerScanResults(ListContainerScanResultsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListContainerScanResultsResponse)this.clientCall(request, ListContainerScanResultsResponse::builder).logger(LOG, "listContainerScanResults").serviceDetails("VulnerabilityScanning", "ListContainerScanResults", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanResult/ListContainerScanResults").method(Method.GET).requestBuilder(ListContainerScanResultsRequest::builder).basePath("/20210215").appendPathParam("containerScanResults").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("repository", (Object)request.getRepository()).appendQueryParam("image", (Object)request.getImage()).appendQueryParam("areSubcompartmentsIncluded", (Object)request.getAreSubcompartmentsIncluded()).appendEnumQueryParam("highestProblemSeverity", (BmcEnum)request.getHighestProblemSeverity()).appendQueryParam("timeStartedGreaterThanOrEqualTo", (Object)request.getTimeStartedGreaterThanOrEqualTo()).appendQueryParam("timeStartedLessThanOrEqualTo", (Object)request.getTimeStartedLessThanOrEqualTo()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("isLatestOnly", (Object)request.getIsLatestOnly()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ContainerScanResultSummaryCollection.class, ListContainerScanResultsResponse.Builder::containerScanResultSummaryCollection).handleResponseHeaderString("opc-request-id", ListContainerScanResultsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListContainerScanResultsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListContainerScanTargetsResponse listContainerScanTargets(ListContainerScanTargetsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListContainerScanTargetsResponse)this.clientCall(request, ListContainerScanTargetsResponse::builder).logger(LOG, "listContainerScanTargets").serviceDetails("VulnerabilityScanning", "ListContainerScanTargets", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanTarget/ListContainerScanTargets").method(Method.GET).requestBuilder(ListContainerScanTargetsRequest::builder).basePath("/20210215").appendPathParam("containerScanTargets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ContainerScanTargetSummaryCollection.class, ListContainerScanTargetsResponse.Builder::containerScanTargetSummaryCollection).handleResponseHeaderString("opc-request-id", ListContainerScanTargetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListContainerScanTargetsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListHostAgentScanResultsResponse listHostAgentScanResults(ListHostAgentScanResultsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListHostAgentScanResultsResponse)this.clientCall(request, ListHostAgentScanResultsResponse::builder).logger(LOG, "listHostAgentScanResults").serviceDetails("VulnerabilityScanning", "ListHostAgentScanResults", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostAgentScanResult/ListHostAgentScanResults").method(Method.GET).requestBuilder(ListHostAgentScanResultsRequest::builder).basePath("/20210215").appendPathParam("hostAgentScanResults").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("instanceId", (Object)request.getInstanceId()).appendEnumQueryParam("highestProblemSeverity", (BmcEnum)request.getHighestProblemSeverity()).appendQueryParam("operatingSystem", (Object)request.getOperatingSystem()).appendQueryParam("timeStartedGreaterThanOrEqualTo", (Object)request.getTimeStartedGreaterThanOrEqualTo()).appendQueryParam("timeStartedLessThanOrEqualTo", (Object)request.getTimeStartedLessThanOrEqualTo()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("isLatestOnly", (Object)request.getIsLatestOnly()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HostAgentScanResultSummaryCollection.class, ListHostAgentScanResultsResponse.Builder::hostAgentScanResultSummaryCollection).handleResponseHeaderString("opc-request-id", ListHostAgentScanResultsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListHostAgentScanResultsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListHostCisBenchmarkScanResultsResponse listHostCisBenchmarkScanResults(ListHostCisBenchmarkScanResultsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListHostCisBenchmarkScanResultsResponse)this.clientCall(request, ListHostCisBenchmarkScanResultsResponse::builder).logger(LOG, "listHostCisBenchmarkScanResults").serviceDetails("VulnerabilityScanning", "ListHostCisBenchmarkScanResults", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostCisBenchmarkScanResult/ListHostCisBenchmarkScanResults").method(Method.GET).requestBuilder(ListHostCisBenchmarkScanResultsRequest::builder).basePath("/20210215").appendPathParam("hostCisBenchmarkScanResults").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("instanceId", (Object)request.getInstanceId()).appendEnumQueryParam("highestProblemSeverity", (BmcEnum)request.getHighestProblemSeverity()).appendQueryParam("timeStartedGreaterThanOrEqualTo", (Object)request.getTimeStartedGreaterThanOrEqualTo()).appendQueryParam("timeStartedLessThanOrEqualTo", (Object)request.getTimeStartedLessThanOrEqualTo()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("isLatestOnly", (Object)request.getIsLatestOnly()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HostCisBenchmarkScanResultSummaryCollection.class, ListHostCisBenchmarkScanResultsResponse.Builder::hostCisBenchmarkScanResultSummaryCollection).handleResponseHeaderString("opc-request-id", ListHostCisBenchmarkScanResultsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListHostCisBenchmarkScanResultsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListHostEndpointProtectionScanResultsResponse listHostEndpointProtectionScanResults(ListHostEndpointProtectionScanResultsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListHostEndpointProtectionScanResultsResponse)this.clientCall(request, ListHostEndpointProtectionScanResultsResponse::builder).logger(LOG, "listHostEndpointProtectionScanResults").serviceDetails("VulnerabilityScanning", "ListHostEndpointProtectionScanResults", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostEndpointProtectionScanResult/ListHostEndpointProtectionScanResults").method(Method.GET).requestBuilder(ListHostEndpointProtectionScanResultsRequest::builder).basePath("/20210215").appendPathParam("hostEndpointProtectionScanResults").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("instanceId", (Object)request.getInstanceId()).appendEnumQueryParam("highestProblemSeverity", (BmcEnum)request.getHighestProblemSeverity()).appendQueryParam("timeStartedGreaterThanOrEqualTo", (Object)request.getTimeStartedGreaterThanOrEqualTo()).appendQueryParam("timeStartedLessThanOrEqualTo", (Object)request.getTimeStartedLessThanOrEqualTo()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("isLatestOnly", (Object)request.getIsLatestOnly()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HostEndpointProtectionScanResultSummaryCollection.class, ListHostEndpointProtectionScanResultsResponse.Builder::hostEndpointProtectionScanResultSummaryCollection).handleResponseHeaderString("opc-request-id", ListHostEndpointProtectionScanResultsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListHostEndpointProtectionScanResultsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListHostPortScanResultsResponse listHostPortScanResults(ListHostPortScanResultsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListHostPortScanResultsResponse)this.clientCall(request, ListHostPortScanResultsResponse::builder).logger(LOG, "listHostPortScanResults").serviceDetails("VulnerabilityScanning", "ListHostPortScanResults", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostPortScanResult/ListHostPortScanResults").method(Method.GET).requestBuilder(ListHostPortScanResultsRequest::builder).basePath("/20210215").appendPathParam("hostPortScanResults").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("instanceId", (Object)request.getInstanceId()).appendEnumQueryParam("highestProblemSeverity", (BmcEnum)request.getHighestProblemSeverity()).appendQueryParam("timeStartedGreaterThanOrEqualTo", (Object)request.getTimeStartedGreaterThanOrEqualTo()).appendQueryParam("timeStartedLessThanOrEqualTo", (Object)request.getTimeStartedLessThanOrEqualTo()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("isLatestOnly", (Object)request.getIsLatestOnly()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HostPortScanResultSummaryCollection.class, ListHostPortScanResultsResponse.Builder::hostPortScanResultSummaryCollection).handleResponseHeaderString("opc-request-id", ListHostPortScanResultsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListHostPortScanResultsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListHostScanRecipesResponse listHostScanRecipes(ListHostScanRecipesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListHostScanRecipesResponse)this.clientCall(request, ListHostScanRecipesResponse::builder).logger(LOG, "listHostScanRecipes").serviceDetails("VulnerabilityScanning", "ListHostScanRecipes", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanRecipe/ListHostScanRecipes").method(Method.GET).requestBuilder(ListHostScanRecipesRequest::builder).basePath("/20210215").appendPathParam("hostScanRecipes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HostScanRecipeSummaryCollection.class, ListHostScanRecipesResponse.Builder::hostScanRecipeSummaryCollection).handleResponseHeaderString("opc-request-id", ListHostScanRecipesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListHostScanRecipesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListHostScanTargetErrorsResponse listHostScanTargetErrors(ListHostScanTargetErrorsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getHostScanTargetId(), (String)"hostScanTargetId must not be blank", (Object[])new Object[0]);
        return (ListHostScanTargetErrorsResponse)this.clientCall(request, ListHostScanTargetErrorsResponse::builder).logger(LOG, "listHostScanTargetErrors").serviceDetails("VulnerabilityScanning", "ListHostScanTargetErrors", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanTargetErrorSummaryCollection/ListHostScanTargetErrors").method(Method.GET).requestBuilder(ListHostScanTargetErrorsRequest::builder).basePath("/20210215").appendPathParam("hostScanTargets").appendPathParam(request.getHostScanTargetId()).appendPathParam("errors").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HostScanTargetErrorSummaryCollection.class, ListHostScanTargetErrorsResponse.Builder::hostScanTargetErrorSummaryCollection).handleResponseHeaderString("opc-request-id", ListHostScanTargetErrorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListHostScanTargetErrorsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListHostScanTargetsResponse listHostScanTargets(ListHostScanTargetsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListHostScanTargetsResponse)this.clientCall(request, ListHostScanTargetsResponse::builder).logger(LOG, "listHostScanTargets").serviceDetails("VulnerabilityScanning", "ListHostScanTargets", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanTarget/ListHostScanTargets").method(Method.GET).requestBuilder(ListHostScanTargetsRequest::builder).basePath("/20210215").appendPathParam("hostScanTargets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HostScanTargetSummaryCollection.class, ListHostScanTargetsResponse.Builder::hostScanTargetSummaryCollection).handleResponseHeaderString("opc-request-id", ListHostScanTargetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListHostScanTargetsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListHostVulnerabilitiesResponse listHostVulnerabilities(ListHostVulnerabilitiesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListHostVulnerabilitiesResponse)this.clientCall(request, ListHostVulnerabilitiesResponse::builder).logger(LOG, "listHostVulnerabilities").serviceDetails("VulnerabilityScanning", "ListHostVulnerabilities", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostVulnerability/ListHostVulnerabilities").method(Method.GET).requestBuilder(ListHostVulnerabilitiesRequest::builder).basePath("/20210215").appendPathParam("hostVulnerabilities").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("severity", (BmcEnum)request.getSeverity()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("cveReference", (Object)request.getCveReference()).appendEnumQueryParam("vulnerabilityType", (BmcEnum)request.getVulnerabilityType()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HostVulnerabilitySummaryCollection.class, ListHostVulnerabilitiesResponse.Builder::hostVulnerabilitySummaryCollection).handleResponseHeaderString("opc-request-id", ListHostVulnerabilitiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListHostVulnerabilitiesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListHostVulnerabilityImpactedHostsResponse listHostVulnerabilityImpactedHosts(ListHostVulnerabilityImpactedHostsRequest request) {
        Validate.notBlank((String)request.getHostVulnerabilityId(), (String)"hostVulnerabilityId must not be blank", (Object[])new Object[0]);
        return (ListHostVulnerabilityImpactedHostsResponse)this.clientCall(request, ListHostVulnerabilityImpactedHostsResponse::builder).logger(LOG, "listHostVulnerabilityImpactedHosts").serviceDetails("VulnerabilityScanning", "ListHostVulnerabilityImpactedHosts", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostVulnerability/ListHostVulnerabilityImpactedHosts").method(Method.GET).requestBuilder(ListHostVulnerabilityImpactedHostsRequest::builder).basePath("/20210215").appendPathParam("hostVulnerabilities").appendPathParam(request.getHostVulnerabilityId()).appendPathParam("impactedHosts").appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HostVulnerabilityImpactedHostSummaryCollection.class, ListHostVulnerabilityImpactedHostsResponse.Builder::hostVulnerabilityImpactedHostSummaryCollection).handleResponseHeaderString("opc-request-id", ListHostVulnerabilityImpactedHostsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListHostVulnerabilityImpactedHostsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListVulnerabilitiesResponse listVulnerabilities(ListVulnerabilitiesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVulnerabilitiesResponse)this.clientCall(request, ListVulnerabilitiesResponse::builder).logger(LOG, "listVulnerabilities").serviceDetails("VulnerabilityScanning", "ListVulnerabilities", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/Vulnerability/ListVulnerabilities").method(Method.GET).requestBuilder(ListVulnerabilitiesRequest::builder).basePath("/20210215").appendPathParam("vulnerabilities").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("severity", (BmcEnum)request.getSeverity()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("vulnerabilityReference", (Object)request.getVulnerabilityReference()).appendEnumQueryParam("vulnerabilityType", (BmcEnum)request.getVulnerabilityType()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VulnerabilitySummaryCollection.class, ListVulnerabilitiesResponse.Builder::vulnerabilitySummaryCollection).handleResponseHeaderString("opc-request-id", ListVulnerabilitiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListVulnerabilitiesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListVulnerabilityImpactedContainersResponse listVulnerabilityImpactedContainers(ListVulnerabilityImpactedContainersRequest request) {
        Validate.notBlank((String)request.getVulnerabilityId(), (String)"vulnerabilityId must not be blank", (Object[])new Object[0]);
        return (ListVulnerabilityImpactedContainersResponse)this.clientCall(request, ListVulnerabilityImpactedContainersResponse::builder).logger(LOG, "listVulnerabilityImpactedContainers").serviceDetails("VulnerabilityScanning", "ListVulnerabilityImpactedContainers", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/Vulnerability/ListVulnerabilityImpactedContainers").method(Method.GET).requestBuilder(ListVulnerabilityImpactedContainersRequest::builder).basePath("/20210215").appendPathParam("vulnerabilities").appendPathParam(request.getVulnerabilityId()).appendPathParam("impactedContainers").appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VulnerabilityImpactedContainerSummaryCollection.class, ListVulnerabilityImpactedContainersResponse.Builder::vulnerabilityImpactedContainerSummaryCollection).handleResponseHeaderString("opc-request-id", ListVulnerabilityImpactedContainersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListVulnerabilityImpactedContainersResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListVulnerabilityImpactedHostsResponse listVulnerabilityImpactedHosts(ListVulnerabilityImpactedHostsRequest request) {
        Validate.notBlank((String)request.getVulnerabilityId(), (String)"vulnerabilityId must not be blank", (Object[])new Object[0]);
        return (ListVulnerabilityImpactedHostsResponse)this.clientCall(request, ListVulnerabilityImpactedHostsResponse::builder).logger(LOG, "listVulnerabilityImpactedHosts").serviceDetails("VulnerabilityScanning", "ListVulnerabilityImpactedHosts", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/Vulnerability/ListVulnerabilityImpactedHosts").method(Method.GET).requestBuilder(ListVulnerabilityImpactedHostsRequest::builder).basePath("/20210215").appendPathParam("vulnerabilities").appendPathParam(request.getVulnerabilityId()).appendPathParam("impactedHosts").appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VulnerabilityImpactedHostSummaryCollection.class, ListVulnerabilityImpactedHostsResponse.Builder::vulnerabilityImpactedHostSummaryCollection).handleResponseHeaderString("opc-request-id", ListVulnerabilityImpactedHostsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListVulnerabilityImpactedHostsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("VulnerabilityScanning", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210215").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("VulnerabilityScanning", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210215").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("VulnerabilityScanning", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210215").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateContainerScanRecipeResponse updateContainerScanRecipe(UpdateContainerScanRecipeRequest request) {
        Validate.notBlank((String)request.getContainerScanRecipeId(), (String)"containerScanRecipeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateContainerScanRecipeDetails(), "updateContainerScanRecipeDetails is required");
        return (UpdateContainerScanRecipeResponse)this.clientCall(request, UpdateContainerScanRecipeResponse::builder).logger(LOG, "updateContainerScanRecipe").serviceDetails("VulnerabilityScanning", "UpdateContainerScanRecipe", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanRecipe/UpdateContainerScanRecipe").method(Method.PUT).requestBuilder(UpdateContainerScanRecipeRequest::builder).basePath("/20210215").appendPathParam("containerScanRecipes").appendPathParam(request.getContainerScanRecipeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateContainerScanRecipeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateContainerScanRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateContainerScanTargetResponse updateContainerScanTarget(UpdateContainerScanTargetRequest request) {
        Validate.notBlank((String)request.getContainerScanTargetId(), (String)"containerScanTargetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateContainerScanTargetDetails(), "updateContainerScanTargetDetails is required");
        return (UpdateContainerScanTargetResponse)this.clientCall(request, UpdateContainerScanTargetResponse::builder).logger(LOG, "updateContainerScanTarget").serviceDetails("VulnerabilityScanning", "UpdateContainerScanTarget", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanTarget/UpdateContainerScanTarget").method(Method.PUT).requestBuilder(UpdateContainerScanTargetRequest::builder).basePath("/20210215").appendPathParam("containerScanTargets").appendPathParam(request.getContainerScanTargetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateContainerScanTargetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateContainerScanTargetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateHostScanRecipeResponse updateHostScanRecipe(UpdateHostScanRecipeRequest request) {
        Validate.notBlank((String)request.getHostScanRecipeId(), (String)"hostScanRecipeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateHostScanRecipeDetails(), "updateHostScanRecipeDetails is required");
        return (UpdateHostScanRecipeResponse)this.clientCall(request, UpdateHostScanRecipeResponse::builder).logger(LOG, "updateHostScanRecipe").serviceDetails("VulnerabilityScanning", "UpdateHostScanRecipe", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanRecipe/UpdateHostScanRecipe").method(Method.PUT).requestBuilder(UpdateHostScanRecipeRequest::builder).basePath("/20210215").appendPathParam("hostScanRecipes").appendPathParam(request.getHostScanRecipeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateHostScanRecipeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateHostScanRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateHostScanTargetResponse updateHostScanTarget(UpdateHostScanTargetRequest request) {
        Validate.notBlank((String)request.getHostScanTargetId(), (String)"hostScanTargetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateHostScanTargetDetails(), "updateHostScanTargetDetails is required");
        return (UpdateHostScanTargetResponse)this.clientCall(request, UpdateHostScanTargetResponse::builder).logger(LOG, "updateHostScanTarget").serviceDetails("VulnerabilityScanning", "UpdateHostScanTarget", "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanTarget/UpdateHostScanTarget").method(Method.PUT).requestBuilder(UpdateHostScanTargetRequest::builder).basePath("/20210215").appendPathParam("hostScanTargets").appendPathParam(request.getHostScanTargetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateHostScanTargetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateHostScanTargetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public VulnerabilityScanningWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public VulnerabilityScanningPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public VulnerabilityScanningClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)VulnerabilityScanningClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public VulnerabilityScanningClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(VulnerabilityScanningClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public VulnerabilityScanningClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)VulnerabilityScanningClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public VulnerabilityScanningClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)VulnerabilityScanningClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VulnerabilityScanningClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)VulnerabilityScanningClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VulnerabilityScanningClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)VulnerabilityScanningClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VulnerabilityScanningClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)VulnerabilityScanningClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VulnerabilityScanningClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)VulnerabilityScanningClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, VulnerabilityScanningClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public VulnerabilityScanningClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new VulnerabilityScanningClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

