/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetPathAnalyzerTestRequest
extends BmcRequest<Void> {
    private String pathAnalyzerTestId;
    private String opcRequestId;

    public String getPathAnalyzerTestId() {
        return this.pathAnalyzerTestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().pathAnalyzerTestId(this.pathAnalyzerTestId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",pathAnalyzerTestId=").append(String.valueOf(this.pathAnalyzerTestId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPathAnalyzerTestRequest)) {
            return false;
        }
        GetPathAnalyzerTestRequest other = (GetPathAnalyzerTestRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.pathAnalyzerTestId, other.pathAnalyzerTestId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pathAnalyzerTestId == null ? 43 : this.pathAnalyzerTestId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPathAnalyzerTestRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String pathAnalyzerTestId = null;
        private String opcRequestId = null;

        public Builder pathAnalyzerTestId(String pathAnalyzerTestId) {
            this.pathAnalyzerTestId = pathAnalyzerTestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPathAnalyzerTestRequest o) {
            this.pathAnalyzerTestId(o.getPathAnalyzerTestId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPathAnalyzerTestRequest build() {
            GetPathAnalyzerTestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetPathAnalyzerTestRequest buildWithoutInvocationCallback() {
            GetPathAnalyzerTestRequest request = new GetPathAnalyzerTestRequest();
            request.pathAnalyzerTestId = this.pathAnalyzerTestId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

