/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.vnmonitoring.model.EgressTrafficSpec;
import com.oracle.bmc.vnmonitoring.model.RoutingAction;
import com.oracle.bmc.vnmonitoring.model.SecurityAction;
import com.oracle.bmc.vnmonitoring.model.TrafficNode;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class VisibleTrafficNode
extends TrafficNode {
    @JsonProperty(value="entityId")
    private final String entityId;
    @JsonProperty(value="transformationDescription")
    private final String transformationDescription;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public VisibleTrafficNode(EgressTrafficSpec egressTraffic, RoutingAction nextHopRoutingAction, SecurityAction egressSecurityAction, SecurityAction ingressSecurityAction, String entityId, String transformationDescription) {
        super(egressTraffic, nextHopRoutingAction, egressSecurityAction, ingressSecurityAction);
        this.entityId = entityId;
        this.transformationDescription = transformationDescription;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getTransformationDescription() {
        return this.transformationDescription;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VisibleTrafficNode(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", entityId=").append(String.valueOf(this.entityId));
        sb.append(", transformationDescription=").append(String.valueOf(this.transformationDescription));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VisibleTrafficNode)) {
            return false;
        }
        VisibleTrafficNode other = (VisibleTrafficNode)((Object)o);
        return Objects.equals(this.entityId, other.entityId) && Objects.equals(this.transformationDescription, other.transformationDescription) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.entityId == null ? 43 : this.entityId.hashCode());
        result = result * 59 + (this.transformationDescription == null ? 43 : this.transformationDescription.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="egressTraffic")
        private EgressTrafficSpec egressTraffic;
        @JsonProperty(value="nextHopRoutingAction")
        private RoutingAction nextHopRoutingAction;
        @JsonProperty(value="egressSecurityAction")
        private SecurityAction egressSecurityAction;
        @JsonProperty(value="ingressSecurityAction")
        private SecurityAction ingressSecurityAction;
        @JsonProperty(value="entityId")
        private String entityId;
        @JsonProperty(value="transformationDescription")
        private String transformationDescription;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder egressTraffic(EgressTrafficSpec egressTraffic) {
            this.egressTraffic = egressTraffic;
            this.__explicitlySet__.add("egressTraffic");
            return this;
        }

        public Builder nextHopRoutingAction(RoutingAction nextHopRoutingAction) {
            this.nextHopRoutingAction = nextHopRoutingAction;
            this.__explicitlySet__.add("nextHopRoutingAction");
            return this;
        }

        public Builder egressSecurityAction(SecurityAction egressSecurityAction) {
            this.egressSecurityAction = egressSecurityAction;
            this.__explicitlySet__.add("egressSecurityAction");
            return this;
        }

        public Builder ingressSecurityAction(SecurityAction ingressSecurityAction) {
            this.ingressSecurityAction = ingressSecurityAction;
            this.__explicitlySet__.add("ingressSecurityAction");
            return this;
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            this.__explicitlySet__.add("entityId");
            return this;
        }

        public Builder transformationDescription(String transformationDescription) {
            this.transformationDescription = transformationDescription;
            this.__explicitlySet__.add("transformationDescription");
            return this;
        }

        public VisibleTrafficNode build() {
            VisibleTrafficNode model = new VisibleTrafficNode(this.egressTraffic, this.nextHopRoutingAction, this.egressSecurityAction, this.ingressSecurityAction, this.entityId, this.transformationDescription);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VisibleTrafficNode model) {
            if (model.wasPropertyExplicitlySet("egressTraffic")) {
                this.egressTraffic(model.getEgressTraffic());
            }
            if (model.wasPropertyExplicitlySet("nextHopRoutingAction")) {
                this.nextHopRoutingAction(model.getNextHopRoutingAction());
            }
            if (model.wasPropertyExplicitlySet("egressSecurityAction")) {
                this.egressSecurityAction(model.getEgressSecurityAction());
            }
            if (model.wasPropertyExplicitlySet("ingressSecurityAction")) {
                this.ingressSecurityAction(model.getIngressSecurityAction());
            }
            if (model.wasPropertyExplicitlySet("entityId")) {
                this.entityId(model.getEntityId());
            }
            if (model.wasPropertyExplicitlySet("transformationDescription")) {
                this.transformationDescription(model.getTransformationDescription());
            }
            return this;
        }
    }
}

