/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VirtualCircuitPublicPrefix
extends ExplicitlySetBmcModel {
    @JsonProperty(value="cidrBlock")
    private final String cidrBlock;
    @JsonProperty(value="verificationState")
    private final VerificationState verificationState;

    @Deprecated
    @ConstructorProperties(value={"cidrBlock", "verificationState"})
    public VirtualCircuitPublicPrefix(String cidrBlock, VerificationState verificationState) {
        this.cidrBlock = cidrBlock;
        this.verificationState = verificationState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCidrBlock() {
        return this.cidrBlock;
    }

    public VerificationState getVerificationState() {
        return this.verificationState;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VirtualCircuitPublicPrefix(");
        sb.append("super=").append(super.toString());
        sb.append("cidrBlock=").append(String.valueOf(this.cidrBlock));
        sb.append(", verificationState=").append(String.valueOf((Object)this.verificationState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualCircuitPublicPrefix)) {
            return false;
        }
        VirtualCircuitPublicPrefix other = (VirtualCircuitPublicPrefix)((Object)o);
        return Objects.equals(this.cidrBlock, other.cidrBlock) && Objects.equals((Object)this.verificationState, (Object)other.verificationState) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.cidrBlock == null ? 43 : this.cidrBlock.hashCode());
        result = result * 59 + (this.verificationState == null ? 43 : this.verificationState.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum VerificationState implements BmcEnum
    {
        InProgress("IN_PROGRESS"),
        Completed("COMPLETED"),
        Failed("FAILED");

        private final String value;
        private static Map<String, VerificationState> map;

        private VerificationState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static VerificationState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid VerificationState: " + key);
        }

        static {
            map = new HashMap<String, VerificationState>();
            for (VerificationState v : VerificationState.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="cidrBlock")
        private String cidrBlock;
        @JsonProperty(value="verificationState")
        private VerificationState verificationState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            this.__explicitlySet__.add("cidrBlock");
            return this;
        }

        public Builder verificationState(VerificationState verificationState) {
            this.verificationState = verificationState;
            this.__explicitlySet__.add("verificationState");
            return this;
        }

        public VirtualCircuitPublicPrefix build() {
            VirtualCircuitPublicPrefix model = new VirtualCircuitPublicPrefix(this.cidrBlock, this.verificationState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VirtualCircuitPublicPrefix model) {
            if (model.wasPropertyExplicitlySet("cidrBlock")) {
                this.cidrBlock(model.getCidrBlock());
            }
            if (model.wasPropertyExplicitlySet("verificationState")) {
                this.verificationState(model.getVerificationState());
            }
            return this;
        }
    }
}

