/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.vnmonitoring.model.CrossConnectMapping;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateVirtualCircuitDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="bandwidthShapeName")
    private final String bandwidthShapeName;
    @JsonProperty(value="crossConnectMappings")
    private final List<CrossConnectMapping> crossConnectMappings;
    @JsonProperty(value="customerBgpAsn")
    private final Integer customerBgpAsn;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="gatewayId")
    private final String gatewayId;
    @JsonProperty(value="providerState")
    private final ProviderState providerState;
    @JsonProperty(value="referenceComment")
    private final String referenceComment;

    @Deprecated
    @ConstructorProperties(value={"bandwidthShapeName", "crossConnectMappings", "customerBgpAsn", "displayName", "gatewayId", "providerState", "referenceComment"})
    public UpdateVirtualCircuitDetails(String bandwidthShapeName, List<CrossConnectMapping> crossConnectMappings, Integer customerBgpAsn, String displayName, String gatewayId, ProviderState providerState, String referenceComment) {
        this.bandwidthShapeName = bandwidthShapeName;
        this.crossConnectMappings = crossConnectMappings;
        this.customerBgpAsn = customerBgpAsn;
        this.displayName = displayName;
        this.gatewayId = gatewayId;
        this.providerState = providerState;
        this.referenceComment = referenceComment;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getBandwidthShapeName() {
        return this.bandwidthShapeName;
    }

    public List<CrossConnectMapping> getCrossConnectMappings() {
        return this.crossConnectMappings;
    }

    public Integer getCustomerBgpAsn() {
        return this.customerBgpAsn;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public ProviderState getProviderState() {
        return this.providerState;
    }

    public String getReferenceComment() {
        return this.referenceComment;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateVirtualCircuitDetails(");
        sb.append("super=").append(super.toString());
        sb.append("bandwidthShapeName=").append(String.valueOf(this.bandwidthShapeName));
        sb.append(", crossConnectMappings=").append(String.valueOf(this.crossConnectMappings));
        sb.append(", customerBgpAsn=").append(String.valueOf(this.customerBgpAsn));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", gatewayId=").append(String.valueOf(this.gatewayId));
        sb.append(", providerState=").append(String.valueOf((Object)this.providerState));
        sb.append(", referenceComment=").append(String.valueOf(this.referenceComment));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateVirtualCircuitDetails)) {
            return false;
        }
        UpdateVirtualCircuitDetails other = (UpdateVirtualCircuitDetails)((Object)o);
        return Objects.equals(this.bandwidthShapeName, other.bandwidthShapeName) && Objects.equals(this.crossConnectMappings, other.crossConnectMappings) && Objects.equals(this.customerBgpAsn, other.customerBgpAsn) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.gatewayId, other.gatewayId) && Objects.equals((Object)this.providerState, (Object)other.providerState) && Objects.equals(this.referenceComment, other.referenceComment) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.bandwidthShapeName == null ? 43 : this.bandwidthShapeName.hashCode());
        result = result * 59 + (this.crossConnectMappings == null ? 43 : this.crossConnectMappings.hashCode());
        result = result * 59 + (this.customerBgpAsn == null ? 43 : this.customerBgpAsn.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.gatewayId == null ? 43 : this.gatewayId.hashCode());
        result = result * 59 + (this.providerState == null ? 43 : this.providerState.hashCode());
        result = result * 59 + (this.referenceComment == null ? 43 : this.referenceComment.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ProviderState implements BmcEnum
    {
        Active("ACTIVE"),
        Inactive("INACTIVE");

        private final String value;
        private static Map<String, ProviderState> map;

        private ProviderState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ProviderState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ProviderState: " + key);
        }

        static {
            map = new HashMap<String, ProviderState>();
            for (ProviderState v : ProviderState.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="bandwidthShapeName")
        private String bandwidthShapeName;
        @JsonProperty(value="crossConnectMappings")
        private List<CrossConnectMapping> crossConnectMappings;
        @JsonProperty(value="customerBgpAsn")
        private Integer customerBgpAsn;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="gatewayId")
        private String gatewayId;
        @JsonProperty(value="providerState")
        private ProviderState providerState;
        @JsonProperty(value="referenceComment")
        private String referenceComment;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder bandwidthShapeName(String bandwidthShapeName) {
            this.bandwidthShapeName = bandwidthShapeName;
            this.__explicitlySet__.add("bandwidthShapeName");
            return this;
        }

        public Builder crossConnectMappings(List<CrossConnectMapping> crossConnectMappings) {
            this.crossConnectMappings = crossConnectMappings;
            this.__explicitlySet__.add("crossConnectMappings");
            return this;
        }

        public Builder customerBgpAsn(Integer customerBgpAsn) {
            this.customerBgpAsn = customerBgpAsn;
            this.__explicitlySet__.add("customerBgpAsn");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            this.__explicitlySet__.add("gatewayId");
            return this;
        }

        public Builder providerState(ProviderState providerState) {
            this.providerState = providerState;
            this.__explicitlySet__.add("providerState");
            return this;
        }

        public Builder referenceComment(String referenceComment) {
            this.referenceComment = referenceComment;
            this.__explicitlySet__.add("referenceComment");
            return this;
        }

        public UpdateVirtualCircuitDetails build() {
            UpdateVirtualCircuitDetails model = new UpdateVirtualCircuitDetails(this.bandwidthShapeName, this.crossConnectMappings, this.customerBgpAsn, this.displayName, this.gatewayId, this.providerState, this.referenceComment);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateVirtualCircuitDetails model) {
            if (model.wasPropertyExplicitlySet("bandwidthShapeName")) {
                this.bandwidthShapeName(model.getBandwidthShapeName());
            }
            if (model.wasPropertyExplicitlySet("crossConnectMappings")) {
                this.crossConnectMappings(model.getCrossConnectMappings());
            }
            if (model.wasPropertyExplicitlySet("customerBgpAsn")) {
                this.customerBgpAsn(model.getCustomerBgpAsn());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("gatewayId")) {
                this.gatewayId(model.getGatewayId());
            }
            if (model.wasPropertyExplicitlySet("providerState")) {
                this.providerState(model.getProviderState());
            }
            if (model.wasPropertyExplicitlySet("referenceComment")) {
                this.referenceComment(model.getReferenceComment());
            }
            return this;
        }
    }
}

