/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.vnmonitoring.model.TrafficProtocolParameters;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class UdpTrafficProtocolParameters
extends TrafficProtocolParameters {
    @JsonProperty(value="sourcePort")
    private final Integer sourcePort;
    @JsonProperty(value="destinationPort")
    private final Integer destinationPort;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UdpTrafficProtocolParameters(Integer sourcePort, Integer destinationPort) {
        this.sourcePort = sourcePort;
        this.destinationPort = destinationPort;
    }

    public Integer getSourcePort() {
        return this.sourcePort;
    }

    public Integer getDestinationPort() {
        return this.destinationPort;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UdpTrafficProtocolParameters(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", sourcePort=").append(String.valueOf(this.sourcePort));
        sb.append(", destinationPort=").append(String.valueOf(this.destinationPort));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UdpTrafficProtocolParameters)) {
            return false;
        }
        UdpTrafficProtocolParameters other = (UdpTrafficProtocolParameters)((Object)o);
        return Objects.equals(this.sourcePort, other.sourcePort) && Objects.equals(this.destinationPort, other.destinationPort) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.sourcePort == null ? 43 : this.sourcePort.hashCode());
        result = result * 59 + (this.destinationPort == null ? 43 : this.destinationPort.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sourcePort")
        private Integer sourcePort;
        @JsonProperty(value="destinationPort")
        private Integer destinationPort;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sourcePort(Integer sourcePort) {
            this.sourcePort = sourcePort;
            this.__explicitlySet__.add("sourcePort");
            return this;
        }

        public Builder destinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            this.__explicitlySet__.add("destinationPort");
            return this;
        }

        public UdpTrafficProtocolParameters build() {
            UdpTrafficProtocolParameters model = new UdpTrafficProtocolParameters(this.sourcePort, this.destinationPort);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UdpTrafficProtocolParameters model) {
            if (model.wasPropertyExplicitlySet("sourcePort")) {
                this.sourcePort(model.getSourcePort());
            }
            if (model.wasPropertyExplicitlySet("destinationPort")) {
                this.destinationPort(model.getDestinationPort());
            }
            return this;
        }
    }
}

