/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.vnmonitoring.model.TrafficNode;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TrafficRoute
extends ExplicitlySetBmcModel {
    @JsonProperty(value="reachabilityStatus")
    private final ReachabilityStatus reachabilityStatus;
    @JsonProperty(value="nodes")
    private final List<TrafficNode> nodes;
    @JsonProperty(value="routeAnalysisDescription")
    private final String routeAnalysisDescription;

    @Deprecated
    @ConstructorProperties(value={"reachabilityStatus", "nodes", "routeAnalysisDescription"})
    public TrafficRoute(ReachabilityStatus reachabilityStatus, List<TrafficNode> nodes, String routeAnalysisDescription) {
        this.reachabilityStatus = reachabilityStatus;
        this.nodes = nodes;
        this.routeAnalysisDescription = routeAnalysisDescription;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ReachabilityStatus getReachabilityStatus() {
        return this.reachabilityStatus;
    }

    public List<TrafficNode> getNodes() {
        return this.nodes;
    }

    public String getRouteAnalysisDescription() {
        return this.routeAnalysisDescription;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TrafficRoute(");
        sb.append("super=").append(super.toString());
        sb.append("reachabilityStatus=").append(String.valueOf((Object)this.reachabilityStatus));
        sb.append(", nodes=").append(String.valueOf(this.nodes));
        sb.append(", routeAnalysisDescription=").append(String.valueOf(this.routeAnalysisDescription));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TrafficRoute)) {
            return false;
        }
        TrafficRoute other = (TrafficRoute)((Object)o);
        return Objects.equals((Object)this.reachabilityStatus, (Object)other.reachabilityStatus) && Objects.equals(this.nodes, other.nodes) && Objects.equals(this.routeAnalysisDescription, other.routeAnalysisDescription) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.reachabilityStatus == null ? 43 : this.reachabilityStatus.hashCode());
        result = result * 59 + (this.nodes == null ? 43 : this.nodes.hashCode());
        result = result * 59 + (this.routeAnalysisDescription == null ? 43 : this.routeAnalysisDescription.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ReachabilityStatus implements BmcEnum
    {
        Reachable("REACHABLE"),
        Unreachable("UNREACHABLE"),
        Indeterminate("INDETERMINATE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ReachabilityStatus> map;

        private ReachabilityStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ReachabilityStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ReachabilityStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ReachabilityStatus.class);
            map = new HashMap<String, ReachabilityStatus>();
            for (ReachabilityStatus v : ReachabilityStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="reachabilityStatus")
        private ReachabilityStatus reachabilityStatus;
        @JsonProperty(value="nodes")
        private List<TrafficNode> nodes;
        @JsonProperty(value="routeAnalysisDescription")
        private String routeAnalysisDescription;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder reachabilityStatus(ReachabilityStatus reachabilityStatus) {
            this.reachabilityStatus = reachabilityStatus;
            this.__explicitlySet__.add("reachabilityStatus");
            return this;
        }

        public Builder nodes(List<TrafficNode> nodes) {
            this.nodes = nodes;
            this.__explicitlySet__.add("nodes");
            return this;
        }

        public Builder routeAnalysisDescription(String routeAnalysisDescription) {
            this.routeAnalysisDescription = routeAnalysisDescription;
            this.__explicitlySet__.add("routeAnalysisDescription");
            return this;
        }

        public TrafficRoute build() {
            TrafficRoute model = new TrafficRoute(this.reachabilityStatus, this.nodes, this.routeAnalysisDescription);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TrafficRoute model) {
            if (model.wasPropertyExplicitlySet("reachabilityStatus")) {
                this.reachabilityStatus(model.getReachabilityStatus());
            }
            if (model.wasPropertyExplicitlySet("nodes")) {
                this.nodes(model.getNodes());
            }
            if (model.wasPropertyExplicitlySet("routeAnalysisDescription")) {
                this.routeAnalysisDescription(model.getRouteAnalysisDescription());
            }
            return this;
        }
    }
}

