/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.vnmonitoring.model.AccessDeniedTrafficNode;
import com.oracle.bmc.vnmonitoring.model.EgressTrafficSpec;
import com.oracle.bmc.vnmonitoring.model.RoutingAction;
import com.oracle.bmc.vnmonitoring.model.SecurityAction;
import com.oracle.bmc.vnmonitoring.model.VisibleTrafficNode;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=TrafficNode.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=VisibleTrafficNode.class, name="VISIBLE"), @JsonSubTypes.Type(value=AccessDeniedTrafficNode.class, name="ACCESS_DENIED")})
@JsonFilter(value="explicitlySetFilter")
public class TrafficNode
extends ExplicitlySetBmcModel {
    @JsonProperty(value="egressTraffic")
    private final EgressTrafficSpec egressTraffic;
    @JsonProperty(value="nextHopRoutingAction")
    private final RoutingAction nextHopRoutingAction;
    @JsonProperty(value="egressSecurityAction")
    private final SecurityAction egressSecurityAction;
    @JsonProperty(value="ingressSecurityAction")
    private final SecurityAction ingressSecurityAction;

    @Deprecated
    @ConstructorProperties(value={"egressTraffic", "nextHopRoutingAction", "egressSecurityAction", "ingressSecurityAction"})
    protected TrafficNode(EgressTrafficSpec egressTraffic, RoutingAction nextHopRoutingAction, SecurityAction egressSecurityAction, SecurityAction ingressSecurityAction) {
        this.egressTraffic = egressTraffic;
        this.nextHopRoutingAction = nextHopRoutingAction;
        this.egressSecurityAction = egressSecurityAction;
        this.ingressSecurityAction = ingressSecurityAction;
    }

    public EgressTrafficSpec getEgressTraffic() {
        return this.egressTraffic;
    }

    public RoutingAction getNextHopRoutingAction() {
        return this.nextHopRoutingAction;
    }

    public SecurityAction getEgressSecurityAction() {
        return this.egressSecurityAction;
    }

    public SecurityAction getIngressSecurityAction() {
        return this.ingressSecurityAction;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TrafficNode(");
        sb.append("super=").append(super.toString());
        sb.append("egressTraffic=").append(String.valueOf((Object)this.egressTraffic));
        sb.append(", nextHopRoutingAction=").append(String.valueOf((Object)this.nextHopRoutingAction));
        sb.append(", egressSecurityAction=").append(String.valueOf((Object)this.egressSecurityAction));
        sb.append(", ingressSecurityAction=").append(String.valueOf((Object)this.ingressSecurityAction));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TrafficNode)) {
            return false;
        }
        TrafficNode other = (TrafficNode)((Object)o);
        return Objects.equals((Object)this.egressTraffic, (Object)other.egressTraffic) && Objects.equals((Object)this.nextHopRoutingAction, (Object)other.nextHopRoutingAction) && Objects.equals((Object)this.egressSecurityAction, (Object)other.egressSecurityAction) && Objects.equals((Object)this.ingressSecurityAction, (Object)other.ingressSecurityAction) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.egressTraffic == null ? 43 : this.egressTraffic.hashCode());
        result = result * 59 + (this.nextHopRoutingAction == null ? 43 : this.nextHopRoutingAction.hashCode());
        result = result * 59 + (this.egressSecurityAction == null ? 43 : this.egressSecurityAction.hashCode());
        result = result * 59 + (this.ingressSecurityAction == null ? 43 : this.ingressSecurityAction.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Visible("VISIBLE"),
        AccessDenied("ACCESS_DENIED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

