/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TopologyRoutesToRelationshipDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="destinationType")
    private final String destinationType;
    @JsonProperty(value="destination")
    private final String destination;
    @JsonProperty(value="routeTableId")
    private final String routeTableId;
    @JsonProperty(value="routeType")
    private final RouteType routeType;

    @Deprecated
    @ConstructorProperties(value={"destinationType", "destination", "routeTableId", "routeType"})
    public TopologyRoutesToRelationshipDetails(String destinationType, String destination, String routeTableId, RouteType routeType) {
        this.destinationType = destinationType;
        this.destination = destination;
        this.routeTableId = routeTableId;
        this.routeType = routeType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getRouteTableId() {
        return this.routeTableId;
    }

    public RouteType getRouteType() {
        return this.routeType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TopologyRoutesToRelationshipDetails(");
        sb.append("super=").append(super.toString());
        sb.append("destinationType=").append(String.valueOf(this.destinationType));
        sb.append(", destination=").append(String.valueOf(this.destination));
        sb.append(", routeTableId=").append(String.valueOf(this.routeTableId));
        sb.append(", routeType=").append(String.valueOf((Object)this.routeType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopologyRoutesToRelationshipDetails)) {
            return false;
        }
        TopologyRoutesToRelationshipDetails other = (TopologyRoutesToRelationshipDetails)((Object)o);
        return Objects.equals(this.destinationType, other.destinationType) && Objects.equals(this.destination, other.destination) && Objects.equals(this.routeTableId, other.routeTableId) && Objects.equals((Object)this.routeType, (Object)other.routeType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.destinationType == null ? 43 : this.destinationType.hashCode());
        result = result * 59 + (this.destination == null ? 43 : this.destination.hashCode());
        result = result * 59 + (this.routeTableId == null ? 43 : this.routeTableId.hashCode());
        result = result * 59 + (this.routeType == null ? 43 : this.routeType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum RouteType implements BmcEnum
    {
        Static("STATIC"),
        Dynamic("DYNAMIC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RouteType> map;

        private RouteType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RouteType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RouteType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RouteType.class);
            map = new HashMap<String, RouteType>();
            for (RouteType v : RouteType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="destinationType")
        private String destinationType;
        @JsonProperty(value="destination")
        private String destination;
        @JsonProperty(value="routeTableId")
        private String routeTableId;
        @JsonProperty(value="routeType")
        private RouteType routeType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            this.__explicitlySet__.add("destinationType");
            return this;
        }

        public Builder destination(String destination) {
            this.destination = destination;
            this.__explicitlySet__.add("destination");
            return this;
        }

        public Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            this.__explicitlySet__.add("routeTableId");
            return this;
        }

        public Builder routeType(RouteType routeType) {
            this.routeType = routeType;
            this.__explicitlySet__.add("routeType");
            return this;
        }

        public TopologyRoutesToRelationshipDetails build() {
            TopologyRoutesToRelationshipDetails model = new TopologyRoutesToRelationshipDetails(this.destinationType, this.destination, this.routeTableId, this.routeType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TopologyRoutesToRelationshipDetails model) {
            if (model.wasPropertyExplicitlySet("destinationType")) {
                this.destinationType(model.getDestinationType());
            }
            if (model.wasPropertyExplicitlySet("destination")) {
                this.destination(model.getDestination());
            }
            if (model.wasPropertyExplicitlySet("routeTableId")) {
                this.routeTableId(model.getRouteTableId());
            }
            if (model.wasPropertyExplicitlySet("routeType")) {
                this.routeType(model.getRouteType());
            }
            return this;
        }
    }
}

