/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.vnmonitoring.model.NetworkingTopology;
import com.oracle.bmc.vnmonitoring.model.PathTopology;
import com.oracle.bmc.vnmonitoring.model.SubnetTopology;
import com.oracle.bmc.vnmonitoring.model.TopologyEntityRelationship;
import com.oracle.bmc.vnmonitoring.model.VcnTopology;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=Topology.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=VcnTopology.class, name="VCN"), @JsonSubTypes.Type(value=PathTopology.class, name="PATH"), @JsonSubTypes.Type(value=NetworkingTopology.class, name="NETWORKING"), @JsonSubTypes.Type(value=SubnetTopology.class, name="SUBNET")})
@JsonFilter(value="explicitlySetFilter")
public class Topology
extends ExplicitlySetBmcModel {
    @JsonProperty(value="entities")
    private final List<Object> entities;
    @JsonProperty(value="relationships")
    private final List<TopologyEntityRelationship> relationships;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;

    @Deprecated
    @ConstructorProperties(value={"entities", "relationships", "timeCreated"})
    protected Topology(List<Object> entities, List<TopologyEntityRelationship> relationships, Date timeCreated) {
        this.entities = entities;
        this.relationships = relationships;
        this.timeCreated = timeCreated;
    }

    public List<Object> getEntities() {
        return this.entities;
    }

    public List<TopologyEntityRelationship> getRelationships() {
        return this.relationships;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Topology(");
        sb.append("super=").append(super.toString());
        sb.append("entities=").append(String.valueOf(this.entities));
        sb.append(", relationships=").append(String.valueOf(this.relationships));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Topology)) {
            return false;
        }
        Topology other = (Topology)((Object)o);
        return Objects.equals(this.entities, other.entities) && Objects.equals(this.relationships, other.relationships) && Objects.equals(this.timeCreated, other.timeCreated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.entities == null ? 43 : this.entities.hashCode());
        result = result * 59 + (this.relationships == null ? 43 : this.relationships.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Networking("NETWORKING"),
        Vcn("VCN"),
        Subnet("SUBNET"),
        Path("PATH");

        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Type: " + key);
        }

        static {
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

