/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.vnmonitoring.model.Topology;
import com.oracle.bmc.vnmonitoring.model.TopologyEntityRelationship;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class SubnetTopology
extends Topology {
    @JsonProperty(value="subnetId")
    private final String subnetId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SubnetTopology(List<Object> entities, List<TopologyEntityRelationship> relationships, Date timeCreated, String subnetId) {
        super(entities, relationships, timeCreated);
        this.subnetId = subnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SubnetTopology(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubnetTopology)) {
            return false;
        }
        SubnetTopology other = (SubnetTopology)((Object)o);
        return Objects.equals(this.subnetId, other.subnetId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="entities")
        private List<Object> entities;
        @JsonProperty(value="relationships")
        private List<TopologyEntityRelationship> relationships;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder entities(List<Object> entities) {
            this.entities = entities;
            this.__explicitlySet__.add("entities");
            return this;
        }

        public Builder relationships(List<TopologyEntityRelationship> relationships) {
            this.relationships = relationships;
            this.__explicitlySet__.add("relationships");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public SubnetTopology build() {
            SubnetTopology model = new SubnetTopology(this.entities, this.relationships, this.timeCreated, this.subnetId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SubnetTopology model) {
            if (model.wasPropertyExplicitlySet("entities")) {
                this.entities(model.getEntities());
            }
            if (model.wasPropertyExplicitlySet("relationships")) {
                this.relationships(model.getRelationships());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            return this;
        }
    }
}

