/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.vnmonitoring.model.AllowedSecurityConfiguration;
import com.oracle.bmc.vnmonitoring.model.IngressSecurityRule;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class StatefulEgressSecurityListConfiguration
extends AllowedSecurityConfiguration {
    @JsonProperty(value="securityListId")
    private final String securityListId;
    @JsonProperty(value="securityRule")
    private final IngressSecurityRule securityRule;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public StatefulEgressSecurityListConfiguration(String securityListId, IngressSecurityRule securityRule) {
        this.securityListId = securityListId;
        this.securityRule = securityRule;
    }

    public String getSecurityListId() {
        return this.securityListId;
    }

    public IngressSecurityRule getSecurityRule() {
        return this.securityRule;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StatefulEgressSecurityListConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", securityListId=").append(String.valueOf(this.securityListId));
        sb.append(", securityRule=").append(String.valueOf((Object)this.securityRule));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatefulEgressSecurityListConfiguration)) {
            return false;
        }
        StatefulEgressSecurityListConfiguration other = (StatefulEgressSecurityListConfiguration)((Object)o);
        return Objects.equals(this.securityListId, other.securityListId) && Objects.equals((Object)this.securityRule, (Object)other.securityRule) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.securityListId == null ? 43 : this.securityListId.hashCode());
        result = result * 59 + (this.securityRule == null ? 43 : this.securityRule.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="securityListId")
        private String securityListId;
        @JsonProperty(value="securityRule")
        private IngressSecurityRule securityRule;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder securityListId(String securityListId) {
            this.securityListId = securityListId;
            this.__explicitlySet__.add("securityListId");
            return this;
        }

        public Builder securityRule(IngressSecurityRule securityRule) {
            this.securityRule = securityRule;
            this.__explicitlySet__.add("securityRule");
            return this;
        }

        public StatefulEgressSecurityListConfiguration build() {
            StatefulEgressSecurityListConfiguration model = new StatefulEgressSecurityListConfiguration(this.securityListId, this.securityRule);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StatefulEgressSecurityListConfiguration model) {
            if (model.wasPropertyExplicitlySet("securityListId")) {
                this.securityListId(model.getSecurityListId());
            }
            if (model.wasPropertyExplicitlySet("securityRule")) {
                this.securityRule(model.getSecurityRule());
            }
            return this;
        }
    }
}

