/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PublicIp
extends ExplicitlySetBmcModel {
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="ipAddress")
    private final String ipAddress;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifetime")
    private final Lifetime lifetime;
    @JsonProperty(value="privateIpId")
    private final String privateIpId;
    @JsonProperty(value="scope")
    private final Scope scope;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;

    @Deprecated
    @ConstructorProperties(value={"availabilityDomain", "compartmentId", "definedTags", "displayName", "freeformTags", "id", "ipAddress", "lifecycleState", "lifetime", "privateIpId", "scope", "timeCreated"})
    public PublicIp(String availabilityDomain, String compartmentId, Map<String, Map<String, Object>> definedTags, String displayName, Map<String, String> freeformTags, String id, String ipAddress, LifecycleState lifecycleState, Lifetime lifetime, String privateIpId, Scope scope, Date timeCreated) {
        this.availabilityDomain = availabilityDomain;
        this.compartmentId = compartmentId;
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.freeformTags = freeformTags;
        this.id = id;
        this.ipAddress = ipAddress;
        this.lifecycleState = lifecycleState;
        this.lifetime = lifetime;
        this.privateIpId = privateIpId;
        this.scope = scope;
        this.timeCreated = timeCreated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getId() {
        return this.id;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Lifetime getLifetime() {
        return this.lifetime;
    }

    public String getPrivateIpId() {
        return this.privateIpId;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PublicIp(");
        sb.append("super=").append(super.toString());
        sb.append("availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", ipAddress=").append(String.valueOf(this.ipAddress));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifetime=").append(String.valueOf((Object)this.lifetime));
        sb.append(", privateIpId=").append(String.valueOf(this.privateIpId));
        sb.append(", scope=").append(String.valueOf((Object)this.scope));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublicIp)) {
            return false;
        }
        PublicIp other = (PublicIp)((Object)o);
        return Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.id, other.id) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.lifetime, (Object)other.lifetime) && Objects.equals(this.privateIpId, other.privateIpId) && Objects.equals((Object)this.scope, (Object)other.scope) && Objects.equals(this.timeCreated, other.timeCreated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.ipAddress == null ? 43 : this.ipAddress.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifetime == null ? 43 : this.lifetime.hashCode());
        result = result * 59 + (this.privateIpId == null ? 43 : this.privateIpId.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Scope implements BmcEnum
    {
        Region("REGION"),
        AvailabilityDomain("AVAILABILITY_DOMAIN");

        private final String value;
        private static Map<String, Scope> map;

        private Scope(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Scope create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Scope: " + key);
        }

        static {
            map = new HashMap<String, Scope>();
            for (Scope v : Scope.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Lifetime implements BmcEnum
    {
        Ephemeral("EPHEMERAL"),
        Reserved("RESERVED");

        private final String value;
        private static Map<String, Lifetime> map;

        private Lifetime(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Lifetime create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Lifetime: " + key);
        }

        static {
            map = new HashMap<String, Lifetime>();
            for (Lifetime v : Lifetime.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Assigning("ASSIGNING"),
        Assigned("ASSIGNED"),
        Unassigning("UNASSIGNING"),
        Unassigned("UNASSIGNED"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED");

        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LifecycleState: " + key);
        }

        static {
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifetime")
        private Lifetime lifetime;
        @JsonProperty(value="privateIpId")
        private String privateIpId;
        @JsonProperty(value="scope")
        private Scope scope;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.__explicitlySet__.add("ipAddress");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifetime(Lifetime lifetime) {
            this.lifetime = lifetime;
            this.__explicitlySet__.add("lifetime");
            return this;
        }

        public Builder privateIpId(String privateIpId) {
            this.privateIpId = privateIpId;
            this.__explicitlySet__.add("privateIpId");
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            this.__explicitlySet__.add("scope");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public PublicIp build() {
            PublicIp model = new PublicIp(this.availabilityDomain, this.compartmentId, this.definedTags, this.displayName, this.freeformTags, this.id, this.ipAddress, this.lifecycleState, this.lifetime, this.privateIpId, this.scope, this.timeCreated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PublicIp model) {
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("ipAddress")) {
                this.ipAddress(model.getIpAddress());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifetime")) {
                this.lifetime(model.getLifetime());
            }
            if (model.wasPropertyExplicitlySet("privateIpId")) {
                this.privateIpId(model.getPrivateIpId());
            }
            if (model.wasPropertyExplicitlySet("scope")) {
                this.scope(model.getScope());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            return this;
        }
    }
}

