/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.vnmonitoring.model.AllowedSecurityConfiguration;
import com.oracle.bmc.vnmonitoring.model.SecurityRule;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class NsgConfiguration
extends AllowedSecurityConfiguration {
    @JsonProperty(value="nsgId")
    private final String nsgId;
    @JsonProperty(value="securityRule")
    private final SecurityRule securityRule;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public NsgConfiguration(String nsgId, SecurityRule securityRule) {
        this.nsgId = nsgId;
        this.securityRule = securityRule;
    }

    public String getNsgId() {
        return this.nsgId;
    }

    public SecurityRule getSecurityRule() {
        return this.securityRule;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NsgConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", nsgId=").append(String.valueOf(this.nsgId));
        sb.append(", securityRule=").append(String.valueOf((Object)this.securityRule));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NsgConfiguration)) {
            return false;
        }
        NsgConfiguration other = (NsgConfiguration)((Object)o);
        return Objects.equals(this.nsgId, other.nsgId) && Objects.equals((Object)this.securityRule, (Object)other.securityRule) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.nsgId == null ? 43 : this.nsgId.hashCode());
        result = result * 59 + (this.securityRule == null ? 43 : this.securityRule.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="nsgId")
        private String nsgId;
        @JsonProperty(value="securityRule")
        private SecurityRule securityRule;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder nsgId(String nsgId) {
            this.nsgId = nsgId;
            this.__explicitlySet__.add("nsgId");
            return this;
        }

        public Builder securityRule(SecurityRule securityRule) {
            this.securityRule = securityRule;
            this.__explicitlySet__.add("securityRule");
            return this;
        }

        public NsgConfiguration build() {
            NsgConfiguration model = new NsgConfiguration(this.nsgId, this.securityRule);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NsgConfiguration model) {
            if (model.wasPropertyExplicitlySet("nsgId")) {
                this.nsgId(model.getNsgId());
            }
            if (model.wasPropertyExplicitlySet("securityRule")) {
                this.securityRule(model.getSecurityRule());
            }
            return this;
        }
    }
}

