/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.vnmonitoring.model.IcmpOptions;
import com.oracle.bmc.vnmonitoring.model.TcpOptions;
import com.oracle.bmc.vnmonitoring.model.UdpOptions;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IngressSecurityRule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="icmpOptions")
    private final IcmpOptions icmpOptions;
    @JsonProperty(value="isStateless")
    private final Boolean isStateless;
    @JsonProperty(value="protocol")
    private final String protocol;
    @JsonProperty(value="source")
    private final String source;
    @JsonProperty(value="sourceType")
    private final SourceType sourceType;
    @JsonProperty(value="tcpOptions")
    private final TcpOptions tcpOptions;
    @JsonProperty(value="udpOptions")
    private final UdpOptions udpOptions;

    @Deprecated
    @ConstructorProperties(value={"icmpOptions", "isStateless", "protocol", "source", "sourceType", "tcpOptions", "udpOptions"})
    public IngressSecurityRule(IcmpOptions icmpOptions, Boolean isStateless, String protocol, String source, SourceType sourceType, TcpOptions tcpOptions, UdpOptions udpOptions) {
        this.icmpOptions = icmpOptions;
        this.isStateless = isStateless;
        this.protocol = protocol;
        this.source = source;
        this.sourceType = sourceType;
        this.tcpOptions = tcpOptions;
        this.udpOptions = udpOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public IcmpOptions getIcmpOptions() {
        return this.icmpOptions;
    }

    public Boolean getIsStateless() {
        return this.isStateless;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getSource() {
        return this.source;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public TcpOptions getTcpOptions() {
        return this.tcpOptions;
    }

    public UdpOptions getUdpOptions() {
        return this.udpOptions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IngressSecurityRule(");
        sb.append("super=").append(super.toString());
        sb.append("icmpOptions=").append(String.valueOf((Object)this.icmpOptions));
        sb.append(", isStateless=").append(String.valueOf(this.isStateless));
        sb.append(", protocol=").append(String.valueOf(this.protocol));
        sb.append(", source=").append(String.valueOf(this.source));
        sb.append(", sourceType=").append(String.valueOf((Object)this.sourceType));
        sb.append(", tcpOptions=").append(String.valueOf((Object)this.tcpOptions));
        sb.append(", udpOptions=").append(String.valueOf((Object)this.udpOptions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IngressSecurityRule)) {
            return false;
        }
        IngressSecurityRule other = (IngressSecurityRule)((Object)o);
        return Objects.equals((Object)this.icmpOptions, (Object)other.icmpOptions) && Objects.equals(this.isStateless, other.isStateless) && Objects.equals(this.protocol, other.protocol) && Objects.equals(this.source, other.source) && Objects.equals((Object)this.sourceType, (Object)other.sourceType) && Objects.equals((Object)this.tcpOptions, (Object)other.tcpOptions) && Objects.equals((Object)this.udpOptions, (Object)other.udpOptions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.icmpOptions == null ? 43 : this.icmpOptions.hashCode());
        result = result * 59 + (this.isStateless == null ? 43 : this.isStateless.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.source == null ? 43 : this.source.hashCode());
        result = result * 59 + (this.sourceType == null ? 43 : this.sourceType.hashCode());
        result = result * 59 + (this.tcpOptions == null ? 43 : this.tcpOptions.hashCode());
        result = result * 59 + (this.udpOptions == null ? 43 : this.udpOptions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum SourceType implements BmcEnum
    {
        CidrBlock("CIDR_BLOCK"),
        ServiceCidrBlock("SERVICE_CIDR_BLOCK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SourceType> map;

        private SourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SourceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SourceType.class);
            map = new HashMap<String, SourceType>();
            for (SourceType v : SourceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="icmpOptions")
        private IcmpOptions icmpOptions;
        @JsonProperty(value="isStateless")
        private Boolean isStateless;
        @JsonProperty(value="protocol")
        private String protocol;
        @JsonProperty(value="source")
        private String source;
        @JsonProperty(value="sourceType")
        private SourceType sourceType;
        @JsonProperty(value="tcpOptions")
        private TcpOptions tcpOptions;
        @JsonProperty(value="udpOptions")
        private UdpOptions udpOptions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder icmpOptions(IcmpOptions icmpOptions) {
            this.icmpOptions = icmpOptions;
            this.__explicitlySet__.add("icmpOptions");
            return this;
        }

        public Builder isStateless(Boolean isStateless) {
            this.isStateless = isStateless;
            this.__explicitlySet__.add("isStateless");
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder sourceType(SourceType sourceType) {
            this.sourceType = sourceType;
            this.__explicitlySet__.add("sourceType");
            return this;
        }

        public Builder tcpOptions(TcpOptions tcpOptions) {
            this.tcpOptions = tcpOptions;
            this.__explicitlySet__.add("tcpOptions");
            return this;
        }

        public Builder udpOptions(UdpOptions udpOptions) {
            this.udpOptions = udpOptions;
            this.__explicitlySet__.add("udpOptions");
            return this;
        }

        public IngressSecurityRule build() {
            IngressSecurityRule model = new IngressSecurityRule(this.icmpOptions, this.isStateless, this.protocol, this.source, this.sourceType, this.tcpOptions, this.udpOptions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IngressSecurityRule model) {
            if (model.wasPropertyExplicitlySet("icmpOptions")) {
                this.icmpOptions(model.getIcmpOptions());
            }
            if (model.wasPropertyExplicitlySet("isStateless")) {
                this.isStateless(model.getIsStateless());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("sourceType")) {
                this.sourceType(model.getSourceType());
            }
            if (model.wasPropertyExplicitlySet("tcpOptions")) {
                this.tcpOptions(model.getTcpOptions());
            }
            if (model.wasPropertyExplicitlySet("udpOptions")) {
                this.udpOptions(model.getUdpOptions());
            }
            return this;
        }
    }
}

