/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.vnmonitoring.model.TrafficProtocolParameters;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EgressTrafficSpec
extends ExplicitlySetBmcModel {
    @JsonProperty(value="protocol")
    private final Integer protocol;
    @JsonProperty(value="sourceAddress")
    private final String sourceAddress;
    @JsonProperty(value="destinationAddress")
    private final String destinationAddress;
    @JsonProperty(value="trafficProtocolParameters")
    private final TrafficProtocolParameters trafficProtocolParameters;

    @Deprecated
    @ConstructorProperties(value={"protocol", "sourceAddress", "destinationAddress", "trafficProtocolParameters"})
    public EgressTrafficSpec(Integer protocol, String sourceAddress, String destinationAddress, TrafficProtocolParameters trafficProtocolParameters) {
        this.protocol = protocol;
        this.sourceAddress = sourceAddress;
        this.destinationAddress = destinationAddress;
        this.trafficProtocolParameters = trafficProtocolParameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getProtocol() {
        return this.protocol;
    }

    public String getSourceAddress() {
        return this.sourceAddress;
    }

    public String getDestinationAddress() {
        return this.destinationAddress;
    }

    public TrafficProtocolParameters getTrafficProtocolParameters() {
        return this.trafficProtocolParameters;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EgressTrafficSpec(");
        sb.append("super=").append(super.toString());
        sb.append("protocol=").append(String.valueOf(this.protocol));
        sb.append(", sourceAddress=").append(String.valueOf(this.sourceAddress));
        sb.append(", destinationAddress=").append(String.valueOf(this.destinationAddress));
        sb.append(", trafficProtocolParameters=").append(String.valueOf((Object)this.trafficProtocolParameters));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EgressTrafficSpec)) {
            return false;
        }
        EgressTrafficSpec other = (EgressTrafficSpec)((Object)o);
        return Objects.equals(this.protocol, other.protocol) && Objects.equals(this.sourceAddress, other.sourceAddress) && Objects.equals(this.destinationAddress, other.destinationAddress) && Objects.equals((Object)this.trafficProtocolParameters, (Object)other.trafficProtocolParameters) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.sourceAddress == null ? 43 : this.sourceAddress.hashCode());
        result = result * 59 + (this.destinationAddress == null ? 43 : this.destinationAddress.hashCode());
        result = result * 59 + (this.trafficProtocolParameters == null ? 43 : this.trafficProtocolParameters.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="protocol")
        private Integer protocol;
        @JsonProperty(value="sourceAddress")
        private String sourceAddress;
        @JsonProperty(value="destinationAddress")
        private String destinationAddress;
        @JsonProperty(value="trafficProtocolParameters")
        private TrafficProtocolParameters trafficProtocolParameters;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder protocol(Integer protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder sourceAddress(String sourceAddress) {
            this.sourceAddress = sourceAddress;
            this.__explicitlySet__.add("sourceAddress");
            return this;
        }

        public Builder destinationAddress(String destinationAddress) {
            this.destinationAddress = destinationAddress;
            this.__explicitlySet__.add("destinationAddress");
            return this;
        }

        public Builder trafficProtocolParameters(TrafficProtocolParameters trafficProtocolParameters) {
            this.trafficProtocolParameters = trafficProtocolParameters;
            this.__explicitlySet__.add("trafficProtocolParameters");
            return this;
        }

        public EgressTrafficSpec build() {
            EgressTrafficSpec model = new EgressTrafficSpec(this.protocol, this.sourceAddress, this.destinationAddress, this.trafficProtocolParameters);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EgressTrafficSpec model) {
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("sourceAddress")) {
                this.sourceAddress(model.getSourceAddress());
            }
            if (model.wasPropertyExplicitlySet("destinationAddress")) {
                this.destinationAddress(model.getDestinationAddress());
            }
            if (model.wasPropertyExplicitlySet("trafficProtocolParameters")) {
                this.trafficProtocolParameters(model.getTrafficProtocolParameters());
            }
            return this;
        }
    }
}

