/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.vnmonitoring.model.DrgRouteRule;
import com.oracle.bmc.vnmonitoring.model.ForwardedRoutingConfiguration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class DrgRoutingConfiguration
extends ForwardedRoutingConfiguration {
    @JsonProperty(value="drgRouteTableId")
    private final String drgRouteTableId;
    @JsonProperty(value="routeRule")
    private final DrgRouteRule routeRule;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DrgRoutingConfiguration(String drgRouteTableId, DrgRouteRule routeRule) {
        this.drgRouteTableId = drgRouteTableId;
        this.routeRule = routeRule;
    }

    public String getDrgRouteTableId() {
        return this.drgRouteTableId;
    }

    public DrgRouteRule getRouteRule() {
        return this.routeRule;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DrgRoutingConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", drgRouteTableId=").append(String.valueOf(this.drgRouteTableId));
        sb.append(", routeRule=").append(String.valueOf((Object)this.routeRule));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DrgRoutingConfiguration)) {
            return false;
        }
        DrgRoutingConfiguration other = (DrgRoutingConfiguration)((Object)o);
        return Objects.equals(this.drgRouteTableId, other.drgRouteTableId) && Objects.equals((Object)this.routeRule, (Object)other.routeRule) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.drgRouteTableId == null ? 43 : this.drgRouteTableId.hashCode());
        result = result * 59 + (this.routeRule == null ? 43 : this.routeRule.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="drgRouteTableId")
        private String drgRouteTableId;
        @JsonProperty(value="routeRule")
        private DrgRouteRule routeRule;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder drgRouteTableId(String drgRouteTableId) {
            this.drgRouteTableId = drgRouteTableId;
            this.__explicitlySet__.add("drgRouteTableId");
            return this;
        }

        public Builder routeRule(DrgRouteRule routeRule) {
            this.routeRule = routeRule;
            this.__explicitlySet__.add("routeRule");
            return this;
        }

        public DrgRoutingConfiguration build() {
            DrgRoutingConfiguration model = new DrgRoutingConfiguration(this.drgRouteTableId, this.routeRule);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DrgRoutingConfiguration model) {
            if (model.wasPropertyExplicitlySet("drgRouteTableId")) {
                this.drgRouteTableId(model.getDrgRouteTableId());
            }
            if (model.wasPropertyExplicitlySet("routeRule")) {
                this.routeRule(model.getRouteRule());
            }
            return this;
        }
    }
}

