/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.vnmonitoring.model.DhcpOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class DhcpDnsOption
extends DhcpOption {
    @JsonProperty(value="customDnsServers")
    private final List<String> customDnsServers;
    @JsonProperty(value="serverType")
    private final ServerType serverType;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DhcpDnsOption(List<String> customDnsServers, ServerType serverType) {
        this.customDnsServers = customDnsServers;
        this.serverType = serverType;
    }

    public List<String> getCustomDnsServers() {
        return this.customDnsServers;
    }

    public ServerType getServerType() {
        return this.serverType;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DhcpDnsOption(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", customDnsServers=").append(String.valueOf(this.customDnsServers));
        sb.append(", serverType=").append(String.valueOf((Object)this.serverType));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DhcpDnsOption)) {
            return false;
        }
        DhcpDnsOption other = (DhcpDnsOption)((Object)o);
        return Objects.equals(this.customDnsServers, other.customDnsServers) && Objects.equals((Object)this.serverType, (Object)other.serverType) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.customDnsServers == null ? 43 : this.customDnsServers.hashCode());
        result = result * 59 + (this.serverType == null ? 43 : this.serverType.hashCode());
        return result;
    }

    public static enum ServerType implements BmcEnum
    {
        VcnLocal("VcnLocal"),
        VcnLocalPlusInternet("VcnLocalPlusInternet"),
        CustomDnsServer("CustomDnsServer");

        private final String value;
        private static Map<String, ServerType> map;

        private ServerType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ServerType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ServerType: " + key);
        }

        static {
            map = new HashMap<String, ServerType>();
            for (ServerType v : ServerType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="customDnsServers")
        private List<String> customDnsServers;
        @JsonProperty(value="serverType")
        private ServerType serverType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder customDnsServers(List<String> customDnsServers) {
            this.customDnsServers = customDnsServers;
            this.__explicitlySet__.add("customDnsServers");
            return this;
        }

        public Builder serverType(ServerType serverType) {
            this.serverType = serverType;
            this.__explicitlySet__.add("serverType");
            return this;
        }

        public DhcpDnsOption build() {
            DhcpDnsOption model = new DhcpDnsOption(this.customDnsServers, this.serverType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DhcpDnsOption model) {
            if (model.wasPropertyExplicitlySet("customDnsServers")) {
                this.customDnsServers(model.getCustomDnsServers());
            }
            if (model.wasPropertyExplicitlySet("serverType")) {
                this.serverType(model.getServerType());
            }
            return this;
        }
    }
}

