/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CrossConnectStatus
extends ExplicitlySetBmcModel {
    @JsonProperty(value="crossConnectId")
    private final String crossConnectId;
    @JsonProperty(value="interfaceState")
    private final InterfaceState interfaceState;
    @JsonProperty(value="lightLevelIndBm")
    private final Float lightLevelIndBm;
    @JsonProperty(value="lightLevelIndicator")
    private final LightLevelIndicator lightLevelIndicator;

    @Deprecated
    @ConstructorProperties(value={"crossConnectId", "interfaceState", "lightLevelIndBm", "lightLevelIndicator"})
    public CrossConnectStatus(String crossConnectId, InterfaceState interfaceState, Float lightLevelIndBm, LightLevelIndicator lightLevelIndicator) {
        this.crossConnectId = crossConnectId;
        this.interfaceState = interfaceState;
        this.lightLevelIndBm = lightLevelIndBm;
        this.lightLevelIndicator = lightLevelIndicator;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCrossConnectId() {
        return this.crossConnectId;
    }

    public InterfaceState getInterfaceState() {
        return this.interfaceState;
    }

    public Float getLightLevelIndBm() {
        return this.lightLevelIndBm;
    }

    public LightLevelIndicator getLightLevelIndicator() {
        return this.lightLevelIndicator;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CrossConnectStatus(");
        sb.append("super=").append(super.toString());
        sb.append("crossConnectId=").append(String.valueOf(this.crossConnectId));
        sb.append(", interfaceState=").append(String.valueOf((Object)this.interfaceState));
        sb.append(", lightLevelIndBm=").append(String.valueOf(this.lightLevelIndBm));
        sb.append(", lightLevelIndicator=").append(String.valueOf((Object)this.lightLevelIndicator));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CrossConnectStatus)) {
            return false;
        }
        CrossConnectStatus other = (CrossConnectStatus)((Object)o);
        return Objects.equals(this.crossConnectId, other.crossConnectId) && Objects.equals((Object)this.interfaceState, (Object)other.interfaceState) && Objects.equals(this.lightLevelIndBm, other.lightLevelIndBm) && Objects.equals((Object)this.lightLevelIndicator, (Object)other.lightLevelIndicator) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.crossConnectId == null ? 43 : this.crossConnectId.hashCode());
        result = result * 59 + (this.interfaceState == null ? 43 : this.interfaceState.hashCode());
        result = result * 59 + (this.lightLevelIndBm == null ? 43 : this.lightLevelIndBm.hashCode());
        result = result * 59 + (this.lightLevelIndicator == null ? 43 : this.lightLevelIndicator.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LightLevelIndicator implements BmcEnum
    {
        NoLight("NO_LIGHT"),
        LowWarn("LOW_WARN"),
        HighWarn("HIGH_WARN"),
        Bad("BAD"),
        Good("GOOD");

        private final String value;
        private static Map<String, LightLevelIndicator> map;

        private LightLevelIndicator(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LightLevelIndicator create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LightLevelIndicator: " + key);
        }

        static {
            map = new HashMap<String, LightLevelIndicator>();
            for (LightLevelIndicator v : LightLevelIndicator.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum InterfaceState implements BmcEnum
    {
        Up("UP"),
        Down("DOWN");

        private final String value;
        private static Map<String, InterfaceState> map;

        private InterfaceState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static InterfaceState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid InterfaceState: " + key);
        }

        static {
            map = new HashMap<String, InterfaceState>();
            for (InterfaceState v : InterfaceState.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="crossConnectId")
        private String crossConnectId;
        @JsonProperty(value="interfaceState")
        private InterfaceState interfaceState;
        @JsonProperty(value="lightLevelIndBm")
        private Float lightLevelIndBm;
        @JsonProperty(value="lightLevelIndicator")
        private LightLevelIndicator lightLevelIndicator;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder crossConnectId(String crossConnectId) {
            this.crossConnectId = crossConnectId;
            this.__explicitlySet__.add("crossConnectId");
            return this;
        }

        public Builder interfaceState(InterfaceState interfaceState) {
            this.interfaceState = interfaceState;
            this.__explicitlySet__.add("interfaceState");
            return this;
        }

        public Builder lightLevelIndBm(Float lightLevelIndBm) {
            this.lightLevelIndBm = lightLevelIndBm;
            this.__explicitlySet__.add("lightLevelIndBm");
            return this;
        }

        public Builder lightLevelIndicator(LightLevelIndicator lightLevelIndicator) {
            this.lightLevelIndicator = lightLevelIndicator;
            this.__explicitlySet__.add("lightLevelIndicator");
            return this;
        }

        public CrossConnectStatus build() {
            CrossConnectStatus model = new CrossConnectStatus(this.crossConnectId, this.interfaceState, this.lightLevelIndBm, this.lightLevelIndicator);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CrossConnectStatus model) {
            if (model.wasPropertyExplicitlySet("crossConnectId")) {
                this.crossConnectId(model.getCrossConnectId());
            }
            if (model.wasPropertyExplicitlySet("interfaceState")) {
                this.interfaceState(model.getInterfaceState());
            }
            if (model.wasPropertyExplicitlySet("lightLevelIndBm")) {
                this.lightLevelIndBm(model.getLightLevelIndBm());
            }
            if (model.wasPropertyExplicitlySet("lightLevelIndicator")) {
                this.lightLevelIndicator(model.getLightLevelIndicator());
            }
            return this;
        }
    }
}

