/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.vnmonitoring.model.Endpoint;
import com.oracle.bmc.vnmonitoring.model.GetPathAnalysisDetails;
import com.oracle.bmc.vnmonitoring.model.ProtocolParameters;
import com.oracle.bmc.vnmonitoring.model.QueryOptions;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class AdhocGetPathAnalysisDetails
extends GetPathAnalysisDetails {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="protocol")
    private final Integer protocol;
    @JsonProperty(value="sourceEndpoint")
    private final Endpoint sourceEndpoint;
    @JsonProperty(value="destinationEndpoint")
    private final Endpoint destinationEndpoint;
    @JsonProperty(value="protocolParameters")
    private final ProtocolParameters protocolParameters;
    @JsonProperty(value="queryOptions")
    private final QueryOptions queryOptions;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public AdhocGetPathAnalysisDetails(String compartmentId, Integer protocol, Endpoint sourceEndpoint, Endpoint destinationEndpoint, ProtocolParameters protocolParameters, QueryOptions queryOptions) {
        this.compartmentId = compartmentId;
        this.protocol = protocol;
        this.sourceEndpoint = sourceEndpoint;
        this.destinationEndpoint = destinationEndpoint;
        this.protocolParameters = protocolParameters;
        this.queryOptions = queryOptions;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getProtocol() {
        return this.protocol;
    }

    public Endpoint getSourceEndpoint() {
        return this.sourceEndpoint;
    }

    public Endpoint getDestinationEndpoint() {
        return this.destinationEndpoint;
    }

    public ProtocolParameters getProtocolParameters() {
        return this.protocolParameters;
    }

    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AdhocGetPathAnalysisDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", protocol=").append(String.valueOf(this.protocol));
        sb.append(", sourceEndpoint=").append(String.valueOf((Object)this.sourceEndpoint));
        sb.append(", destinationEndpoint=").append(String.valueOf((Object)this.destinationEndpoint));
        sb.append(", protocolParameters=").append(String.valueOf((Object)this.protocolParameters));
        sb.append(", queryOptions=").append(String.valueOf((Object)this.queryOptions));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdhocGetPathAnalysisDetails)) {
            return false;
        }
        AdhocGetPathAnalysisDetails other = (AdhocGetPathAnalysisDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.protocol, other.protocol) && Objects.equals((Object)this.sourceEndpoint, (Object)other.sourceEndpoint) && Objects.equals((Object)this.destinationEndpoint, (Object)other.destinationEndpoint) && Objects.equals((Object)this.protocolParameters, (Object)other.protocolParameters) && Objects.equals((Object)this.queryOptions, (Object)other.queryOptions) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.sourceEndpoint == null ? 43 : this.sourceEndpoint.hashCode());
        result = result * 59 + (this.destinationEndpoint == null ? 43 : this.destinationEndpoint.hashCode());
        result = result * 59 + (this.protocolParameters == null ? 43 : this.protocolParameters.hashCode());
        result = result * 59 + (this.queryOptions == null ? 43 : this.queryOptions.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="protocol")
        private Integer protocol;
        @JsonProperty(value="sourceEndpoint")
        private Endpoint sourceEndpoint;
        @JsonProperty(value="destinationEndpoint")
        private Endpoint destinationEndpoint;
        @JsonProperty(value="protocolParameters")
        private ProtocolParameters protocolParameters;
        @JsonProperty(value="queryOptions")
        private QueryOptions queryOptions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder protocol(Integer protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder sourceEndpoint(Endpoint sourceEndpoint) {
            this.sourceEndpoint = sourceEndpoint;
            this.__explicitlySet__.add("sourceEndpoint");
            return this;
        }

        public Builder destinationEndpoint(Endpoint destinationEndpoint) {
            this.destinationEndpoint = destinationEndpoint;
            this.__explicitlySet__.add("destinationEndpoint");
            return this;
        }

        public Builder protocolParameters(ProtocolParameters protocolParameters) {
            this.protocolParameters = protocolParameters;
            this.__explicitlySet__.add("protocolParameters");
            return this;
        }

        public Builder queryOptions(QueryOptions queryOptions) {
            this.queryOptions = queryOptions;
            this.__explicitlySet__.add("queryOptions");
            return this;
        }

        public AdhocGetPathAnalysisDetails build() {
            AdhocGetPathAnalysisDetails model = new AdhocGetPathAnalysisDetails(this.compartmentId, this.protocol, this.sourceEndpoint, this.destinationEndpoint, this.protocolParameters, this.queryOptions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AdhocGetPathAnalysisDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("sourceEndpoint")) {
                this.sourceEndpoint(model.getSourceEndpoint());
            }
            if (model.wasPropertyExplicitlySet("destinationEndpoint")) {
                this.destinationEndpoint(model.getDestinationEndpoint());
            }
            if (model.wasPropertyExplicitlySet("protocolParameters")) {
                this.protocolParameters(model.getProtocolParameters());
            }
            if (model.wasPropertyExplicitlySet("queryOptions")) {
                this.queryOptions(model.getQueryOptions());
            }
            return this;
        }
    }
}

