/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring;

import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.vnmonitoring.VnMonitoring;
import com.oracle.bmc.vnmonitoring.model.PathAnalyzerTest;
import com.oracle.bmc.vnmonitoring.requests.GetPathAnalyzerTestRequest;
import com.oracle.bmc.vnmonitoring.requests.GetWorkRequestRequest;
import com.oracle.bmc.vnmonitoring.responses.GetPathAnalyzerTestResponse;
import com.oracle.bmc.vnmonitoring.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class VnMonitoringWaiters {
    private final ExecutorService executorService;
    private final VnMonitoring client;

    public VnMonitoringWaiters(ExecutorService executorService, VnMonitoring client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetPathAnalyzerTestRequest, GetPathAnalyzerTestResponse> forPathAnalyzerTest(GetPathAnalyzerTestRequest request, PathAnalyzerTest.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPathAnalyzerTest(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPathAnalyzerTestRequest, GetPathAnalyzerTestResponse> forPathAnalyzerTest(GetPathAnalyzerTestRequest request, PathAnalyzerTest.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPathAnalyzerTest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPathAnalyzerTestRequest, GetPathAnalyzerTestResponse> forPathAnalyzerTest(GetPathAnalyzerTestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, PathAnalyzerTest.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forPathAnalyzerTest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPathAnalyzerTestRequest, GetPathAnalyzerTestResponse> forPathAnalyzerTest(BmcGenericWaiter waiter, GetPathAnalyzerTestRequest request, PathAnalyzerTest.LifecycleState ... targetStates) {
        final HashSet<PathAnalyzerTest.LifecycleState> targetStatesSet = new HashSet<PathAnalyzerTest.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetPathAnalyzerTestRequest, GetPathAnalyzerTestResponse>(){

            @Override
            public GetPathAnalyzerTestResponse apply(GetPathAnalyzerTestRequest request) {
                return VnMonitoringWaiters.this.client.getPathAnalyzerTest(request);
            }
        }, (Predicate)new Predicate<GetPathAnalyzerTestResponse>(){

            @Override
            public boolean test(GetPathAnalyzerTestResponse response) {
                return targetStatesSet.contains((Object)response.getPathAnalyzerTest().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)PathAnalyzerTest.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return VnMonitoringWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

