/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vnmonitoring;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.vnmonitoring.VnMonitoring;
import com.oracle.bmc.vnmonitoring.model.PathAnalyzerTestSummary;
import com.oracle.bmc.vnmonitoring.model.WorkRequestError;
import com.oracle.bmc.vnmonitoring.model.WorkRequestLogEntry;
import com.oracle.bmc.vnmonitoring.model.WorkRequestResult;
import com.oracle.bmc.vnmonitoring.model.WorkRequestSummary;
import com.oracle.bmc.vnmonitoring.requests.ListPathAnalyzerTestsRequest;
import com.oracle.bmc.vnmonitoring.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.vnmonitoring.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.vnmonitoring.requests.ListWorkRequestResultsRequest;
import com.oracle.bmc.vnmonitoring.requests.ListWorkRequestsRequest;
import com.oracle.bmc.vnmonitoring.responses.ListPathAnalyzerTestsResponse;
import com.oracle.bmc.vnmonitoring.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.vnmonitoring.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.vnmonitoring.responses.ListWorkRequestResultsResponse;
import com.oracle.bmc.vnmonitoring.responses.ListWorkRequestsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class VnMonitoringPaginators {
    private final VnMonitoring client;

    public VnMonitoringPaginators(VnMonitoring client) {
        this.client = client;
    }

    public Iterable<ListPathAnalyzerTestsResponse> listPathAnalyzerTestsResponseIterator(final ListPathAnalyzerTestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPathAnalyzerTestsRequest.Builder>(){

            @Override
            public ListPathAnalyzerTestsRequest.Builder get() {
                return ListPathAnalyzerTestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPathAnalyzerTestsResponse, String>(){

            @Override
            public String apply(ListPathAnalyzerTestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPathAnalyzerTestsRequest.Builder>, ListPathAnalyzerTestsRequest>(){

            @Override
            public ListPathAnalyzerTestsRequest apply(RequestBuilderAndToken<ListPathAnalyzerTestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPathAnalyzerTestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPathAnalyzerTestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPathAnalyzerTestsRequest, ListPathAnalyzerTestsResponse>(){

            @Override
            public ListPathAnalyzerTestsResponse apply(ListPathAnalyzerTestsRequest request) {
                return VnMonitoringPaginators.this.client.listPathAnalyzerTests(request);
            }
        });
    }

    public Iterable<PathAnalyzerTestSummary> listPathAnalyzerTestsRecordIterator(final ListPathAnalyzerTestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPathAnalyzerTestsRequest.Builder>(){

            @Override
            public ListPathAnalyzerTestsRequest.Builder get() {
                return ListPathAnalyzerTestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPathAnalyzerTestsResponse, String>(){

            @Override
            public String apply(ListPathAnalyzerTestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPathAnalyzerTestsRequest.Builder>, ListPathAnalyzerTestsRequest>(){

            @Override
            public ListPathAnalyzerTestsRequest apply(RequestBuilderAndToken<ListPathAnalyzerTestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPathAnalyzerTestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPathAnalyzerTestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPathAnalyzerTestsRequest, ListPathAnalyzerTestsResponse>(){

            @Override
            public ListPathAnalyzerTestsResponse apply(ListPathAnalyzerTestsRequest request) {
                return VnMonitoringPaginators.this.client.listPathAnalyzerTests(request);
            }
        }, (Function)new Function<ListPathAnalyzerTestsResponse, List<PathAnalyzerTestSummary>>(){

            @Override
            public List<PathAnalyzerTestSummary> apply(ListPathAnalyzerTestsResponse response) {
                return response.getPathAnalyzerTestCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return VnMonitoringPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return VnMonitoringPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return VnMonitoringPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return VnMonitoringPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestResultsResponse> listWorkRequestResultsResponseIterator(final ListWorkRequestResultsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestResultsRequest.Builder>(){

            @Override
            public ListWorkRequestResultsRequest.Builder get() {
                return ListWorkRequestResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestResultsResponse, String>(){

            @Override
            public String apply(ListWorkRequestResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestResultsRequest.Builder>, ListWorkRequestResultsRequest>(){

            @Override
            public ListWorkRequestResultsRequest apply(RequestBuilderAndToken<ListWorkRequestResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestResultsRequest, ListWorkRequestResultsResponse>(){

            @Override
            public ListWorkRequestResultsResponse apply(ListWorkRequestResultsRequest request) {
                return VnMonitoringPaginators.this.client.listWorkRequestResults(request);
            }
        });
    }

    public Iterable<WorkRequestResult> listWorkRequestResultsRecordIterator(final ListWorkRequestResultsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestResultsRequest.Builder>(){

            @Override
            public ListWorkRequestResultsRequest.Builder get() {
                return ListWorkRequestResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestResultsResponse, String>(){

            @Override
            public String apply(ListWorkRequestResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestResultsRequest.Builder>, ListWorkRequestResultsRequest>(){

            @Override
            public ListWorkRequestResultsRequest apply(RequestBuilderAndToken<ListWorkRequestResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestResultsRequest, ListWorkRequestResultsResponse>(){

            @Override
            public ListWorkRequestResultsResponse apply(ListWorkRequestResultsRequest request) {
                return VnMonitoringPaginators.this.client.listWorkRequestResults(request);
            }
        }, (Function)new Function<ListWorkRequestResultsResponse, List<WorkRequestResult>>(){

            @Override
            public List<WorkRequestResult> apply(ListWorkRequestResultsResponse response) {
                return response.getWorkRequestResultCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return VnMonitoringPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return VnMonitoringPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

